/*************************************************/
/* OSPlus for Windows                            */
/* Version 1.0                                   */
/*                                               */
/* Copyright (c) Owen Software 2000              */
/* All Rights Reserved                           */
/*                                               */
/* Main module for executable program            */
/*************************************************/

#include <windows.h>
#include <stdio.h>
#include <malloc.h>
#include <ctl3d.h>
#include "comctl16.h"
#include "genwin.h"

HANDLE		hInst;
static char	OSPClass[32] = "ComCtlTest16";

HDC hDC;
int beenhere;
HWND hWndStatus;
HWND hWndUpDown;
HWND hWndToolbar;

static BOOL FirstInstance(HANDLE);
static BOOL AnyInstance(HANDLE, int, LPSTR);

long __export FAR PASCAL MainWindowProc(HWND, unsigned, UINT, LONG);

/*
 * WinMain - initialization, message loop
 */
int PASCAL WinMain(HINSTANCE hCurInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	hInst = hCurInstance;

	Ctl3dRegister(hCurInstance);
	Ctl3dAutoSubclass(hCurInstance);

	InitCommonControls();

	if (!hPrevInstance)
		if (!FirstInstance(hCurInstance)) return(FALSE);

	if (!AnyInstance(hCurInstance, nCmdShow, lpCmdLine)) return(FALSE);

	while (GetMessage(&msg, NULL, NULL, NULL))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	Ctl3dUnregister(hCurInstance);
	return( msg.wParam );
}

/*
 * FirstInstance - register window class for the application,
 *		   and do any other application initialization
 */
static BOOL FirstInstance( HANDLE this_inst )
{
	 WNDCLASS	wc;
	 BOOL	rc;

	 /*
	  * set up and register window class
	  */
	 wc.style = CS_SAVEBITS | CS_HREDRAW | CS_VREDRAW;
	 wc.lpfnWndProc = (LPVOID) MainWindowProc;
	 wc.cbClsExtra = 0;
	 wc.cbWndExtra = sizeof( DWORD );
	 wc.hInstance = this_inst;
	 wc.hIcon = LoadIcon( this_inst, MAKEINTRESOURCE(1));
	 wc.hCursor = LoadCursor( NULL, IDC_ARROW );
	 wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
    wc.lpszMenuName = MAKEINTRESOURCE(1);
	 wc.lpszClassName = OSPClass;
    rc = RegisterClass( &wc );
	 return( rc );

} /* FirstInstance */

/*
 * AnyInstance - do work required for every instance of the application:
 *		  create the window, initialize data
 */
static BOOL AnyInstance( HANDLE this_inst, int cmdshow, LPSTR cmdline )
{
	 TBBUTTON button[10];
	 HWND 	hwnd;
	 extra_data	*edata_ptr;
    int i;

    /*
	  * create main window
     */
	 hwnd = CreateWindow(
	OSPClass,		/* class */
	"Common Control Test Program",	/* caption */
	WS_OVERLAPPED | WS_MINIMIZEBOX | WS_BORDER | WS_CAPTION | WS_SYSMENU | WS_VISIBLE,	/* style */
	CW_USEDEFAULT,		/* init. x pos */
	CW_USEDEFAULT,		/* init. y pos */
	640,		/* init. x size */
	480,		/* init. y size */
	NULL,			/* parent window */
	NULL,			/* menu handle */
	this_inst,		/* program handle */
	NULL			/* create parms */
	);
		    
    if( !hwnd ) return( FALSE );

    /*
     * set up data associated with this window
     */
    edata_ptr = malloc( sizeof( extra_data ) );
    if( edata_ptr == NULL ) return( FALSE );
    edata_ptr->cmdline = cmdline;
    SetWindowLong( hwnd, EXTRA_DATA_OFFSET, (DWORD) edata_ptr );

    /*
	  * display window
	  */
	 ShowWindow( hwnd, cmdshow );
	 UpdateWindow( hwnd );

	 hWndStatus = CreateStatusWindow(WS_CHILD | WS_VISIBLE, "Welcome to my Test Program!", hwnd, 200);
	 hWndUpDown = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE, 200, 200, 50, 50, hwnd,
			201, hInst, NULL, 200, 0, 100);

	 for (i=0; i<10; i++)
	 {
		 button[i].iBitmap = i - 1;
		 button[i].idCommand = i;
		 button[i].fsState = TB_ENABLEBUTTON;
		 button[i].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
		 button[i].dwData = 1;
		 button[i].iString = i;
	 }

	 hWndToolbar = CreateToolbarEx(hwnd, WS_CHILD | WS_VISIBLE | TBSTYLE_FLAT, 202, 32, hInst, 1, &button, 9, 20, 20, 15, 15, sizeof(TBBUTTON));

	 if (hWndToolbar == NULL)
		 MessageBox(hwnd, "Toolbar Creation Failed!", "Oh No!", MB_ICONSTOP);

	 hDC = GetDC(hwnd);
	 return( TRUE );

} /* AnyInstance */

/*
 * AboutDlgProc - processes messages for the about dialog.
 */
BOOL _EXPORT FAR PASCAL AboutDlgProc( HWND hwnd, unsigned msg,
				UINT wparam, LONG lparam )
{
	 lparam = lparam;			/* turn off warning */

    switch( msg ) {
    case WM_INITDIALOG:
	return( TRUE );

    case WM_COMMAND:
		if( LOWORD( wparam ) == IDOK ) {
	    EndDialog( hwnd, TRUE );
	    return( TRUE );
	}
	break;
    }
    return( FALSE );

} /* AboutDlgProc */

/*
 * MainWindowProc - handle messages for the main application window
 */
LONG _EXPORT FAR PASCAL MainWindowProc( HWND hwnd, unsigned msg,
				     UINT wparam, LONG lparam )
{
    FARPROC 	proc;
    extra_data	*edata_ptr;
    char	buff[128];

	 switch( msg ) {

	 case WM_COMMAND:
		switch( LOWORD( wparam ) ) {
	case MENU_ABOUT:
		 proc = MakeProcInstance( AboutDlgProc, hInst );
	    DialogBox( hInst, MAKEINTRESOURCE(1), hwnd, proc );
	    FreeProcInstance( proc );
	    break;

	case MENU_EXIT:
		 PostMessage(hwnd, WM_CLOSE, 0, 0L);
		 break;

	case 73:
	    edata_ptr = (extra_data *) GetWindowLong( hwnd,
	    					EXTRA_DATA_OFFSET );
#ifdef __NT__
	    sprintf( buff, "Command string was \"%s\"", edata_ptr->cmdline );
#else
	    sprintf( buff, "Command string was \"%Fs\"", edata_ptr->cmdline );
#endif
	    MessageBox( NULL, buff, "Program Information", MB_OK );
	    break;
	}
	break;

	 case WM_DESTROY:
		 ReleaseDC(hwnd, hDC);
		 PostQuitMessage( 0 );
		 break;

	 default:
	return( DefWindowProc( hwnd, msg, wparam, lparam ) );
	 }
	 return( 0L );

} /* WindowProc */
