 
 
 
 
 
/*      TUMAIN.C        */
 
 
/*      TUMAIN.C        06/10/85 -- 08/02/85            Gregg Morris    */
/* GEM TUTOR program, based on INSTALL.C                                */
 
#include "portab.h"
#include "machine.h"
#include "gembind.h"
#include "dosbind.h"
#include "obdefs.h"
#include "install.h"
#include "tutor.h"
 
#define debug 0
#define NUMCMDS 16
#define BUF_SIZE 16384
#define BEG_UPDATE 1
#define END_UPDATE 0
#define BEG_MCTRL 3
#define END_MCTRL 2
 
EXTERN LONG     dos_alloc();
EXTERN UWORD    global[];               /* declared in CRYSIF.C         */
EXTERN WORD     DOS_ERR;
EXTERN WORD     PROGEND;
EXTERN BYTE     *cp_alert();
EXTERN BYTE     *c_disp();
 
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     gl_smsg[8];
GLOBAL WORD     ctrl_pid;
GLOBAL WORD     gl_handle;
GLOBAL WORD     gl_wchar, gl_hchar;
GLOBAL WORD     gl_wbox, gl_hbox;
GLOBAL WORD     gl_apid;
 
GLOBAL GRECT    gl_desk;
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     ad_smsg;
GLOBAL LONG     copy_base;
GLOBAL LONG     dummy;
GLOBAL LONG     gl_dispbox;
 
GLOBAL WORD     gl_open;                        /* true if acc. is open */
GLOBAL WORD     yes, butn1, butn2, butn3, hd_sys;
GLOBAL WORD     gpatsts;
GLOBAL WORD     SRCBUTN;        /* default exit button for SRCMSG       */
GLOBAL WORD     gl_ittape;
 
GLOBAL BYTE     bat_buf[BUF_SIZE];
GLOBAL BYTE     *bat_base;      /* ptr to base of batch file in memory  */
GLOBAL BYTE     *bat_pc;        /* ptr to current position in batch file*/
GLOBAL BYTE     *batptr;
GLOBAL BYTE     DTA[50];
GLOBAL BYTE     err_ret;
GLOBAL BYTE     gpatstr[20];
GLOBAL BYTE     newbyte;        /* hard disk drive letter               */
GLOBAL BYTE     SRCMSG[384];            /* error message for src dsk    */
GLOBAL BYTE     alrt_str[384];          /* space for current alert      */
GLOBAL BYTE     disp_str[800];          /* space for current dispbox    */
GLOBAL BYTE     gl_cmd[80], gl_tail[80];
MLOCAL BYTE     *commands[] = { "DOS","ALERT","SRCMSG","PATBAT","COPY","MD",
                                "IF1BUTN","IF2BUTN","IF3BUTN","IFHD","IFFD",
                                "GOTO",":","RUN","PLAY","DISPLAY" };
 
GLOBAL EVENT    gl_evlist[MAX_EVNTS];
 
/************************************************************************/
/* p a r s _ b a t                                                      */
/************************************************************************/
        WORD
pars_bat()
{
/* parse the batch file for a match of the string; return index into    */
/* jump table of matching command.                                      */
        WORD            ii;
        BYTE            *pbat, *matptr;
 
        matptr = commands[0];
        for ( ii = 0; ii < NUMCMDS; ii++ )
        {
          pbat = bat_pc;
          while ( (*matptr) && (*matptr == *pbat) )
          {
            matptr++;
            pbat++;
          } /* while */
          if ( !(*matptr) )
          {
            bat_pc = pbat;
            return(ii);
          } /* if */
          while (*matptr)
            matptr++;
          matptr++;
        } /* for */
        return(ii);
} /* pars_bat */
 
/************************************************************************/
/* c _ r u n                                                            */
/************************************************************************/
        VOID
c_run()
{
        WORD            doex, isgr, isgem;
 
        get_shparms(batptr, &doex, &isgr, &isgem, &gl_cmd[0], &gl_tail[0]);
        shel_write(doex, isgr, isgem, ADDR(&gl_cmd[0]), ADDR(&gl_tail[0]));
} /* c_run */
 
/************************************************************************/
/* c _ a l e r t                                                        */
/************************************************************************/
        BYTE *
c_alert()
{
/* display an alert of made from the given string; return ptr to char   */
/* past end of alert                                                    */
        WORD            ret, def_butn;
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, alrt_str, TRUE, &def_butn );
        ret = form_alert(def_butn, ADDR(alrt_str));
        butn1 = butn2 = butn3 = FALSE;
        if (ret == 1)
          butn1 = TRUE;
        if (ret == 2)
          butn2 = TRUE;
        if (ret == 3)
          butn3 = TRUE;
        return(new_ptr);
} /* c_alert */
 
/************************************************************************/
/* c _ c o p y                                                          */
/************************************************************************/
        VOID
c_copy()
{
        WORD            ii, jj, ambigfn;
        BYTE            srcpth[80];
        BYTE            srcstr[80];
        BYTE            desstr[80];
        BYTE            tmpst1[80];
        BYTE            tmpst2[80];
        BYTE            *ps, *pd;
        static BYTE     slash[] =  "\\"; 
 
        ps = batptr;
        while ( *ps == ' ' )
          ps++;
        ii = 0;
        ambigfn = FALSE;
        pd = srcstr;
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
        {
          *pd = *ps;
          if ( (*pd == '*') || (*pd == '?') )
            ambigfn = TRUE;
          pd++;
          ps++;
          ii++;
        } /* while */
        *pd = NULL;
        if ( ii > 0 )
        {
          pd = desstr;
          while ( *ps == ' ' )
            ps++;
          jj = 0;
          while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          {
            *pd++ = *ps++;
            jj++;
          } /* while */
          *pd = NULL;
          --pd;
          if ( ambigfn )
          {
            expath( srcstr, srcpth );
            dos_sfirst( ADDR( srcstr ), 0x0000 );
            while ( !DOS_ERR )
            {
              tmpst1[0] = NULL;
              tmpst2[0] = NULL;
              strcat(tmpst1, srcpth);
              strcat( tmpst1, &DTA[30] );
              strcat( tmpst2, desstr );
              if ( (jj == 0) || (*pd == ':') )
                strcat( tmpst2, &DTA[30] ); 
              else 
              {
                strcat( tmpst2, &slash[0] );    /* add required slash   */
                strcat( tmpst2, &DTA[30] );     /* add fname from src   */
              }
              fcopy( tmpst1, tmpst2 );
              dos_snext();
            } /* while !DOS_ERR */
          } /* if ambigfn */
          else
          {
            exfname( srcstr, tmpst1 );
            if ( (jj == 0) || *pd == ':' )
              strcat( desstr, tmpst1 ); 
            else if ( valpath( desstr ) )
            {
              strcat( desstr, &slash[0] );      /* add required slash   */
              strcat( desstr, tmpst1 );         /* add fname from src   */
            } /* else if */
            fcopy( srcstr, desstr );
          } /* else */
        } /* if ii > 0 */
#if debug
        form_alert(1, ADDR("[0][A copy command was encountered.][   OK   ]"));
#endif
} /* c_copy */
 
/************************************************************************/
/* c _ m d                                                              */
/************************************************************************/
        VOID
c_md()
{
/* make a directory                                                     */
        LONG            plong;
        BYTE            chars[80];
 
        mov_wstr( batptr, chars );
        plong = ADDR( chars );
        dos_mkdir( plong );
#if debug
        form_alert(1, ADDR("[0][Made a directory][   OK   ]"));
#endif
} /* c_md */
 
/************************************************************************/
/* c _ g e t d r v                                                      */
/************************************************************************/
        VOID
c_getdrv()
{
        UWORD           drives, hd_flop, mask;
        WORD            ii;
 
        drives = global[13];
        hd_flop = global[14];
        if (hd_flop)                    /* must be a hard-disk system   */
        {
          hd_sys = TRUE;
          mask = 0x0001;
                                /* get the lowest lettered hard disk    */
          for (ii = 15; ii >= 0; ii--)
          {
            if (mask & drives)
            {
              if (mask & hd_flop)
                newbyte = ii + 'A';
            } /* if mask & drives */
            mask <<= 1;
          } /* for */
        } /* if hd_flop */
        else
          hd_sys = FALSE;
} /* c_getdrv */
 
/************************************************************************/
/* c _ p a t b a t                                                      */
/************************************************************************/
        VOID
c_patbat()
{
        BYTE            oldstr[20];
        BYTE            *tmpptr, *ptxt, *matptr;
 
        matptr = bat_pc;
        ptxt = bat_pc;
        mov_wstr( bat_pc, oldstr );
        tmpptr = oldstr;
        while (*ptxt != 0x1A)
        {
          if ( *tmpptr != *ptxt )
          {
            tmpptr = oldstr;
            ptxt++;
            matptr = ptxt;
          }
          else
          {
            while ( (*tmpptr == *ptxt) && (*tmpptr) )
            {
              ptxt++;
              tmpptr++;
            } /* while */
            if (*tmpptr)
              matptr = ptxt;
            else
            {
              tmpptr = oldstr;
              *matptr = newbyte;
            } /* else */
          } /* else */
        } /* while */
} /* c_patbat */
 
/************************************************************************/
/* c _ i f 1 b u t n                                                    */
/************************************************************************/
        VOID
c_if1butn()
{
        if (butn1)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF1BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if1butn */
 
/************************************************************************/
/* c _ i f 2 b u t n                                                    */
/************************************************************************/
        VOID
c_if2butn()
{
        if (butn2)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF2BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if2butn */
 
/************************************************************************/
/* c _ i f 3 b u t n                                                    */
/************************************************************************/
        VOID
c_if3butn()
{
        if (butn3)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF3BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if3butn */
 
/************************************************************************/
/* c _ i f h d                                                          */
/************************************************************************/
        VOID
c_ifhd()
{
        if (hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFHD statement was encountered.][   OK   ]"))
;
#endif
} /* c_ifhd */
 
/************************************************************************/
/* c _ i f f d                                                          */
/************************************************************************/
        VOID
c_iffd()
{
        if (!hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFFD statement was encountered.][   OK   ]"))
;
#endif
} /* c_iffd */
 
/************************************************************************/
/* c _ g o t o                                                          */
/************************************************************************/
        VOID
c_goto()
{
        gotob();
#if debug
        form_alert(1, ADDR("[0][A GOTO statement was encountered.][   OK   ]"));
#endif
} /* c_goto */
 
/************************************************************************/
/* c _ l a b e l                                                        */
/************************************************************************/
        VOID
c_label()
{
#if debug
        form_alert(1, ADDR("[0][A LABEL was encountered.][   OK   ]"));
#endif
} /* c_label */
 
/************************************************************************/
/* c _ s r c m s g                                                      */
/************************************************************************/
        BYTE *
c_srcmsg()
{
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, SRCMSG, TRUE, &SRCBUTN );
#if debug
        form_alert(1, ADDR("[0][A SRCMSG definition was encountered.][   OK   ]"
));
#endif
        return(new_ptr);
} /* c_srcmsg */
 
/************************************************************************/
/* c _ p l a y                                                          */
/************************************************************************/
        VOID
c_play()
{
/* play a tape                                                          */
        WORD            f_handle, num_evnts;
        BYTE            tape_name[13];
 
        tape_name[0] = NULL;
                                        /* get the tape file name       */
        mov_wstr( bat_pc, &tape_name[0] );
        f_handle = dos_open(ADDR(&tape_name[0]), 2);  
        if (DOS_ERR)
        {
          form_alert(1, "[3][Couldn't open the specified TAPE file.][   OK   ]")
;
          return;
        } /* if DOS_ERR */
                                                /* read the tape        */
        num_evnts = read_piece( f_handle, MAX_SIZE, ADDR(&gl_evlist[0]));
        dos_close(f_handle);
        num_evnts = num_evnts / 6;              /* 6 bytes per event    */
                                                /* play it!             */
        appl_tplay(ADDR(&gl_evlist[0]), num_evnts, 500);
} /* c_play */
 
/************************************************************************/
/* r e a d _ b a t                                                      */
/************************************************************************/
        VOID
read_bat()
{
        LONG            plong;
        LONG            count;
        WORD            handle, ret;
        static BYTE             no_txt[] = 
"[3][TUTOR can't find the TUTOR.TXT|file. Insert the disk containing|\
TUTOR.TXT and try again.][ Cancel ]";
 
        static BYTE     *APATH = { "C:\\GEMAPPS\\" };
        static BYTE     *BATCH = { "TUTOR.TXT" };
 
/*      dos_sdrv( 0 );                          /* select drive A       */
        plong = ADDR( APATH );
        dos_chdir( plong );
        plong = ADDR( BATCH );
*/
        handle = dos_open( ADDR("C:\\GEMAPPS\\TUTOR.TXT"), 0 );
        if ( DOS_ERR )
        {
          form_alert(1, ADDR(no_txt));
 
/*        dos_free( dummy );
          ret = appl_exit();
          TERMINATE();
*/
        } /* if DOS_ERR */
        bat_base = &bat_buf[0];
        bat_pc = bat_base;
        count = read_piece( handle, BUF_SIZE, ADDR(&bat_buf[0]) );
        dos_close( handle );
} /* read_bat */
 
/************************************************************************/
/* g o t o b                                                            */
/************************************************************************/
        VOID
gotob()
{
        WORD            status, advance;
        BYTE            matstr[80];
        BYTE            labstr[80];
        BYTE            *ptr;
 
        mov_wstr( batptr, matstr );             /* get the label        */
        if ( matstr[0] )
        {
          status = FALSE;
          advance = FALSE;
          ptr = bat_base;
          while (!status)
          {
            if ( *ptr == 0x1A )
            {
              status = TRUE;
              ptr = batptr;
            } /* if */   
            else if ( *ptr++ == ':' )
            {
              mov_wstr( ptr, labstr );
              status = cmp_str( labstr, matstr );
            } /* else if */
          } /* while */
          ptr += 2;
          bat_pc = ptr;     
        } /* if */
} /* gotob */
 
/************************************************************************/
/* G E M A I N                                                          */
/************************************************************************/
        VOID
GEMAIN()
{
        WORD            notend, ret, advance;
        WORD            done, ev_which, first, cont;
        WORD            mx, my, mb, ks, kret, bret;
                                                /* initialize libraries */
        gl_apid = appl_init();
        gl_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
                                /* find out what drives we've got       */
        hd_sys = FALSE;                 /* default is floppy system     */
        c_getdrv();
#if debug
form_alert(1, ADDR("[0][Passed c_getdrv()][   OK   ]"));
#endif
                                                /* get size of desktop  */
        wind_get(0, WF_WXYWH, &gl_desk.g_x, &gl_desk.g_y,
                 &gl_desk.g_w, &gl_desk.g_h);
                                                /* open resource file   */
        ret = rsrc_load( ADDR("TUTOR.RSC") );
        ret = rsrc_gaddr(R_TREE, DISPBOX, &gl_dispbox);
        gl_ittape = menu_register(gl_apid, ADDR("  Tutorial") );
        
        ad_rmsg = ADDR(&gl_rmsg[0]);
        ad_smsg = ADDR(&gl_smsg[0]);
                                                /* initialize mouse     */
        graf_mouse(0, 0x0L);
        gpatsts = FALSE;
        gl_open = FALSE;
#if debug
form_alert(1, ADDR("[0][Before main while loop][   OK   ]"));
#endif
        done = FALSE;
        while (!done)
        {                               /* wait for accessory to open   */
#if debug
form_alert(1, ADDR("[0][In the main while loop][   OK   ]"));
#endif
          advance = FALSE;
          notend = first = TRUE;
                                                /* init alert buttons   */
          butn1 = butn2 = butn3 = FALSE;
          cont = FALSE;
#if debug
form_alert(1, ADDR("[0][Before ev_multi][   OK   ]"));
#endif
/*        wind_update(BEG_UPDATE);
          wind_update(BEG_MCTRL);*/
          ev_which = evnt_multi(MU_MESAG, 0, 0, 0,
                                0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0,
                                ad_rmsg, 0, 0, 
                                &mx, &my, &mb, &ks, &kret, &bret);
                                                /* handle message       */
/*        wind_update(END_MCTRL);
          wind_update(END_UPDATE);
*/
          if (ev_which & MU_MESAG)
          {
#if debug
form_alert(1, ADDR("[0][Event was MU_MESAG][   OK   ]"));
#endif
            if (gl_rmsg[0] == AC_OPEN)
            {
#if debug
form_alert(1, ADDR("[0][Event was AC_OPEN][   OK   ]"));
#endif
              if ( (gl_rmsg[4] == gl_ittape) && (!gl_open) )
              {
#if debug
form_alert(1, ADDR("[0][OPEN conditions met][   OK   ]"));
#endif
                gl_open = TRUE;
                cont = TRUE;
              } /* if */
            } /* if AC_OPEN */
            else if (gl_rmsg[0] == AC_CLOSE)
            {
#if debug
form_alert(1, ADDR("[0][Event was AC_CLOSE][   OK   ]"));
#endif
              if ( (gl_rmsg[4] == gl_ittape) && (gl_open) )
              {
#if debug
form_alert(1, ADDR("[0][CLOSE conditions met][   OK   ]"));
#endif
                gl_open = FALSE;
                cont = FALSE;
              } /* if */
            } /* else if AC_CLOSE */
          } /* if MU_MESAG */
 
          if (cont)
          {
#if debug
form_alert(1, ADDR("[0][CONT was TRUE][   OK   ]"));
#endif
            while (notend)
            {
              if (first)
              {
/*              dummy = dos_alloc( 0x00001000L );
                dos_sdta( ADDR( DTA ) );
*/
 
#if debug
form_alert(1, ADDR("[0][FIRST was TRUE][   OK   ]"));
#endif
                read_bat();
                first = FALSE;
              } /* if */
/*            dos_sdta( ADDR( DTA ) );*/
              notend = pars_bat();
              batptr = bat_pc;
              switch(notend)
              {
                case 0:                 /* formerly c_dos();            */
/*                dos_free( dummy );*/
                  notend = FALSE;
                  advance = FALSE;
                  break;
                case 1:
                  bat_pc = c_alert();
                  advance = FALSE;
                  break;
                case 2:
                  bat_pc = c_srcmsg();
                  advance = FALSE;
                  break;
                case 3:
                  c_patbat();
                  advance = TRUE;
                  break;
                case 4:
                  c_copy();
                  advance = TRUE;
                  break;
                case 5:
                  c_md();
                  advance = TRUE;
                  break;
                case 6:
                  c_if1butn();
                  advance = TRUE;
                  break;
                case 7:
                  c_if2butn();
                  advance = TRUE;
                  break;
                case 8:
                  c_if3butn();
                  advance = TRUE;
                  break;
                case 9:
                  c_ifhd();
                  advance = TRUE;
                  break;
                case 10:
                  c_iffd();
                  advance = TRUE;
                  break;
                case 11:
                  c_goto();
                  advance = TRUE;
                  break;
                case 12:
                  c_label();
                  advance = TRUE;
                  break;
                case 13:
                  c_run();
                  advance = FALSE;
                  notend = FALSE;
                  break;
                case 14:
                  c_play();
                  advance = TRUE;
                  break;
                case 15:
                  bat_pc = c_disp();            /* in GIDISP.C          */
                  advance = FALSE;
                  break;
              } /* switch */
              if (advance)
                notend = nextline();
#if debug
form_alert(1, ADDR("[0][After SWITCH][   OK   ]"));
#endif
            } /* while notend */
#if debug
form_alert(1, ADDR("[0][After WHILE NOTEND][   OK   ]"));
#endif
            cont = FALSE;
            gl_open = FALSE;
          } /* if cont */
#if debug
form_alert(1, ADDR("[0][After IF CONT][   OK   ]"));
#endif
        } /* while !done */
#if debug
form_alert(1, ADDR("[0][At end][   OK   ]"));
#endif
/*      dos_free( dummy );
        ret = appl_exit();
        TERMINATE();
*/
} /* GEMAIN */
 
 
 
 
 
 
