 
 
 
 
 
/*      GIDISP.C        */
 
/*      GIDISP.C        07/08/85 -- 07/25/85            Gregg Morris    */
/* this module contains the routines to handle the DISPLAY command      */
/* in GEM INSTALL and TUTORIAL                                          */
 
#include "portab.h"
#include "machine.h"
#include "treeaddr.h"
#include "gembind.h"
#include "dosbind.h"
#include "obdefs.h"
#include "install.h"
#include "tutor.h"
 
#define BEG_UPDATE 1
#define END_UPDATE 0
#define BEG_MCTRL 3
#define END_MCTRL 2
 
#define max(x, y) (x) > (y) ? (x) : (y)
#define N_DISPOBS 13
#define RETURN 0x1C0D                           /* carriage return      */
 
EXTERN BYTE     *cp_alert();
 
EXTERN LONG     gl_dispbox;
EXTERN LONG     ad_rmsg;
EXTERN WORD     gl_handle;
EXTERN WORD     butn1, butn2, butn3;
EXTERN WORD     gl_wchar, gl_hchar;
EXTERN BYTE     *batptr;
EXTERN BYTE     disp_str[];
 
EXTERN GRECT    gl_desk;
 
GLOBAL WORD     wh_disp;
GLOBAL WORD     contrl[11];
GLOBAL WORD     intin[80];
GLOBAL WORD     ptsin[256];
GLOBAL WORD     intout[45];
GLOBAL WORD     ptsout[12];
 
BYTE            nils[6] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
 
/************************************************************************/
/* s o u n d                                                            */
/************************************************************************/
        VOID
sound(isfreq, freq, duration)
        WORD            isfreq, freq, duration;
{
        WORD            cnt;
 
        contrl[0] = 5;
        contrl[1] = 0;
        contrl[6] = gl_handle;
        intin[0] = freq;
        intin[1] = duration;
        if (isfreq)
        {
          contrl[5] = 61;
          contrl[3] = 2;
        } /* if isfreq */
        else
        {
          contrl[5] = 62;
          contrl[3] = 1;
        }
        vdi();
        return(intout[0]);
} /* sound */
 
/************************************************************************/
/* f i n d _ d e f l t                                                  */
/************************************************************************/
        WORD
find_deflt(tree)
        LONG            tree;
{
        UWORD           flags;
        WORD            obj;
 
        obj = BUTN1;
        while ( obj <= BUTN3 )
        {
          flags = LWGET(OB_FLAGS(obj));
          if (flags & DEFAULT)
            return(obj);
        } /* while */
        return(FALSE);
} /* find_deflt */
 
/************************************************************************/
/* h n d l _ k e y b d                                                  */
/************************************************************************/
        WORD
hndl_keybd(tree, ex_butn)
        LONG            tree;
        WORD            *ex_butn;
{
        WORD            done, def_obj, x, y, w, h;
 
        done = FALSE;
                                /* is there a default exit button?      */
        def_obj = find_deflt(tree);
        if (def_obj)
        {
          objc_offset(gl_dispbox, def_obj, &x, &y);
          w = LWGET(OB_WIDTH(def_obj));
          h = LWGET(OB_HEIGHT(def_obj));
          objc_change(tree, def_obj, 0, x, y, w, h, SELECTED, TRUE);
          done = TRUE;
          *ex_butn = def_obj - BUTN1 + 1;
        } /* if */
        return(done);
} /* hndl_keybd */
 
/************************************************************************/
/* h n d l _ b u t n                                                    */
/************************************************************************/
        WORD
hndl_butn(tree, obj, ex_butn)
        LONG            tree;
        WORD            obj, *ex_butn;
{
        UWORD           flags, state;
        WORD            done, mx, my, mb, ks;
 
        done = FALSE;
        flags = LWGET(OB_FLAGS(obj));
        state = LWGET(OB_STATE(obj));
        if ( flags & SELECTABLE )
        {
          if ( graf_watchbox(tree, obj, state ^ SELECTED, state) )
            state ^= SELECTED;
          if ( flags & SELECTABLE )
            evnt_button(1, 0x01, 0x0, &mx, &my, &mb, &ks);
          if ( (state & SELECTED) && (flags & EXIT) )
          {
            *ex_butn = obj - BUTN1 + 1;
            done = TRUE;
          } /* if */
        } /* if */
        return(done);
} /* hndl_butn */
 
/************************************************************************/
/* c _ d i s p                                                          */
/************************************************************************/
        BYTE *
c_disp()
{
        LONG            tvalue, tree;
        UWORD           flags, ev_which;
        WORD            num_strs, max_len, num_butns, max_butn;
        WORD            def_butn, col, row, tdelay, done;
        WORD            butn, ex_butn, obj, mx, my, mb, ks, kret, bret;
        WORD            x, y, w, h, wx, wy, ww, wh;
        BYTE            *pend;
 
        butn1 = butn2 = butn3 = FALSE;
        tree = gl_dispbox;
                                        /* get the DISPLAY string       */
        pend = cp_alert( batptr, &disp_str[0], FALSE, &def_butn );
                                        /* parse it into pieces         */
        tdelay = pars_disp(&disp_str[0], &num_strs, &max_len, &num_butns,
                           &max_butn, &def_butn, &col, &row);
                                        /* build the displayable object */
        bild_disp(gl_dispbox, num_strs, max_len, num_butns, max_butn,
                  def_butn, col, row);
                                        /* get ready for evnt_multi     */
        flags = 0x0;
        if (tdelay > 0)
        {
          if (num_butns)
            flags = MU_KEYBD | MU_BUTTON|MU_TIMER;
          else
            flags = MU_BUTTON | MU_TIMER;
          tvalue = ((LONG) tdelay) * 1000;
        } /* if tdelay */
        else if (num_butns)
        {
          flags = MU_KEYBD | MU_BUTTON;
          tvalue = 0x0L;
        } /* else */
        else
        {
          flags = MU_BUTTON;
          tvalue = 0x0L;
        } /* else */
 
        form_center(gl_dispbox, &x, &y, &w, &h);
                                        /* compute size of window       */
        wind_calc(WC_BORDER, 0, x, y, w, h, &wx, &wy, &ww, &wh);
        wh_disp = wind_create(0, wx, wy, ww, wh);
        wind_open(wh_disp, wx, wy, ww, wh);
        form_dial(FMD_START, 0, 0, 0, 0, wx - 2, wy - 2, ww + 4, wh + 4);
        objc_draw(gl_dispbox, ROOT, MAX_DEPTH, x, y, w, h);
                                        /* set up for loop              */
        butn = 0x01;
        done = FALSE;
        while (!done)
        {
          ex_butn = 0;
          ev_which = evnt_multi(flags, 0x01, 0x01, butn,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                ad_rmsg, tvalue, &mx, &my, &mb,
                                &ks, &kret, &bret);
          if (ev_which & MU_KEYBD)
          {
            if (kret == RETURN)
              done = hndl_keybd(gl_dispbox, &ex_butn);
          } /* if KEYBD */
 
          if (ev_which & MU_BUTTON)
          {
            if (butn == 0x01)
            {
              obj = objc_find(gl_dispbox, ROOT, MAX_DEPTH, mx, my);
              if (obj == NIL)
              {
                sound(TRUE, 440, 2);
                obj = 0;
              } /* if */
              else
                done = hndl_butn(gl_dispbox, obj, &ex_butn);
              butn = 0x0;
            } /* if */
            else
              butn = 0x01;
          } /* if MU_BUTTON */
          if (ev_which & MU_TIMER)
            done = TRUE;
        } /* while !done */
                                        /* set exit button flags        */
        if (ex_butn == 1)
          butn1 = TRUE;
        if (ex_butn == 2)
          butn2 = TRUE;
        if (ex_butn == 3)
          butn3 = TRUE;
                                        /* to generate a redraw message */
        form_dial(FMD_FINISH, 0, 0, 0, 0, wx - 2, wy - 2, ww + 4, wh + 4);
        wind_close(wh_disp);
        wind_delete(wh_disp);
        return(pend);
} /* c_disp */
 
/************************************************************************/
/* s t r b r k                                                          */
/************************************************************************/
        BYTE *
strbrk(tree, pdisp_str, offset, pnitem, pmaxlen)
        LONG            tree;
        BYTE            *pdisp_str;
        WORD            offset, *pnitem, *pmaxlen;
{
/* break the DISPLAY string into smaller strings after a | or ] is      */
/*   encountered. copy the strings into the DISPBOX strings.            */
        REG LONG        pstr;
        REG WORD        nitem, len, maxlen;
        REG BYTE        tmp, nxttmp;
 
        nitem = maxlen = 0; 
        tmp = NULL;
        while( tmp != ']')
        {
          pstr = LLGET(OB_SPEC(offset + nitem));
          len = 0;
                                        /* get 1st char of new string   */
          do
          {
            tmp = *pdisp_str;
            pdisp_str++;
            nxttmp = *pdisp_str;
            if ( (tmp == ']') || (tmp == '|') )
            {
              if (tmp == nxttmp)
                pdisp_str++;
              else
              {
                nxttmp = tmp;
                tmp = NULL;
              } /* else */
            } /* if */
            LBSET(pstr + len, tmp);
            len++;
          } while ( tmp != NULL );
          tmp = nxttmp;
          maxlen = max(len - 1, maxlen);
          nitem++;
        }
        if (maxlen == 0)
        {
          *pnitem = 0;
          *pmaxlen = 0;
        } /* if */
        else
        {
          *pnitem = nitem;
          *pmaxlen = maxlen;
        } /* else */
        return(pdisp_str);
} /* strbrk */
 
/************************************************************************/
/* p a r s _ d i s p                                                    */
/************************************************************************/
        WORD
pars_disp(pdisp_str, pnum_strs, pmax_len, pnum_butns, pmax_butn, pdef_butn, pcol
, prow)
        BYTE            *pdisp_str;
        WORD            *pnum_strs, *pmax_len, *pnum_butns;
        WORD            *pmax_butn, *pdef_butn, pcol, prow;
{
/* the format of the DISPLAY string is:
   DISPLAY [def_butn][time][col,row][string1| ... |string10][butn1|butn2|butn3]
   where
        def_butn = 0 - no default exit button
                   1, 2, 3 - number of default exit button
        time    = number of seconds to display box (999 max)
        col,row = screen column,row of upper left-hand corner (80x25 max)
        strings = up to 10 lines of up to 60 chars. max
        butns   = up to 3 exit buttons of up to 20 chars. max
   Note: the string may be broken across lines after any ] or |.
   pdisp_str initially points past DISPLAY keyword to the space following,
   for ex.:
   pdisp_str = " [1][10][5,5][This is a display string.|This is line 2.][OK | Ca
ncel]"
*/
        WORD            time_delay;
        BYTE            *ptmp;
                                                /* skip space & first [ */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
                                        /* get default button, if any   */
        *pdef_butn = *pdisp_str - '0';
        if (*pdef_butn < 0 || *pdef_butn > 3)
          *pdef_butn = 0;
                                                /* skip to time delay   */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
        ptmp = pdisp_str;
        while (*pdisp_str != ']')
          pdisp_str++;
        *pdisp_str = NULL;
        time_delay = make_num(ptmp);
                                                /* skip to x,y          */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
        ptmp = pdisp_str;
        while (*pdisp_str != ']')
          pdisp_str++;
        *pdisp_str = NULL;
        make_xy(ptmp, pcol, prow);              /* x = col, y = row     */
                                                /* skip to strings      */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
                                        /* break up the text lines      */
        pdisp_str = strbrk(gl_dispbox, pdisp_str, LINE1, pnum_strs, pmax_len);
        pdisp_str++;
                                        /* break up the buttons         */
        pdisp_str = strbrk(gl_dispbox, pdisp_str, BUTN1, pnum_butns, pmax_butn);
        return(time_delay);
} /* pars_disp */       
 
/************************************************************************/
/* b i l d _ d i s p                                                    */
/************************************************************************/
        VOID
bild_disp(tree, nummsg, mlenmsg, numbut, mlenbut, def_butn, col, row)
        LONG            tree;
        WORD            nummsg, mlenmsg, numbut, mlenbut, def_butn, col, row;
{
        LONG            plong;
        WORD            ii, kk, wspace;
        GRECT           disp, butn, msg;
 
        disp.g_x = max(gl_desk.g_x, (col * gl_wchar));
        disp.g_y = max(gl_desk.g_y, (row * gl_hchar));
        disp.g_w = (mlenmsg * gl_wchar) + (4 * gl_wchar);
        disp.g_h = (nummsg * gl_hchar) + (2 * gl_hchar);
                                /* check screen placement of dispbox */
        chk_place(&disp);
 
        get_obxywh(tree, LINE1, &msg);
        msg.g_w = mlenmsg * gl_wchar;
        msg.g_h = gl_hchar;
 
        butn.g_x = msg.g_x;
        butn.g_y = disp.g_h;
        butn.g_w = mlenbut * gl_wchar;
        butn.g_h = gl_hchar;
                                                /* any buttons ?        */
        if (numbut)
        {
          wspace = ((mlenbut * numbut) + ((numbut + 1) * 2)) * gl_wchar;
          disp.g_w = max(disp.g_w, wspace);
          disp.g_h += (2 * gl_hchar);
        } /* if */
                                                /* init. root object    */
        set_obxywh(tree, ROOT, &disp);
                                        /* set NEXT,HEAD,TAIL to NIL    */
        for(ii = 0; ii < N_DISPOBS; ii++)
          LBCOPY(OB_NEXT(ii), ADDR(&nils[0]), 6);
                                                /* add msg objects      */
        for(ii = 0; ii < nummsg; ii++)
        {
          set_obxywh(tree, LINE1+ii, &msg);
          msg.g_y += gl_hchar;
          objc_add(tree, ROOT, LINE1+ii);
        } /* for */
                                                /* add button objects   */
        for(ii = 0; ii < numbut; ii++)
        {
          kk = BUTN1 + ii;
          LWSET(OB_FLAGS(kk), SELECTABLE | EXIT);
          LWSET(OB_STATE(kk), NORMAL);
          set_obxywh(tree, kk, &butn);
          butn.g_x += butn.g_w + (2 * gl_wchar);
          objc_add(tree, ROOT, kk);
        } /* for */
                                                /* set last object flag */
        LWSET(OB_FLAGS(BUTN1 + numbut - 1), SELECTABLE | EXIT | LASTOB);
                                        /* set default button, if any   */
        if (def_butn)
        {
          plong = OB_FLAGS(BUTN1 + def_butn - 1);
          LWSET(plong, LWGET(plong) | DEFAULT);
        } /* def_butn */
} /* bild_disp */
 
/************************************************************************/
/* s e t _ o b x y w h                                                  */
/************************************************************************/
        VOID
set_obxywh(tree, obj, prect)
        LONG            tree;
        WORD            obj;
        GRECT           *prect;
{
        LWSET(OB_X(obj), prect->g_x);
        LWSET(OB_Y(obj), prect->g_y);
        LWSET(OB_WIDTH(obj), prect->g_w);
        LWSET(OB_HEIGHT(obj), prect->g_h);
} /* set_obxywh */
 
/************************************************************************/
/* g e t _ o b x y w h                                                  */
/************************************************************************/
        VOID
get_obxywh(tree, obj, prect)
        LONG            tree;
        WORD            obj;
        GRECT           *prect;
{
        prect->g_x = LWGET(OB_X(obj));
        prect->g_y = LWGET(OB_Y(obj));
        prect->g_w = LWGET(OB_WIDTH(obj));
        prect->g_h = LWGET(OB_HEIGHT(obj));
} /* get_obxywh */
 
/************************************************************************/
/* m a k e _ n u m                                                      */
/************************************************************************/
        WORD
make_num(ptime)
        BYTE            *ptime;
{
/* return number of seconds to display: 0-999                           */
        WORD            num, factor;
        BYTE            *ptmp;
 
        ptmp = ptime;
        num = 0;
        if (!ptmp)
          return(num);
                                        /* skip to end of number        */
        while (*ptmp)
          ptmp++;
        ptmp--;
                                        /* pick off digits              */
        factor = 1;
        while (ptmp >= ptime)
        {
          num += (*ptmp - '0') * factor;
          factor *= 10;
          ptmp--;
        } /* while */
        return(num);
} /* make_num */
 
/************************************************************************/
/* m a k e _ x y                                                        */
/************************************************************************/
        VOID
make_xy(pxy, pcol, prow)
        BYTE            *pxy;
        WORD            *pcol, *prow;
{
/* return col,row number of upper left corner of DISPBOX (80x25);       */
/* center on screen if none                                             */
        BYTE            *pc, *pr;
 
        pc = pr = pxy;
        if (!pc)
        {
          *pcol = 0;
          *prow = 0;
          return;
        } /* if */
                                        /* find the comma               */
        while (*pr != ',')
          pr++;
        *pr++ = NULL;                   /* NULL it out                  */
        if (*pr == ' ')
          pr++;                         /* point to number past comma   */
                        /* pc now points to col, pr points to row       */
        *pcol = make_num(pc);
        *prow = make_num(pr);
        if (*pcol > 80)
          *pcol = 80;
        if (*prow > 25)
          *prow = 25;
} /* make_xy */
 
/************************************************************************/
/* c h k _ p l a c e                                                    */
/************************************************************************/
        VOID
chk_place(prect)
        GRECT           *prect;
{
        WORD            adj_lr, adj_tb;
 
        if (prect->g_x + prect->g_w > gl_desk.g_w)
          prect->g_x = (gl_desk.g_w - prect->g_w) / 2;
        if (prect->g_y + prect->g_h > gl_desk.g_h)
          prect->g_y = (gl_desk.g_h - prect->g_h) / 2;
} /* chk_place */
 
 
 
 
 
 
