 
 
 
 
 
/*      TAPEUTIL.C      07/18/85 - 07/31/85     Gregg Morris            */
/*      modified        09/02/85 - 09/09/85     Mitch Smith             */
/*      utility         routines   for the      tape recorder           */
 
/*** INCLUDE FILES ******************************************************/
 
#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <treeaddr.h>
#include <gembind.h>
#include <tapedef.h>
#include <tape.h>
 
/*#define debug 0*/
 
/*** EXTERN VARIABLES ***************************************************/
EXTERN OBJECT   the_tape[NUM_OBS];
EXTERN TEDINFO  the_ted[NUM_TI];
EXTERN BYTE     *the_str[NUM_STRINGS];
EXTERN BYTE     def_path[];
 
EXTERN LONG     gl_tape;
EXTERN WORD     wh_tape;
EXTERN WORD     gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk;
EXTERN WORD     gl_xtape, gl_ytape, gl_wtape, gl_htape;
EXTERN WORD     gl_wchar, gl_hchar;
EXTERN WORD     gl_ignore;
EXTERN WORD     gl_numevnts;
EXTERN EVENT    gl_evlist[MAX_EVNTS];
 
 
/************************************************************************/
/* w i n d _ s i z e                                                    */
/************************************************************************/
        WORD
wind_size()
{
        LONG            tree;
        WORD            tw, th, x, y, w, h, wh;
 
        tree = gl_tape;
        tw = LWGET(OB_WIDTH(ROOT));
        th = LWGET(OB_HEIGHT(ROOT));
                                        /* 0x0B = NAME | CLOSER | MOVER */
        wind_calc(WC_BORDER, 0x000B, 0, 0, tw, th,
                  &gl_xtape, &gl_ytape, &gl_wtape, &gl_htape);
        wh = wind_create(0x000B, gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk);
        wind_set(wh, WF_NAME, ADDR(" Tape Recorder "), 0, 0);
        gl_xtape = (gl_wdesk - gl_wtape) / 2;
        gl_ytape = (gl_hdesk - gl_htape) / 2;
        return(wh);
} /* wind_size */
 
/************************************************************************/
/* f i x _ c h p o s                                                    */
/************************************************************************/
        VOID
fix_chpos(pfix, ifx)
        LONG    pfix;
        WORD    ifx;
{
        WORD    coffset;
        WORD    cpos;
 
        cpos = LWGET(pfix);
        coffset = cpos >> 8 & 0x00ff;
        cpos = cpos & 0x00ff;
        if (ifx)
          cpos *= gl_wchar;
        else
          cpos *= gl_hchar;
        if ( coffset > 128 )                    /* crude        */
          cpos -= (256 - coffset);
        else
          cpos += coffset;
        LWSET(pfix, cpos);
} /* fix_chpos() */
 
/************************************************************************/
/* i n i _ t a p e                                                      */
/************************************************************************/
        LONG
ini_tape()
{
        LONG            tree;
        WORD            ii;
 
        tree = ADDR(&the_tape[0]);
        for(ii = 0; ii < NUM_TI; ii++)
        {
          the_tape[ii+1].ob_spec = ADDR(&the_ted[ii]);
          the_ted[ii].te_ptext = ADDR(the_str[ii]);
        }
        for (ii = 0; ii < NUM_OBS; ii++)
        {
          fix_chpos(OB_X(ii), TRUE);
          fix_chpos(OB_Y(ii), FALSE);
          fix_chpos(OB_WIDTH(ii), TRUE);
          fix_chpos(OB_HEIGHT(ii), FALSE);
        }
        return(tree);
} /* ini_tape */
 
/************************************************************************/
/* d o _ o p e n                                                        */
/************************************************************************/
        VOID
do_open(wh, x, y, w, h)
        WORD            wh, x, y, w, h;
{
        graf_mouse(2, 0x0L);
        graf_growbox(2*gl_wchar, 0, 4*gl_wchar, gl_hchar, x, y, w, h);
        wind_open(wh, x, y, w, h);
        graf_mouse(0, 0x0L);
} /* do_open */
 
/************************************************************************/
/* d o _ c l o s e                                                      */
/************************************************************************/
        VOID
do_close(wh)
        WORD            wh;
{
        WORD            x, y, w, h;
 
#if debug
form_alert(1, ADDR("[0][begin do_close][   OK   ]"));
#endif
        graf_mouse(2,0x0l);
        wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
#if debug
form_alert(1, ADDR("[0][before wind_close][   OK   ]"));
#endif
        wind_close(wh);
#if debug
form_alert(1, ADDR("[0][after wind_close][   OK   ]"));
#endif
        graf_shrinkbox(2*gl_wchar, 0, 4*gl_wchar, gl_hchar, x, y, w, h);
        graf_mouse(0, 0x0L);
#if debug
form_alert(1, ADDR("[0][End do_close][   OK   ]"));
#endif
} /* do_close */
 
/************************************************************************/
/* a c _ o p e n                                                        */
/************************************************************************/
        VOID
ac_open(tree)
        LONG            tree;
{
        WORD            x, y, w, h;
#if debug
form_alert(1, ADDR("[0][In ac_open][   OK   ]"));
#endif
        wh_tape = wind_size();
        do_open(wh_tape, gl_xtape, gl_ytape, gl_wtape, gl_htape);
        wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
        the_tape[ROOT].ob_x = x;
        the_tape[ROOT].ob_y = y;
#if debug
form_alert(1, ADDR("[0][End AC_OPEN][   OK   ]"));
#endif
} /* ac_open */
 
/************************************************************************/
/* c l o s e _ t a p e                                                  */
/************************************************************************/
        VOID
close_tape()
{       
        do_close(wh_tape);
        wh_tape = 0;
} /* close_tape */
 
/************************************************************************/
/* o p e n _ t a p e                                                    */
/************************************************************************/
        VOID
open_tape()
{
        ac_open(gl_tape, wh_tape);
        gl_ignore = TRUE;
} /* open_tape */
 
/************************************************************************/
/* w r i t e _ t a p e                                                  */
/************************************************************************/
        VOID
write_tape(num_evnts, tape_name)        /* BT_SAVE */
        WORD            num_evnts;
        BYTE            *tape_name;
{
/* write num_evnts * 6 bytes to file tape_name                          */
        WORD            f_handle;
        WORD             nbytes; 
 
        nbytes = num_evnts * 6;
        f_handle = dos_create(ADDR(tape_name), 0);
        write_piece(f_handle, nbytes, ADDR(&gl_evlist[0]));
        dos_close(f_handle);
} /* write_tape */
 
/************************************************************************/
/* r e a d _ t a p e                                                    */
/************************************************************************/
        WORD
read_tape(tape_name)    /* BT_LOAD */
        BYTE            *tape_name;
{
/* read a tape, return number of events (not bytes)                     */
        WORD            f_handle, bytes_read;
 
        f_handle = dos_open(ADDR(tape_name), 2);  
        bytes_read = read_piece( f_handle, MAX_SIZE, ADDR(&gl_evlist[0]));
        dos_close(f_handle);
 
        return (bytes_read / 6);        /*      6 bytes per event       */
 
} /* read_tape */
 
/************************************************************************/
/* s e t _ c o u n t e r                                                */
/************************************************************************/
        VOID
set_counter(cnt_val, total)
        WORD            cnt_val, total;
{
/* counter looks like " nnn/xxx ". if total=TRUE, set xxx; else set nnn */
        WORD            x, y, w, h, offset;
        BYTE            *pctr;
 
        x = the_tape[ROOT].ob_x;
        y = the_tape[ROOT].ob_y;
        w = the_tape[ROOT].ob_width;
        h = the_tape[ROOT].ob_height;
        if (cnt_val >= 1000)
          cnt_val = 999;
        pctr = the_str[6];
        if (total)
          offset = 4;
        else
          offset = 0;
        pctr[1+offset] = '0' + (cnt_val / 100);
        cnt_val = cnt_val % 100;
        pctr[2+offset] = '0' + (cnt_val / 10);
        cnt_val = cnt_val % 10;
        pctr[3+offset] = '0' + cnt_val;
        do_redraw(wh_tape, x, y, w, h, SLIDE, 1);
        do_redraw(wh_tape, x, y, w, h, 7, 0);
} /* set_counter */
 
 
/*------------------------------*/
/*      get_file                */
/*------------------------------*/
WORD
get_file(full_path)
BYTE    *full_path;
{
        WORD            ast_loc, butn, ii, slash_loc;
        WORD            cur_drv;
        BYTE            tmp_name[13], tmp_drv;
 
        full_path[0] = NULL;
        tmp_name[0] = NULL;
        cur_drv = dos_gdrv();
        tmp_drv = cur_drv + 'A';
 
        get_where(&def_path[0]);
        strcpy(full_path, &def_path[0]);
        strcat(full_path, "*.TAP");
 
        if (fsel_input(ADDR(full_path), ADDR(tmp_name), &butn) && butn)
        {   
            /* Find the spot to concatenate the file name to. */
            ii = 0;
            while(full_path[ii])
              ii++;
            while(full_path[ii] != '\\')
              ii--;
            ii++;
            full_path[ii] = NULL;
            strcat(full_path, &tmp_name[0]);
                                                /* update default path  */
            def_path[0] = NULL;
            strcpy(&def_path[0], full_path);
            ii = 0;
            while(def_path[ii])
              ii++;
            while(def_path[ii] != '\\')
              ii--;
            ii++;
            def_path[ii] = NULL;
            return(TRUE);
        }   /* End if:  no error and OKAY selected. */
        else
            return(FALSE);
}  /* End "get_file". */
 
 
/*------------------------------*/
/*      get_where               */
/*------------------------------*/
VOID
get_where(ppath)
BYTE    *ppath;
{
/* Get the default directory path                                       */
        WORD            cur_drv, ii;
        BYTE            tmp_path[64];
 
        cur_drv = dos_gdrv();
        ppath[0] = cur_drv + 'A';
        ppath[1] = ':';
        ppath[2] = '\\';
        ppath[3] = NULL;
        dos_gdir(cur_drv + 1, ADDR(&tmp_path[0]));
        strcat(ppath, &tmp_path[0]);
        ii = 0;
        while(ppath[ii])
          ii++;
        ii--;
        if (ppath[ii] == '\\')
        {
          ii--;
          if (ppath[ii] == '\\')
          {
            ii++;
            ppath[ii] = NULL;
          } /* if */
        } /* if */
        else
        {
          ii++;
          ppath[ii++] = '\\';
          ppath[ii] = NULL;
        } /* else */
} /* get_where */
 
 
/*------------------------------*/
/*      force_ext               */
/*------------------------------*/
VOID
force_ext(pstr, pext)
BYTE    *pstr, *pext;
{
/* put extension pext on pstr                                           */
        BYTE            *pend;
 
        pend = pstr;
                                                /* go to end of string  */
        while(*pend)
          pend++;
        pend--;
                                                /* find the .           */
        while((*pend != '\\') && (*pend != '.') && (pend > pstr))
          pend--;
                                                /* did we find a .?     */
        if ((pend == pstr) || (*pend == '\\'))
        {
          strcat(pstr, ".");                    /* put in a period      */
          strcat(pstr, pext);                   /* no extension at all  */
        } /* if */
        else
        {                                       /* overwrite existing extension 
*/
          pend++;
          *pend = '\0';
          strcat(pstr, pext);
        } /* else */
} /* force_ext */
 
 
 
 
 
 
