 
 
/*      TAPE.C          10/18/84 - 03/22/85     ANDREW MUIR     */
/*      modified        07/18/85 - 07/24/85     Gregg Morris    */
/*      modified        09/02/85 - 09/09/85     Mitch Smith     */
 
 
#define DEFINE_TAPE_OBJ

/*------------------------------*/
/*      include files           */
/*------------------------------*/
 
#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <treeaddr.h>
#include <gembind.h>
#include <tapedef.h>
#include <tape.h>
 
/*------------------------------*/
/*      defines                 */
/*------------------------------*/
 
/*#define debug 0*/
 
 
/*------------------------------*/
/*      external functions      */
/*------------------------------*/
 
EXTERN LONG     ini_tape();
 
 
/*------------------------------*/
/*      global variables        */
/*------------------------------*/
 
GLOBAL EVENT    gl_evlist[MAX_EVNTS];
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     gl_tape;
 
GLOBAL WORD     gl_apid;
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     wh_tape;
GLOBAL WORD     gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk;
GLOBAL WORD     gl_width, gl_height;
GLOBAL WORD     gl_wchar, gl_hchar;
GLOBAL WORD     gl_wbox, gl_hbox;
GLOBAL WORD     gl_xclip, gl_yclip, gl_wclip, gl_hclip;
GLOBAL WORD     gl_xtape, gl_ytape, gl_wtape, gl_htape;
GLOBAL WORD     gl_handle;
GLOBAL WORD     contrl[11];
GLOBAL WORD     intin[128];
GLOBAL WORD     ptsin[128];
GLOBAL WORD     intout[128];
GLOBAL WORD     ptsout[128];
 
GLOBAL WORD     gl_ittape;
GLOBAL WORD     gl_flags;
GLOBAL WORD     gl_button;
GLOBAL WORD     gl_ignore;
GLOBAL WORD     gl_numevnts;
 
GLOBAL BYTE     def_path[64];
GLOBAL BYTE     gl_pfname[76];
 
/****************************************************************/
/* d o _ r e d r a w                                            */
/****************************************************************/
        WORD
do_redraw(w_handle, xc, yc, wc, hc, which_ob, depth)
        WORD            w_handle;
        WORD            xc, yc, wc, hc;          
        WORD            which_ob;
        WORD            depth;
{
        WORD            x, y, w, h;
 
        graf_mouse(M_OFF, 0x0l);
        wind_update(TRUE);
 
        wind_get(w_handle, WF_FIRSTXYWH, &x, &y, &w, &h);
        while ( w && h )
        {
                if ( rc_intersect( &xc, &x ) )
                        objc_draw(gl_tape, which_ob, depth, x, y, w, h);
                wind_get(w_handle, WF_NEXTXYWH, &x, &y, &w, &h);
        }
        
        wind_update(FALSE);
        graf_mouse(M_ON, 0x0L);
}  /* do_redraw */  
 
/*------------------------------*/
/*      rc_intersect            */
/*------------------------------*/
WORD
rc_intersect(p1, p2)                    /* compute intersect of */
                                        /*  two rectangles      */
GRECT           *p1, *p2;
{
        WORD            tx, ty, tw, th;
 
        tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
        th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
        tx = max(p2->g_x, p1->g_x);
        ty = max(p2->g_y, p1->g_y);
        p2->g_x = tx;
        p2->g_y = ty;
        p2->g_w = tw - tx;
        p2->g_h = th - ty;
        return( (tw > tx) && (th > ty) );
}
 
/*------------------------------*/
/*      min                     */
/*------------------------------*/
WORD
min(a, b)                               /* return min of        */
                                        /* two values           */
WORD            a, b;
{
        return( (a < b) ? a : b );
}
 
/*------------------------------*/
/*      max                     */
/*------------------------------*/
WORD
max(a, b)                               /* return max of        */
                                        /* two values           */
WORD            a, b;
{
        return( (a > b) ? a : b );
}
 
/****************************************************************/
/* h n d l _ m e s a g                                          */
/****************************************************************/
        WORD
hndl_mesag()
{
        LONG            tree;
        WORD            done;
        WORD            x, y, w, h;
 
        done = FALSE;
        switch( gl_rmsg[0] )
        {
          case AC_OPEN:
#if debug
form_alert(1, ADDR("[0][Got an AC_OPEN message][   OK   ]"));
#endif
                if ( gl_rmsg[4] == gl_ittape && !wh_tape)
                  ac_open(gl_tape);
                else
                  wind_set(wh_tape, WF_TOP, 0, 0, 0, 0);
                break;
          case WM_REDRAW:
#if debug
form_alert(1, ADDR("[0][Got a REDRAW message][   OK   ]"));
#endif
                do_redraw(gl_rmsg[3], gl_rmsg[4], gl_rmsg[5], 
                         gl_rmsg[6], gl_rmsg[7], ROOT, MAX_DEPTH);
                break;
          case WM_TOPPED:
                wind_set(gl_rmsg[3], WF_TOP, 0, 0, 0, 0);
                break;
          case WM_CLOSED:
#if debug
form_alert(1, ADDR("[0][Got a WM_CLOSED message][   OK   ]"));
#endif
                do_close(gl_rmsg[3]);
#if debug
form_alert(1, ADDR("[0][In HNDL_MESAG: after do_close][  OK  ]"));
#endif
                wind_delete(wh_tape);
#if debug
form_alert(1, ADDR("[0][In HNDL_MESAG: after wind_delete][ OK ]"));
#endif
                wh_tape = 0;
                break;
          case AC_CLOSE:
                if ( (gl_rmsg[3] == gl_ittape) && (wh_tape) )
                  wh_tape = 0;
                break; 
          case WM_MOVED:
                tree = gl_tape;
                wind_set(gl_rmsg[3], WF_CXYWH, gl_rmsg[4], 
                        gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
                wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
                LWSET(OB_X(ROOT), x);
                LWSET(OB_Y(ROOT), y);
                break;
        } /* switch */
        gl_rmsg[0] = 0;
#if debug
form_alert(1, ADDR("[0][End HNDL_MESAG][   OK   ]"));
#endif
        return(done);
} /* hndl_mesag */
 
/****************************************************************/
/* GEM m a i n                                                  */
/****************************************************************/
GEMAIN()
{
        LONG            tree;
        WORD            ev_which, done, ii, num, curr_ob;
        WORD            xd, yd, wd, hd;
        WORD            mx, my, mb, ks, kret, bret;
        WORD            x, y, w, h;
        WORD            no_cancel, counter, evnt_left, speed;
        WORD            junk, xoff, yoff, value;
        WORD            mod_val, add_on, slid_len;
 
                                        /* initialize libraries */
        gl_apid = appl_init();
        gl_handle = graf_handle(&gl_wchar, &gl_hchar, 
                                        &gl_wbox, &gl_hbox);
 
                                        /* register as desk     */
                                        /*   accessory          */
 
        gl_ittape = menu_register(gl_apid, ADDR("  Tape Recorder"));
 
                                        /* init. message address*/
        ad_rmsg = ADDR(&gl_rmsg[0]);
                                        /* get desktop size     */
 
        wind_get(0, WF_WXYWH, &gl_xdesk, &gl_ydesk, 
                                        &gl_wdesk, &gl_hdesk);
 
                                        /* initialize mouse     */
        graf_mouse(0, 0x0L);
                                        /* initialize tape      */
        gl_tape = ini_tape();
        tree = gl_tape;
                                        /* get ready for main   */
                                        /*   loop               */
        gl_flags = MU_BUTTON | MU_MESAG;
        gl_button = 0x01;
        gl_ignore = FALSE;
        def_path[0] = NULL;
 
        done = FALSE;
        counter = 0;
        speed = 500;
        gl_numevnts = MAX_EVNTS;
        value = 0;
        slid_len = 20 * gl_wchar;
                                        /* begin main loop      */
        while (!done)
        {
                                        /* wait for mouse       */
                                        /*   button to go down  */
 
          ev_which = evnt_multi(gl_flags, 0x01, 0x01, gl_button,
                                0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0,
                                ad_rmsg, 0, 0, 
                                &mx, &my, &mb, &ks, &kret, &bret);
 
                                        /* handle message       */
          if (ev_which & MU_MESAG)
            if (!(gl_ignore && (gl_rmsg[0] == AC_CLOSE)))
             done = hndl_mesag();
          gl_ignore = FALSE;
 
          if (ev_which & MU_BUTTON)
          {
            if (wh_tape)
            {                           /* input from form      */
 
              wind_get(wh_tape, WF_WXYWH, &xd, &yd, &wd, &hd);
              graf_mkskate(&mx, &my, &junk, &junk);
              curr_ob = objc_find(gl_tape, ROOT, 2, mx, my);
 
              if (curr_ob == SLIDE)
              {
                mod_val = ((gl_numevnts / slid_len) == 0) ? 1 : 
                                        (gl_numevnts / slid_len);
 
                add_on = ((gl_numevnts / slid_len) != 0) ? 1 : 
                                        (slid_len / gl_numevnts);
                objc_offset(tree, ELEVATOR, &xoff, &yoff);
                if (mx <= xoff)
                {
                  counter--;
                  if ((counter % mod_val) == 0)
                    the_tape[ELEVATOR].ob_x -= add_on;
                } /* if mx <= xoff */
                if (mx > xoff)
                {
                  counter++;
                  if ((counter % mod_val) == 0)
                    the_tape[ELEVATOR].ob_x += add_on;
                } /* if */                              
                set_counter(counter, FALSE);
              } /* if SLIDE */
 
              if (curr_ob == ELEVATOR)
              {
                value = graf_slidebox(tree, SLIDE, ELEVATOR, 0);
                counter = MUL_DIV(value, gl_numevnts, 1000);
                value = MUL_DIV(counter, slid_len, gl_numevnts);
                if (value > (slid_len - the_tape[ELEVATOR].ob_width))
                  value = slid_len - the_tape[ELEVATOR].ob_width;
                the_tape[ELEVATOR].ob_x = value;
 
                                        /* this will            */
                                        /* redraw SLIDER        */
 
                set_counter(counter, FALSE);
              } /* if ELEVATOR */
 
              if ((curr_ob >= BUTTON1) && (curr_ob <= BUTTON5))
              {
                for (ii = BUTTON1; ii <= BUTTON5; ii++)      
                {
                  the_tape[ii].ob_state = NORMAL;
                  do_redraw(wh_tape, xd, yd, wd, hd, ii, 0);
                } /* for */
                the_tape[curr_ob].ob_state = SELECTED;
                do_redraw(wh_tape, xd, yd, wd, hd, curr_ob, 0);
                speed = 25;
                switch(curr_ob)
                {
                  case 12:   
                        speed += 9000;
                  case 11:
                        speed += 500;
                  case 10:
                        speed += 225;
                  case 9:
                        break;
                } /* switch */  
              } /* if */
              if ((curr_ob >= BT_LOAD) && (curr_ob <= BT_PLAY))
              {
                the_tape[curr_ob].ob_state = SELECTED;
                do_redraw(wh_tape, xd, yd, wd, hd, curr_ob, 0);
              } /* if */
              if ( curr_ob == BT_TAPE )
              {
                do_close(wh_tape); 
                gl_numevnts = appl_trecord(ADDR(&gl_evlist[0]),
                                                    MAX_EVNTS);
 
                do_open(wh_tape, gl_xtape, gl_ytape, 
                                        gl_wtape, gl_htape);
                wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
                the_tape[ROOT].ob_x = x;
                the_tape[ROOT].ob_y = y;
                the_tape[BT_TAPE].ob_state = NORMAL; 
 
                /*              beep();         */
 
                counter = 0; 
                the_tape[ELEVATOR].ob_x = 0;
                set_counter(0, FALSE);
                set_counter(gl_numevnts, TRUE);
              } /* if BT_TAPE */
              if ( curr_ob == BT_PLAY )
              {
                do_close(wh_tape);
                evnt_left = gl_numevnts - counter;
                appl_tplay(ADDR(&gl_evlist[counter]), 
                                        evnt_left, speed);
 
                do_open(wh_tape, gl_xtape, gl_ytape, 
                                        gl_wtape, gl_htape);
 
                wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
                the_tape[ROOT].ob_x = x;
                the_tape[ROOT].ob_y = y;
                the_tape[BT_PLAY].ob_state = NORMAL;
              } /* if BT_PLAY */
              if ( curr_ob == BT_LOAD )
              {
                no_cancel = get_file(&gl_pfname[0]);
                if (no_cancel)
                { 
                  force_ext(&gl_pfname[0], "TAP");
                  gl_numevnts = read_tape(&gl_pfname[0]);
                  set_counter(gl_numevnts, TRUE);
                } /* if */
                else                                     
                {
                  the_tape[BT_LOAD].ob_state = NORMAL;
                  do_redraw(wh_tape, xd, yd, wd, hd, BT_LOAD, 0);
                } /* else */    
                the_tape[BT_LOAD].ob_state = NORMAL;
                counter = 0;
                value = 0;
                the_tape[ELEVATOR].ob_x = 0;
                set_counter(0, FALSE);
              } /* if BT_LOAD */
              if ( curr_ob == BT_SAVE )
              {
                no_cancel = get_file(&gl_pfname[0]);
                do_redraw(wh_tape, xd, yd, wd, hd, BT_SAVE, 0);
                if (no_cancel) 
                {
                  force_ext(&gl_pfname[0], "TAP");
                  write_tape(gl_numevnts, &gl_pfname[0]);
                }
 
                the_tape[BT_SAVE].ob_state = NORMAL;
              } /* if BT_SAVE */
            } /* if wh_tape */
          } /* if BUTTON */
        } /* while */
}
 
                                        /* since we're a desk   */
                                        /*  accessory we should */
                                        /*  never terminate     */
 
 
 
 
 
 
 
