 
 
 
 
 
 
/*      GIUTILS.C       06/10/85 -- 09/12/85            Gregg Morris    */
/* Utility routines for GEM INSTALL                                     */
 
#include "portab.h"
#include "machine.h"
#include "dosbind.h"
 
#define CR 0x0D
#define TAB 0x09
 
EXTERN LONG     dos_avail();
EXTERN LONG     dos_alloc();
EXTERN WORD     DOS_ERR;
 
EXTERN WORD     yes, butn1, butn2, butn3;
EXTERN WORD     gpatsts;
EXTERN WORD     SRCBUTN;
EXTERN BYTE     *bat_base;
EXTERN BYTE     *bat_pc;
EXTERN BYTE     *batptr;
EXTERN BYTE     DTA[50];
EXTERN BYTE     err_ret;
EXTERN BYTE     newbyte;
EXTERN BYTE     SRCMSG[255];            /* error message for src dsk    */
 
LONG            gl_xbuf;                /* data xfer buffer     */
UWORD           gl_xlen;
 
/************************************************************************/
/* g e t _ s h p a r m s                                                */
/************************************************************************/
        VOID
get_shparms(pstr, pdoex, pisgr, pisgem, pcmd, ptail)
        BYTE            *pstr;
        WORD            *pdoex, *pisgr, *pisgem;
        BYTE            *pcmd, *ptail;
{
        WORD            ii, jj;
        BYTE            *ps;
 
        ps = batptr;
                                                /* skip leading blanks  */
        while (*ps == ' ')
          ps++;
                                                /* get the codes        */
        *pdoex = *ps++ - '0';
        ps++;
        *pisgr = *ps++ - '0';
        ps++;
        *pisgem = *ps++ - '0';
        ps++;
                                                /* get the command      */
        while (*ps != ' ' && *ps != 0x0D && *ps != 0x0A)
          *pcmd++ = *ps++;
        *pcmd = NULL;
        if (*ps == 0x0D)
          ps += 2;
        else
          ps++;
                                                /* get the tail         */
        ii = 1;
        while (*ps != ' ' && *ps != 0x0D && *ps != 0x0A)
          ptail[ii++] = *ps++;
        ptail[ii] = NULL;
                                        /* compute length of tail       */
/*      ii = 1;
        jj = 0;
        while (ptail[ii++])
          jj++;*/
        ptail[0] = strlen(ptail[1]);
} /* get_shparms */
 
/************************************************************************/
/* m o v _ w s t r                                                      */
/************************************************************************/
        BYTE *
mov_wstr(ps, pd)
        BYTE    *ps, *pd;
{
/* given a string terminated by <CR>, <LF>, or <SPACE>, this routine    */
/* strips off leading blanks & returns an ASCII Z terminated string.    */
                                                /* skip leading blanks  */
        while (*ps == ' ')
          ps++;
                                                /* copy the string      */
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          *pd++ = *ps++;
        *pd = NULL;
        return(ps);
} /* mov_wstr */
 
/************************************************************************/
/* n e x t l i n e                                                      */
/************************************************************************/
        WORD
nextline()
{
/* move the batch file pointer to the next line of the file             */
 
        while ( (*bat_pc != 0x0D) && (*bat_pc != 0x1A ) )
          bat_pc++;
        if ( *bat_pc == 0x1A )
          return(FALSE);                                        /* EOF-- exit   
*/
        if (*bat_pc == 0x0D)
          bat_pc += 2;
        return(TRUE);
} /* nextline */
 
/************************************************************************/
/* m o v _ s t r                                                        */
/************************************************************************/
        VOID
mov_str( ps, pd )
        BYTE            *ps, *pd;
{
/* given a string terminated by <CR> or <LF>, this routine strips off   */
/* leading blanks & returns an ASCII Z terminated string.               */
        while ( *ps == ' ' )
          ps++;
        while ( (*ps != 0x0A) && (*ps != 0x0D) )
          *pd++ = *ps++;
        *pd = NULL;
} /* mov_str */
 
/************************************************************************/
/* c p _ a l e r t                                                      */
/************************************************************************/
        BYTE *
cp_alert( ps, pd, butn_flag, pbutn )
        BYTE            *ps, *pd;
        WORD            butn_flag, *pbutn;
{
/* given a pointer to an alert string, this routine strips off leading  */
/* blanks, removes internal <CRLF> & returns a null-terminated string   */
/* in pd. also returns pointer to char. past end of alert.              */
/* note that an alert string may only have <CRLF> after a | or ]        */
        WORD            done;
        BYTE            chr;
                                                /* skip leading blanks  */
        while ( *ps == ' ' )
          ps++;
        *pd = NULL;
 
        if (butn_flag)
        {                       /* pick up default button, if any       */
          *pbutn = 0;
          if (*ps != '[')
            *pbutn = *ps++ - '0';
        } /* if butn_flag */
                                        /* scan string for <CRLF>       */
        done = FALSE;
        while (!done)
        {
          chr = *ps;
          switch(chr)
          {
            case '|':
                *pd++ = *ps++;
                if (*ps == CR)
                {                               /* skip <CRLF>          */
                  ps += 2;
                  while (*ps == TAB || *ps == ' ')
                    ps++;                       /* skip spaces & tabs   */
                } /* if CR */
                break;
            case ']':
                *pd++ = *ps++;
                if (*ps == CR)
                {
                  ps += 2;                      /* skip <CRLF>          */
                  while (*ps == TAB || *ps == ' ')
                    ps++;                       /* skip spaces & tabs   */
                  if (*ps != '[')
                    done = TRUE;
                } /* if */
                break;
            case CR:
                ps += 2;
                done = TRUE;
                break;
            default:
                *pd++ = *ps++;
                break;
          } /* switch */
        } /* while */
        *pd = NULL;
        return(ps);
} /* cp_alert */
 
/************************************************************************/
/* f c o p y                                                            */
/************************************************************************/
        WORD
fcopy( ps, pd )
        BYTE            *ps, *pd;
{
/* copy file ps to file pd                                              */
        LONG            lbase, lavail;
        UWORD           amt_read, amt_wrote;
        UWORD           fsrc, fdst;             /* file handles         */
        WORD            ret;
 
                                        /* allocate memory for buffer   */
        lavail = dos_avail();
        gl_xlen = (lavail > 0x0000FFF0L) ? 0xFFF0 : LLOWD(lavail);
        gl_xlen -= 0x0200;
        gl_xbuf = dos_alloc(LW(gl_xlen));
                                                /* open source file     */
        fsrc = dos_open (ADDR(ps), 0);
        while ( DOS_ERR )
        {
          ret = form_alert(SRCBUTN, ADDR(&SRCMSG[0]));
          if (ret > 1)
            return(FALSE);
          fsrc = dos_open( ADDR(ps), 0 );
        } /* while */
                                        /* create destination file      */
        fdst = dos_create (ADDR (pd), 0);
        if ( DOS_ERR )
        {
          form_alert(0, ADDR("[3][Can't create the file during copy.][ Cancel ]"
) );
          dos_close(fsrc);     
          return(FALSE);
        } /* if DOS_ERR */
                                                /* do the copy          */
        lbase = 0x0L;
        while ( amt_read = read_piece (fsrc, gl_xlen, gl_xbuf) )
        {
          amt_wrote = amt_read;
          if ( amt_wrote != write_piece (fdst, amt_wrote, gl_xbuf) )
          {                                           /* file system error */
            dos_close(fsrc);     
            dos_close(fdst);
            return(FALSE);
          } /* if */
 
          lbase += (LONG) amt_wrote;
          if (amt_read != amt_wrote)
            dos_lseek(fsrc, 0, lbase);
        } /* while */
                                                /* close the files      */      
        dos_close (fsrc);
        dos_close (fdst);
                                                /* free the buffer      */
        dos_free(gl_xbuf, gl_xlen);
        return(TRUE);
} /* fcopy */
 
/************************************************************************/
/* v a l p a t h                                                        */
/************************************************************************/
        WORD
valpath( ptr )
        BYTE    *ptr;
{
/* returns TRUE if path is valid; FALSE otherwise                       */
 
        WORD            ii;
 
        ii = FALSE;
        dos_sfirst( ADDR( ptr ), 0x0010 );
        if ( (DOS_ERR == 0) && (DTA[21] & 0x10) )
          ii = TRUE;
        return( ii );
} /* valpath */
 
/************************************************************************/
/* e x f n a m e                                                        */
/************************************************************************/
        VOID
exfname( ps, pd )
        BYTE            *ps, *pd;
{
/* returns the end of the string past any slashes or colons */
        BYTE            *ptr;
 
        ptr = ps;
        while ( *ptr != NULL )
        {
          if ( (*ptr == ':') || (*ptr == '\\') )
          {
            ptr++;
            ps = ptr;
          } /* if */
          else
            ptr++;
        } /* while */
        while ( *pd++ = *ps++ )
        ;
} /* exfname */
 
/************************************************************************/
/* e x p a t h                                                          */
/************************************************************************/
        VOID
expath( ps, pd )
        BYTE            *ps, *pd;
{
/* returns the head of the path minus filename */
        BYTE            *ptr;
        WORD            ii;
 
        ii = FALSE;
        while ( *ps != NULL )
        {
          if ( (*ps == ':') || (*ps == '\\') )
          {
            ptr = pd;
            ptr++;
            ii = TRUE;
          } /* if */
          *pd++ = *ps++;
        } /* while */
        if ( ii )
          *ptr = '\0';
} /* expath */
 
/************************************************************************/
/* c m p _ s t r                                                        */
/************************************************************************/
        WORD
cmp_str( pa, pb )
        BYTE    *pa,*pb;
{
        WORD            ii;
 
        while ( (*pa == *pb) && (*pa) )
        {
          pa++;
          pb++;
        } /* while */
        ii = FALSE;
        if ( (*pa == NULL) && (*pb == NULL) )
          ii = TRUE;
        return(ii);
} /* cmp_str */
 
/*************************************************************/
/* i n i t f c b                                                        */
/************************************************************************/
        VOID
initfcb( ptr )
        BYTE    *ptr;
{
        WORD    ii;
        BYTE    *ptr1;
 
        ptr1 = ptr;
        for ( ii = 0; ii < 37; ii++ )
          *ptr++ = NULL;
        ptr1++;
        for ( ii = 0; ii < 11; ii++ )
        *ptr1++ = ' ';
} /* initfcb */
 
/************************************************************************/
/* m a k e _ h n u m                                                    */
/************************************************************************/
        WORD
make_hnum(pstr)
        BYTE            *pstr;
{
/* take the given 4-char. string & return a hex number: 0-FFFF          */
        WORD            num, factor, idx;
        BYTE            chr;
 
        num = 0;
        if (!pstr)
          return(num);
                                        /* pick off digits              */
        idx = 3;
        factor = 1;
        while (idx >= 0)
        {
          chr = pstr[idx];
          if (chr >= 'A' && chr <= 'F')
            num += (chr - 'A' + 0x0A) * factor;
          else if (chr >= '0' && chr <= '9')
            num += (chr - '0') * factor;
          factor *= 16;
          idx--;
        } /* while */
        return(num);
} /* make_hnum */
 
 
 
 
 
 
