/*      GIMAIN.C        06/10/85 -- 09/12/85            Gregg Morris    */
/* GEM INSTALL program, based on GEMPREP.C by Don Heiskell              */
/*      Modified        09/10/85 -- 09/17/85            Mitch Smith     */
/*	SCRIPTONFLOPPY	6th Jan 2001			Owen Rudge	*/
 
#include "portab.h"
#include "machine.h"
#include "dosbind.h"
 
#define SCRIPT_ON_FLOPPY   1

/*#define debug    0*/
#define NUMCMDS  15
#define BUF_SIZE 4096 
 
EXTERN LONG     dos_alloc();
EXTERN UWORD    global[];               /* declared in CRYSIF.C         */
EXTERN WORD     QUIT();
EXTERN WORD     DOS_ERR;
EXTERN BYTE     *cp_alert();
 
GLOBAL WORD     gl_apid;
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     gl_smsg[8];
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     ad_smsg;
GLOBAL LONG     four_k = 4096;
GLOBAL LONG     copy_base;
GLOBAL LONG     dummy;
 
GLOBAL WORD     gl_flags, gl_button, gl_out, gl_spacerr;
GLOBAL WORD     yes, butn1, butn2, butn3, hd_sys, vernum;
GLOBAL WORD     gpatsts;
GLOBAL WORD     SRCBUTN;        /* default exit button for SRCMSG       */
 
GLOBAL BYTE     *bat_base;      /* ptr to base of batch file in memory  */
GLOBAL BYTE     *bat_pc;        /* ptr to current position in batch file*/
GLOBAL BYTE     *batptr;
GLOBAL BYTE     DTA[50]; 
GLOBAL BYTE     bat_buf[BUF_SIZE];
 
GLOBAL BYTE     gpatstr[20];
GLOBAL BYTE     newbyte;        /* hard disk drive letter               */
GLOBAL BYTE     SRCMSG[384];            /* error message for src dsk    */
GLOBAL BYTE     alrt_str[384];          /* space for current alert      */
GLOBAL BYTE     gl_cmd[80], gl_tail[80];
MLOCAL BYTE     *commands[] = { "DOS","ALERT","SRCMSG","PATBAT","COPY","MD",
                                "IF1BUTN","IF2BUTN","IF3BUTN","IFHD","IFFD",
                                "GOTO",":","RUN","CHECKVER" };
 
BYTE thedrive; /* OCR 6/1/2001 */

/************************************************************************/
/* p a r s _ b a t                                                      */
/************************************************************************/
        WORD
pars_bat()
{
/* parse the batch file for a match of the string; return index into    */
/* jump table of matching command.                                      */
        WORD            ii;
        BYTE            *pbat, *matptr;
 
        matptr = commands[0];
        for ( ii = 0; ii < NUMCMDS; ii++ )
        {
          pbat = bat_pc;
          while ( (*matptr) && (*matptr == *pbat) )
          {
            matptr++;
            pbat++;
          } /* while */
          if ( !(*matptr) )
          {
            bat_pc = pbat;
            return(ii);
          } /* if */
          while (*matptr)
            matptr++;
          matptr++;
        } /* for */
        return(ii);
} /* pars_bat */
 
/************************************************************************/
/* c _ r u n                                                            */
/************************************************************************/
        VOID
c_run()
{
        WORD            doex, isgr, isgem;
 
        get_shparms(batptr, &doex, &isgr, &isgem, &gl_cmd[0], &gl_tail[0]);
        shel_write(doex, isgr, isgem, ADDR(&gl_cmd[0]), ADDR(&gl_tail[0]));
} /* c_run */
 
/************************************************************************/
/* c _ a l e r t                                                        */
/************************************************************************/
        BYTE *
c_alert()
{
/* display an alert of made from the given string; return ptr to char   */
/* past end of alert                                                    */
        WORD            ret, def_butn;
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, alrt_str, TRUE, &def_butn );
        ret = form_alert(def_butn, ADDR(alrt_str));
        butn1 = butn2 = butn3 = FALSE;
        if (ret == 1)
          butn1 = TRUE;
        if (ret == 2)
          butn2 = TRUE;
        if (ret == 3)
          butn3 = TRUE;
        return(new_ptr);
} /* c_alert */
 
/************************************************************************/
/* c _ c o p y                                                          */
/************************************************************************/
        VOID
c_copy()
{
        WORD            ii, jj, ambigfn, ret;
        BYTE            srcpth[80];
        BYTE            srcstr[80];
        BYTE            desstr[80];
        BYTE            tmpst1[80];
        BYTE            tmpst2[80];
        BYTE            *ps, *pd;
        static BYTE     slash[] =  "\\"; 
 
        graf_mouse(2, 0x0L);                    /* hourglass            */
        ps = batptr;
        while ( *ps == ' ' )
          ps++;
        ii = 0;
        ambigfn = FALSE;
        pd = srcstr;
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
        {
          *pd = *ps;
          if ( (*pd == '*') || (*pd == '?') )
            ambigfn = TRUE;
          pd++;
          ps++;
          ii++;
        } /* while */
        *pd = NULL;
        if ( ii > 0 )
        {
          pd = desstr;
          while ( *ps == ' ' )
            ps++;
          jj = 0;
          while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          {
            *pd++ = *ps++;
            jj++;
          } /* while */
          *pd = NULL;
          --pd;
          if ( ambigfn )
          {
            expath( srcstr, srcpth );
            dos_sfirst( ADDR( srcstr ), 0x0000 );
            while ( !DOS_ERR )
            {
              tmpst1[0] = NULL;
              tmpst2[0] = NULL;
              strcat(tmpst1, srcpth);
              strcat( tmpst1, &DTA[30] );
              strcat( tmpst2, desstr );
              if ( (jj == 0) || (*pd == ':') )
                strcat( tmpst2, &DTA[30] ); 
              else 
              {
                strcat( tmpst2, &slash[0] );    /* add required slash   */
                strcat( tmpst2, &DTA[30] );     /* add fname from src   */
              }
              ret = fcopy( tmpst1, tmpst2 );
              if (!ret)
              {
                if (gl_spacerr)
                  form_alert(1, ADDR("[3][There is not enough free space on the|\
disk to complete this copy. Your|installation may not be complete.][   OK   ]"))
;
                gl_spacerr = FALSE;
                return;
              } /* if !ret */
              dos_snext();
            } /* while !DOS_ERR */
          } /* if ambigfn */
          else
          {
            exfname( srcstr, tmpst1 );
            if ( (jj == 0) || *pd == ':' )
              strcat( desstr, tmpst1 ); 
            else if ( valpath( desstr ) )
            {
              strcat( desstr, &slash[0] );      /* add required slash   */
              strcat( desstr, tmpst1 );         /* add fname from src   */
            } /* else if */
            ret = fcopy( srcstr, desstr );
            if (!ret)
            {
              if (gl_spacerr)
                form_alert(1, ADDR("[3][There is not enough free space on the|\
disk to complete this copy. Your|installation may not be complete.][   OK   ]"))
;
              gl_spacerr = FALSE;
              return;
            } /* if !ret */
          } /* else */
        } /* if ii > 0 */
        graf_mouse(0, 0x0L);
#if debug
        form_alert(1, ADDR("[0][A copy command was encountered.][   OK   ]"));
#endif
} /* c_copy */
 
/************************************************************************/
/* c _ m d                                                              */
/************************************************************************/
        VOID
c_md()
{
/* make a directory                                                     */
        LONG            plong;
        BYTE            chars[80];
 
        mov_wstr( batptr, chars );
        plong = ADDR( chars );
        dos_mkdir( plong );
#if debug
        form_alert(1, ADDR("[0][Made a directory][   OK   ]"));
#endif
} /* c_md */
 
/************************************************************************/
/* c _ g e t d r v                                                      */
/************************************************************************/
        VOID
c_getdrv()
{
        UWORD           drives, hd_flop, mask;
        WORD            ii;
 
        drives = global[13];
        hd_flop = global[14];
        if (hd_flop)                    /* must be a hard-disk system   */
        {
          hd_sys = TRUE;
          mask = 0x0001;
                                /* get the lowest lettered hard disk    */
          for (ii = 15; ii >= 0; ii--)
          {
            if (mask & drives)
            {
              if (mask & hd_flop)
                newbyte = ii + 'A';
            } /* if mask & drives */
            mask <<= 1;
          } /* for */
        } /* if hd_flop */
        else
          hd_sys = FALSE;
} /* c_getdrv */
 
/************************************************************************/
/* c _ p a t b a t                                                      */
/************************************************************************/
        VOID
c_patbat()
{
        BYTE            oldstr[20];
        BYTE            *tmpptr, *ptxt, *matptr;
 
        matptr = bat_pc;
        ptxt = bat_pc;
        mov_wstr( bat_pc, oldstr );
        tmpptr = oldstr;
        while (*ptxt != 0x1A)
        {
          if ( *tmpptr != *ptxt )
          {
            tmpptr = oldstr;
            ptxt++;
            matptr = ptxt;
          }
          else
          {
            while ( (*tmpptr == *ptxt) && (*tmpptr) )
            {
              ptxt++;
              tmpptr++;
            } /* while */
            if (*tmpptr)
              matptr = ptxt;
            else
            {
              tmpptr = oldstr;
              *matptr = newbyte;
            } /* else */
          } /* else */
        } /* while */
} /* c_patbat */
 
/************************************************************************/
/* c _ i f 1 b u t n                                                    */
/************************************************************************/
        VOID
c_if1butn()
{
        if (butn1)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF1BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if1butn */
 
/************************************************************************/
/* c _ i f 2 b u t n                                                    */
/************************************************************************/
        VOID
c_if2butn()
{
        if (butn2)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF2BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if2butn */
 
/************************************************************************/
/* c _ i f 3 b u t n                                                    */
/************************************************************************/
        VOID
c_if3butn()
{
        if (butn3)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF3BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if3butn */
 
/************************************************************************/
/* c _ i f h d                                                          */
/************************************************************************/
        VOID
c_ifhd()
{
        if (hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFHD statement was encountered.][   OK   ]"))
;
#endif
} /* c_ifhd */
 
/************************************************************************/
/* c _ i f f d                                                          */
/************************************************************************/
        VOID
c_iffd()
{
        if (!hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFFD statement was encountered.][   OK   ]"))
;
#endif
} /* c_iffd */
 
/************************************************************************/
/* c _ g o t o                                                          */
/************************************************************************/
        VOID
c_goto()
{
        gotob();
#if debug
        form_alert(1, ADDR("[0][A GOTO statement was encountered.][   OK   ]"));
#endif
} /* c_goto */
 
/************************************************************************/
/* c _ l a b e l                                                        */
/************************************************************************/
        VOID
c_label()
{
#if debug
        form_alert(1, ADDR("[0][A LABEL was encountered.][   OK   ]"));
#endif
} /* c_label */
 
/************************************************************************/
/* c _ s r c m s g                                                      */
/************************************************************************/
        BYTE *
c_srcmsg()
{
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, SRCMSG, TRUE, &SRCBUTN );
#if debug
        form_alert(1, ADDR("[0][A SRCMSG definition was encountered.][   OK   ]"
));
#endif
        return(new_ptr);
} /* c_srcmsg */
 
/************************************************************************/
/* c _ c h k v e r                                                      */
/************************************************************************/
        VOID
c_chkver()
{
        UWORD           testnum;
        BYTE            *ps;
 
        ps = batptr;
        while ( *ps == ' ' )                    /* skip spaces          */
          ps++;
        testnum = make_hnum(ps);
        butn1 = butn2 = butn3 = FALSE;
        if (vernum < testnum)
          butn1 = TRUE;
        else if (vernum == testnum)
          butn2 = TRUE;
        else if (vernum > testnum)
          butn3 = TRUE;
#if debug
        form_alert(1, ADDR("[0][A CHECKVER statement was encountered.][   OK   ]
"));
#endif
} /* c_chkver */
 
/************************************************************************/
/* r e a d _ b a t                                                      */
/************************************************************************/
        VOID
read_bat()
{
        LONG            plong;
        LONG            count;
        WORD            handle, ret;
        static BYTE             no_txt[] = 
"[3][INSTALL can't find the INSTALL.TXT|file. Insert the disk containing|\
INSTALL.TXT and try again.][ Cancel ]";
 
#ifdef SCRIPT_ON_FLOPPY
        static BYTE     *APATH = { "A:\\" };
#else
	static BYTE	*APATH = { ".\\" };
#endif
        static BYTE     *BATCH = { "INSTALL.TXT" };
 
        dos_sdrv( 0 );                          /* select drive A       */

        plong = ADDR( APATH );
        dos_chdir( plong );
        plong = ADDR( BATCH );
 
#ifdef SCRIPT_ON_FLOPPY
        handle = dos_open( ADDR("A:\\INSTALL.TXT"), 0 );
#else
	handle = dos_open( ADDR(".\\INSTALL.TXT"), 0);
#endif

        if ( DOS_ERR )
        {
          form_alert(1, ADDR(no_txt)); 
          dos_free( dummy );
          ret = appl_exit(); 
          QUIT();
        } /* if DOS_ERR */
 
        bat_base = &bat_buf[0];
        bat_pc = bat_base;
        count = read_piece( handle, BUF_SIZE, ADDR(&bat_buf[0]) );
        dos_close( handle );
} /* read_bat */
 
/************************************************************************/
/* g o t o b                                                            */
/************************************************************************/
        VOID
gotob()
{
        WORD            status, advance;
        BYTE            matstr[80];
        BYTE            labstr[80];
        BYTE            *ptr;
 
        mov_wstr( batptr, matstr );             /* get the label        */
        if ( matstr[0] )
        {
          status = FALSE;
          advance = FALSE;
          ptr = bat_base;
          while (!status)
          {
            if ( *ptr == 0x1A )
            {
              status = TRUE;
              ptr = batptr;
            } /* if */   
            else if ( *ptr++ == ':' )
            {
              mov_wstr( ptr, labstr );
              status = cmp_str( labstr, matstr );
            } /* else if */
          } /* while */
          ptr += 2;
          bat_pc = ptr;     
        } /* if */
} /* gotob */
 
/************************************************************************/
/* G E M A I N                                                          */
/************************************************************************/
        VOID
GEMAIN()
{
        WORD            notend, ret, advance;

                                                /* initialize libraries */
        gl_apid = appl_init();
        vernum = global[0];                     /* get version number   */
                                /* find out what drives we've got       */
        hd_sys = FALSE;                 /* default is floppy system     */
        c_getdrv();
        
        ad_rmsg = ADDR(&gl_rmsg[0]);
        ad_smsg = ADDR(&gl_smsg[0]);
                                                /* initialize mouse     */
        graf_mouse(0, 0x0L);
 
        gpatsts = FALSE;
        dummy = dos_alloc( four_k );
        dos_sdta( ADDR( DTA ) );
        read_bat();
#if debug
        form_alert(1, ADDR("[0][Read the bat file ok.][   OK   ]"));
#endif
                                                /* init alert buttons   */
        butn1 = butn2 = butn3 = FALSE;
        advance = FALSE;
        notend = gl_spacerr = TRUE;
        while ( notend )
        {
          dos_sdta( ADDR( DTA ) );
          notend = pars_bat();
          batptr = bat_pc;
          switch(notend)
          {
            case 0:                     /* formerly c_dos();            */
                notend = FALSE;
                advance = FALSE;
                break;
            case 1:
                bat_pc = c_alert();
                advance = FALSE;
                break;
            case 2:
                bat_pc = c_srcmsg();
                advance = FALSE;
                break;
            case 3:
                c_patbat();
                advance = TRUE;
                break;
            case 4:
                c_copy();
                advance = TRUE;
                break;
            case 5:
                c_md();
                advance = TRUE;
                break;
            case 6:
                c_if1butn();
                advance = TRUE;
                break;
            case 7:
                c_if2butn();
                advance = TRUE;
                break;
            case 8:
                c_if3butn();
                advance = TRUE;
                break;
            case 9:
                c_ifhd();
                advance = TRUE;
                break;
            case 10:
                c_iffd();
                advance = TRUE;
                break;
            case 11:
                c_goto();
                advance = TRUE;
                break;
            case 12:
                c_label();
                advance = TRUE;
                break;
            case 13:
                c_run();
                advance = FALSE;
                notend = FALSE;
                break;
            case 14:
                c_chkver();
                advance = TRUE;
                break;
          } /* switch */
          if (advance)
            notend = nextline();
        } /* while */
        dos_free( dummy ); 
        ret = appl_exit();
        QUIT(); 
 
} /* GEMAIN */