#include "portab.h"
#include "machine.h"
#include "dosbind.h"

/* External procedures */

EXTERN WORD cmp_string();
EXTERN VOID concat();
EXTERN WORD dos_cin();
EXTERN WORD drv_test();
EXTERN BYTE *mat_str();
EXTERN VOID mov_str();
EXTERN BYTE *mov_wstr();
EXTERN VOID mov_zstr();
EXTERN WORD neof_tst();
EXTERN VOID printf();
EXTERN BYTE *ptr_mat();
EXTERN UWORD read_piece();
EXTERN LONG read_fil();
EXTERN VOID TERMINAT();

/* External variables */

EXTERN WORD DOS_ERR;
EXTERN BYTE PROGEND;
BYTE gembat[] = " :\\GEM.BAT";
BYTE gemsys[] = " :\\GEMSYS\\";
BYTE config[] = " :\\CONFIG.SYS";
BYTE autoex[] = " :\\AUTOEXEC.BAT";
BYTE comspec[] = "SET COMSPEC= :\\COMMAND.COM\r\n";
BYTE sys[] = ".SYS";
BYTE fnt[] = ".FNT";
BYTE semicln[] = "; ";
BYTE spaces[] = "  ";
BYTE scn_head[] = "Which graphics card and display do you have?\n";
BYTE scn_tail[] = "Type the letter of graphics combination you have.";
BYTE prt_head[] = "Which printer do you have?\n";
BYTE prt_tail[] = "Type the letter of printer you have.";
BYTE mice_head[] = "Which mouse do you have?\n";
BYTE mice_tail[] = "Type the letter of the mouse you have."; 
BYTE port_head[] = "Which communication port are you using?";
BYTE port_tail[] = "Type the letter of the communication port you are using.";
BYTE pport_head[] = "Which printer port are you using?";
BYTE pport_tail[] = "Type the letter of the printer port you are using.";
BYTE printmsg[] = "GEM SYSTEM MASTER DISK";
BYTE driv1msg[] = "GEM DEVICE DRIVER DISK #1";
BYTE start_disk[] = "GEM STARTUP";
BYTE desk_disk[] = "GEM DESKTOP";
BYTE print[] = "A:\\GEMPRINT.SYS";

BYTE crlf[3];		/* contains an crlf string */
BYTE cmd_line[3];	/* contains the null term string of dest drive */
BYTE def_path[83];	/* the default path&drive of scrnstal */

BYTE mous_typ;		/* the mouse type which the user selected */
BYTE mouscmmt[80];	/* contains the mouse comment line */

BYTE mous_port;		/* the mouse port which the user selected */
BYTE portcmmt[80];	/* contains the mouse port comment line */
BYTE prtr_port;		/* the printer port which the user selected */
BYTE pportcmmt[80];	/* contains the printer port comment line */

BYTE drvrprmt[80];	/* contains the device driver disk prompt */
BYTE drvrfnam[9];	/* contains the device driver filename */
BYTE drvrcmmt[80];	/* contains the device driver comment line */
BYTE drvrnumb[10];	/* contains the device driver numbr string */
BYTE prtrprmt[80];	/* contains the printer driver disk prompt */
BYTE prtrfnam[9];	/* contains the printer driver filename */
BYTE prtrcmmt[80];	/* contains the printer driver comment line */
BYTE prtrnumb[10];	/* contains the printer driver numbr string */
BYTE prtrtype;		/* contains the b,s,p that was selected */
BYTE prtrsys[80];	/* contains the config.sys line except port */
BYTE prtrbaud[80];	/* contains the baud rate line */
BYTE gembat_info[1000];	/* contains information for gem.bat file    */


struct font {
    BYTE comment[65];
    BYTE fname[9];
    BYTE disklab[40];
} fontdat[60];

WORD fnt_cnt;		/* count of fonts for this driver */
WORD pfnt_cnt;		/* count of printer fonts */

WORD is_floppy;		/* TRUE if destination is B: */
WORD is_master;		/* TRUE if A drive has system master in it */
WORD is_driver1;	/* TRUE if A drive has Driver Disk 1 in it */
WORD desktop_in_B;	/* TRUE if desktop floppy in drive B: */

/*pointers used in the assign patch up */

BYTE *pnewbuf, *pnew_asign, *pold_asign;

    VOID
GEMAIN()
{
    WORD i;
    BYTE temp;

    is_floppy = ( (cmd_line[0] == 'B') || (cmd_line[0] == 'b') );
    desktop_in_B = FALSE;	/* initially is GEM STARTUP disk */

    do {
    	scr_init();
	gembat_info[0] = 0;

	if (!is_floppy)		/* add to GEM.BAT file            */
	    concat(comspec,gembat_info);

    	scr_choice();
    	mous_choice();
        font_search();
        prt_choice();
        pport_choice();
        pfont_search();

	cls();
	printf( "You have selected the following:\n\nScreen:\n" );
	printf( drvrcmmt );
	printf( "\n" );
	printf( mouscmmt );
	printf( "\n" );
	printf( portcmmt );
	printf( "\n\nPrinter:\n" );
	printf( prtrcmmt );
	printf( "\n" );
	printf( pportcmmt );
	printf( "\n\n" );
	if ((prtr_port & 0x80) > 0x00)
	{
	    if ( (prtr_port & 0x01) == (mous_port & 0x0f) )
	    {
		printf( "WARNING\n");
		printf( "You have attempted to connect both your mouse\n");
		printf( "and printer to the same communication port.\n" );
		printf( "You should answer N to the following question.\n\n");
	    }
	}
	printf( "Are these the correct screen and printer selections? Y/N" );
	temp = 0x00;

	while ( (temp != 'Y') && (temp != 'y')
		 && (temp != 'N') && ( temp != 'n') )
	    temp = dos_cin();

    } while ( (temp == 'N') || (temp == 'n') );

    set_print();
    concat("CD \\GEMSYS\r\n",gembat_info);    /* finish off GEM.BAT file   */
    concat("GEMVDI %1 %2 %3\r\n",gembat_info);				     
    creat_gbat();         /* create GEM.BAT file  		       */

    pat_assign();
    cpy_drvr();


    if ( is_floppy ) {
	if( mous_typ == 2 && desktop_in_B )		/* Set B drive */
            disk_swap( start_disk, "B" );

	else if( mous_typ != 2 && !desktop_in_B )
	    disk_swap( desk_disk, "B" );

	if ( mous_typ != 2 && !is_driver1 )		/* Set A drive */
	    disk_swap( driv1msg, "A" );
    }

    else if ( mous_typ != 2 && !is_master )		/* Set A drive */
        disk_swap( printmsg, "A" );

}

    VOID
disk_swap( plabel, pdisk )
    BYTE *plabel, *pdisk;
{
    cls();
    printf( "Remove the disk from drive ");
    printf( pdisk );
    printf( ".\nInsert the disk labeled ");
    printf( plabel );
    printf( " into drive ");
    printf( pdisk );
    printf( ".\nPress any key to continue." );
    dos_cin();
    printf( "\n" );
}

    VOID
set_print()
{
    WORD	i,count,handle;
    BYTE	*ps,*pd;
    BYTE	tmpstr[256];
    BYTE	tmpstr1[80];
    BYTE	tmpstr2[20];

    if ( ((prtr_port & 0x80)!=0) && ((prtrtype=='b') || (prtrtype=='s')) )
    {
	if ( is_floppy && desktop_in_B )
        {
	    disk_swap( start_disk, "B" );
	    desktop_in_B = FALSE;
        }
        config[0] = cmd_line[0];
        autoex[0] = cmd_line[0];		/* init the file strings */
 	if (( prtr_port & 0x01 ) == 1 )
	{
	    mov_zstr( "MODE COM2:", tmpstr );
	    concat( prtrbaud, tmpstr );
	    concat( crlf, tmpstr );
	    concat( "MODE LPT1:=COM2:", tmpstr );
	    concat( crlf, tmpstr );
	    concat(tmpstr,gembat_info);
	    mov_zstr( crlf, tmpstr1 );
	    concat( prtrsys, tmpstr1 );
	    concat( "2", tmpstr1 );
	    concat( crlf, tmpstr1 );
	}
	else
	{
	    mov_zstr( "MODE COM1:", tmpstr );
	    concat( prtrbaud, tmpstr );
	    concat( crlf, tmpstr );
	    concat( "MODE LPT1:=COM1:", tmpstr );
	    concat( crlf, tmpstr );
	    concat(tmpstr,gembat_info);
	    mov_zstr( crlf, tmpstr1 );
	    concat( prtrsys, tmpstr1 );
	    concat( "1", tmpstr1 );
	    concat( crlf, tmpstr1 );
	}
	ps = tmpstr1;
	pd = tmpstr2;
	ps++;ps++;
	for ( i=0; i<14; i++ )
	    *pd++ = *ps++;
	*pd = '\0';
        ps = tmpstr1;
	count = 0;
	while ( *ps )
	{
	    ps++;
	    count++;
	}
	con_file( config, tmpstr1, count, tmpstr2 );
        mov_zstr( print, tmpstr );
	tmpstr[0] = cmd_line[0];
	i = FALSE;
	fcopy( print, tmpstr, printmsg, i,0x0000,0x00,0x00 );
    }
}

    VOID
con_file( fname, data, new, match )
    BYTE	*fname, *data, *match;
    WORD	new;
{
    WORD	i,count, handle;
    BYTE	*pfile,*ps;
    count = 0;
    pfile = &PROGEND;
    handle = dos_open ( ADDR( fname ), 0 );
    if ( DOS_ERR == FALSE )
    {
	count = read_piece( handle, 0xffff, ADDR( pfile ) );
	i = 0;
	while ( (i<count) && (*pfile != 0x1a ) )
	{
	    if ( ( *pfile >= 'a' ) && ( *pfile <= 'z' ) )
		*pfile = ( *pfile - 'a' ) + 'A';
	    i++; pfile++;
	}
	count = i;
	dos_close( handle );
    }
    *pfile = '\0';
    if ( not_match( data, &PROGEND ) )
    {
	if ( not_match( match,&PROGEND ) )
	{
	    handle = dos_create( ADDR( fname ), 0 );
    	    ps = data;
	    pfile--;
	    if ( (count==0x0000) || (*pfile == 0x0a) || ( *pfile== 0x0d ) )
	    {
		ps++; ps++;
		new--; new--;
	    } 
	    pfile++;
    	    for ( i = 0; i<new; i++ )
    	    {
		*pfile++ = *ps++;
		count++;
    	    }
    	    for ( i=0; i<256; i++ )
        	*pfile++ = 0x1a;
 	    count++;
   	    write_piece( handle, count, ADDR( &PROGEND ) );
    	    dos_close( handle );
	}
	else
	{
	    pfile = ptr_mat( match,&PROGEND );
	    {
	    	handle = dos_create( ADDR( fname ), 0 );
    	    	ps = data;
		pfile--;
		if ( (*pfile != 0x0d) || (*pfile != 0x0a) )
		{
		    ps++; ps++;
		    new--; new--;
		}
		pfile++; 
    	    	for ( i = 0; i<new; i++ )
		    *pfile++ = *ps++;
    	    	write_piece( handle, count, ADDR( &PROGEND ) );
    	    	dos_close( handle );
	    }
	}
    }
}

    WORD
not_match( pmatstr, ptext )
    BYTE	*pmatstr, *ptext;
{
    BYTE	*tmpptr;
    tmpptr = pmatstr;
    while(  (*tmpptr != '\0') && (*ptext != '\0') && ( *ptext != 0x1a ) )
    {
	if ( *tmpptr != *ptext )
	{
	    tmpptr = pmatstr;
	    ptext++;
	}
	else
	{
	    ptext++;
	    tmpptr++;
	}
    }
    if ( *tmpptr == '\0' )
	return( FALSE );
    else
	return( TRUE );
}

    VOID
cpy_drvr()
{
    BYTE    srcstr[80], desstr[80], msgstr[80];
    BYTE    patha[5];
    WORD    i, flag;
    patha[0] = 'A';
    patha[1] = ':';
    patha[2] = '\\';
    patha[3] = '\0';
    mov_zstr( gemsys, desstr );
    concat( drvrfnam, desstr );
    concat( sys, desstr );
    mov_zstr( patha, srcstr );
    concat( drvrfnam, srcstr );
    concat( sys, srcstr );
    flag = TRUE;
    fcopy( srcstr, desstr, drvrprmt, flag, 0x0002,mous_port, mous_typ );
    if ( is_floppy && !desktop_in_B)
    {
        disk_swap( desk_disk, "B" );
	desktop_in_B = TRUE;
    }
    flag = FALSE;
    fnt_cnt += pfnt_cnt;
    for ( i = 0; i < fnt_cnt; i++ )
    {
	mov_zstr( fontdat[i].disklab, msgstr );
	mov_zstr( gemsys, desstr );
	concat( fontdat[i].fname, desstr );
	concat( fnt, desstr );
	mov_zstr( patha, srcstr );
	concat( fontdat[i].fname, srcstr );
	concat( fnt, srcstr );
	fcopy( srcstr, desstr, msgstr, flag, 0x0000,0x00,0x00 );
    }
    flag = TRUE;
    patha[0] = 'A';
    patha[1] = ':';
    patha[2] = '\\';
    patha[3] = '\0';
    mov_zstr( gemsys, desstr );
    concat( prtrfnam, desstr );
    concat( sys, desstr );
    mov_zstr( patha, srcstr );
    concat( prtrfnam, srcstr );
    concat( sys, srcstr );
    if ( prtr_port == 0x81 )
        fcopy( srcstr, desstr, prtrprmt, flag, 0x0001, 0x80, 0x00 );
    else
        fcopy( srcstr, desstr, prtrprmt, flag, 0x0001, prtr_port, 0x00 );
    flag = FALSE;
}

/* copy a file from source path to dest path */
/* patches the driver if the flag is set */
/* error messages are printed if file not found or unable to create dest */

    VOID
fcopy( ps, pd, psrcmsg, patflg, patcnt, patbyt1, patbyt2 )
    BYTE	*ps, *pd, *psrcmsg;
    WORD	patflg, patcnt;
    BYTE	patbyt1, patbyt2;
{
    BYTE	*patptr;
    LONG	count;
    WORD	handle;
    WORD	attr,date,time;

    handle = dos_open( ADDR( ps ), 0 );
    while ( DOS_ERR != FALSE )
    {
        disk_swap( psrcmsg, "A" );
	is_master = cmp_string(printmsg, psrcmsg);
	is_driver1 = cmp_string(driv1msg, psrcmsg);
	handle = dos_open( ADDR( ps ), 0 );
    }

    cls();
    date = dos_getdt( handle );
    time = dos_getim( handle );
    attr = dos_chmod( ADDR( ps ), 0x0000, 0x0000 );
    count = read_fil( handle, 0x000FFFFFL, ADDR(&PROGEND) );
    dos_close( handle );
    if ( patflg )
    {
        patptr = mat_str( "zyxg", &PROGEND );	/* find the patch string */
	*patptr = patbyt1;
	if ( patcnt == 2 )
	{
	    patptr++;
	    *patptr = patbyt2;
	}
    }
    handle = dos_create( ADDR( pd ), 0 );
    if ( DOS_ERR != FALSE )
    {
    	printf( "Can't create the file named " );
	printf( pd );
	printf( "\n" );
    }
    else
    {
	dos_write( handle, count, ADDR(&PROGEND) );
	dos_setdt( handle, time, date );
	dos_close( handle );
	dos_chmod( ADDR( pd ), 0x0001, attr );
    }
}

    VOID
pat_assign()
{
    BYTE    tmpstr[30];
    LONG    wcount;
    WORD    i,count,handle, noteof;
    mov_zstr( gemsys, tmpstr );
    concat( "ASSIGN.SYS", tmpstr );
    handle = dos_open( ADDR(tmpstr), 0 );
    if ( DOS_ERR != FALSE )
    {
        printf( "\nCan't open the assign.sys file.\n" );
        TERMINATE();
    }
    read_fil( handle, 0x000FFFFFL, ADDR(&PROGEND) );
    dos_close( handle );
    handle = dos_create( ADDR(tmpstr) , 0 );
    noteof = TRUE;
    pold_asign = &PROGEND;
    pnew_asign = pnewbuf;
    while ( drv_tst( pold_asign ) != 1 )
	cpy_asgn();
    fix_asgn();
    while ( noteof )
    {
	if ( drv_tst( pold_asign ) == 2 )
	    pfix_asgn();
	else
	    cpy_asgn();
	noteof = neof_tst(pold_asign);
    }
    for ( i = 0; i<256; i++ )
    {
	*pnew_asign = 0x1a;
	pnew_asign++;
    }
    cls();
    pnew_asign = pnewbuf;
    count = 0x0000;
    wcount = 0x00000000L;
    while ( *pnew_asign != 0x1a )
    {
        pnew_asign++;
	count++;
    }
    count++;
    wcount = count;
    dos_write( handle, wcount, ADDR( pnewbuf ));
    dos_close( handle );
}

    VOID
cpy_asgn()
{
    WORD    test;
    test = TRUE;
    while ( test )
    {
	*pnew_asign = *pold_asign;
	if ( (*pold_asign == 0x0a) || (*pold_asign == 0x1a) )
	{
	    test = FALSE;
	    if ( *pold_asign == 0x1a )
	        --pold_asign;
	}
	pnew_asign++;
	pold_asign++;
    }
}

    VOID
fix_asgn()
{
    BYTE   *ps, *pd;
    BYTE   tmpstr[30];
    BYTE   tmpst1[20];
    copy_new();
    nxt_lsrc();
    while( (drv_tst( pold_asign ) == FALSE) && neof_tst(pold_asign) )
	nxt_lsrc();
}

/* copies new driver line, mouse line , port line into new assign.sys */

    VOID
copy_new()
{
    BYTE    *ps, *pd;
    WORD    i;
    ps = pold_asign;
    while ( *ps == ' ' )
 	ps++;
    while ( *ps != ' ' )
    {
	*pnew_asign = *ps;
	ps++; pnew_asign++; 
    }
    *pnew_asign = ' ';
    pnew_asign++;
    cpywoz( drvrfnam );
    cpywoz( semicln );
    cpywoz( drvrcmmt );
    cpywoz( crlf );		/* have copied the filename line */
    cpywoz( semicln );
    cpywoz( mouscmmt );
    cpywoz( crlf );
    cpywoz( semicln );
    cpywoz( portcmmt );
    cpywoz( crlf );		/* have copied the other two comment lines */
    for ( i = 0; i < fnt_cnt; i++ )
    {
	cpywoz( spaces );
        cpywoz( fontdat[i].fname );
	cpywoz( fnt );
	cpywoz( semicln );
	cpywoz( fontdat[i].comment );
	cpywoz( crlf );
    }
}

    VOID
pfix_asgn()
{
    BYTE   *ps, *pd;
    BYTE   tmpstr[30];
    BYTE   tmpst1[20];
    pcopy_new();
    nxt_lsrc();
    while( (drv_tst( pold_asign ) == FALSE) && neof_tst(pold_asign) )
	nxt_lsrc();
}

/* copies new printer driver line, port line into new assign.sys */

    VOID
pcopy_new()
{
    BYTE    *ps, *pd;
    WORD    i;
    ps = pold_asign;
    while ( *ps == ' ' )
 	ps++;
    while ( *ps != ' ' )
    {
	*pnew_asign = *ps;
	ps++; pnew_asign++;
    }
    *pnew_asign = ' ';
    pnew_asign++;
    cpywoz( prtrfnam );
    cpywoz( semicln );
    cpywoz( prtrcmmt );
    cpywoz( crlf );		/* have copied the filename line */
    cpywoz( semicln );
    cpywoz( pportcmmt );
    cpywoz( crlf );		/* have copied the other two comment lines */
    for ( i = fnt_cnt; i < (fnt_cnt+pfnt_cnt); i++ )
    {
	cpywoz( spaces );
        cpywoz( fontdat[i].fname );
	cpywoz( fnt );
	cpywoz( semicln );
	cpywoz( fontdat[i].comment );
	cpywoz( crlf );
    }
}

    VOID
cpywoz( ptr )
    BYTE    *ptr;
{
    while ( *ptr != '\0' )
    {
	*pnew_asign = *ptr;
	pnew_asign++; ptr++;
    }
}

/* moves pold_asign to the next line or to a ^z if in file */

    VOID
nxt_lsrc()
{
    WORD    test;
    test = TRUE;
    while ( test )
    {
	if ( (*pold_asign == 0x1a) || (*pold_asign == 0x0a) )
	{
	    test=FALSE;
	    if (*pold_asign == 0x0a)
		pold_asign++;
	}
	else
	    pold_asign++;
    }
}

    BYTE
*get_choice( pstr, phead, ptail )
    BYTE    *pstr,*phead,*ptail;
{
    BYTE *pselect, *ptxt;
    BYTE tmpstr[81];
    BYTE choice[3];
    WORD i, j;

    choice[0] = 'A';
    choice[1] = ' ';
    choice[2] = '\0';
    printf( phead );
    printf( "\n\n" );
    pselect = mat_str( pstr, &PROGEND );	/* find the leadin string */
    ptxt = ++pselect;
    i = 0;
    while ( *ptxt != '>' )
    {
	if ( *ptxt == '|' )
	{
	    i++;
	    ptxt++;
	    printf( choice );
	    mov_str( ptxt, tmpstr );
	    printf( tmpstr );
	    printf( "\n" );
	    choice[0]++;
	}
	ptxt++;
    }
    printf( "\n\n" );
    printf( ptail );
    j = -1;
    i--;
    while ( (j<0) || (j>i) ) {
	j = dos_cin();
        if ( j >= 0x0041 && j <= 0x005A )
	    j -= 0x0041;
	else if ( j >= 0x0061 && j <= 0x007A )
	    j -= 0x0061;
	else
	    j = -1;
    }
    j++;
    while ( j )
    {
	while ( *pselect != '|' )
	    pselect++;
	pselect++;
	j--;
    }
    return ( pselect );
}

/* scr_choice					    */
/* gets the users choice from available list	    */
/* saves prompt line for proper disk 		    */
/* saves driver file name			    */
/* saves comment line for assign.sys file	    */

    VOID
scr_choice()
{
    BYTE    *pscns;

    cls();
    pscns = get_choice ( ">SCREENS", scn_head, scn_tail );
    mov_str ( pscns, drvrcmmt );	/* save the comment line */
    pscns = mat_str ( crlf, pscns );
    mov_str ( pscns, drvrfnam );
    pscns = mat_str ( crlf, pscns );
    mov_str ( pscns, drvrprmt );
    pscns = mat_str ( crlf, pscns );
    pscns++;
    mov_str ( pscns, drvrnumb );
    pscns = drvrnumb;
    while ( *pscns != ']' )
	pscns++;
    *pscns = '\0';			/* make the number a string */
}

    VOID
mous_choice()
{
    BYTE    *pmouse;

    cls();
    pmouse = get_choice( ">MICE", mice_head, mice_tail );
    mov_str ( pmouse, mouscmmt );
    pmouse = mat_str ( crlf, pmouse );
    mous_typ = *pmouse - 0x30;
    if ( (mous_typ == 2) || (mous_typ == 0) ) {
        mous_port = 0x0f;
 	mov_zstr( "No communication port selected", portcmmt );
    }
    else
        port_choice();
    if (mous_typ == 2)	      /* add to GEM.BAT file		*/
    {
	concat("CD \\GEMBOOT\r\n",gembat_info);
	concat("MOUSE\r\n",gembat_info);
    }
}

    VOID
port_choice()
{
    BYTE *pport;

    cls();
    pport = get_choice( ">MOUSE PORT", port_head, port_tail );
    mov_str( pport, portcmmt );
    pport = mat_str( crlf, pport );
    mous_port = *pport - 0x30;
}

/* prt_choice					    */
/* gets the users choice from available list	    */
/* saves prompt line for proper disk 		    */
/* saves driver file name			    */
/* saves comment line for assign.sys file	    */

    VOID
prt_choice()
{
    BYTE *pscns;

    cls();
    pscns = get_choice ( ">PRINTERS", prt_head, prt_tail );
    mov_str ( pscns, prtrcmmt );	/* save the comment line */
    pscns = mat_str ( crlf, pscns );
    mov_str ( pscns, prtrfnam );
    pscns = mat_str ( crlf, pscns );
    mov_str ( pscns, prtrprmt );
    pscns = mat_str ( crlf, pscns );
    pscns++;
    mov_str ( pscns, prtrnumb );
    pscns = mat_str ( crlf, pscns );
    mov_str ( pscns, prtrsys );
    pscns = mat_str ( crlf, pscns );
    mov_str ( pscns, prtrbaud );
    pscns = prtrnumb;
    while ( *pscns != ']' )
	pscns++;
    pscns--;
    prtrtype = *pscns;
    *pscns = '\0';			/* make the number a string */
}

    VOID
pport_choice()
{
    BYTE *pport;

    cls();
    pport = get_choice( ">PRINTER PORT", pport_head, pport_tail );
    mov_str( pport, pportcmmt );
    pport = mat_str( crlf, pport );
    if ( *pport == '9' )
	prtr_port = 0x81;
    else
    {
        if ( *pport == '8' )
        {
	    pport++;
	    prtr_port = (*pport - 0x30) + 0x80;
        }
        else
	    prtr_port = *pport - 0x30;
    }
}

/* printer font_search					*/
/* searches the text file for any fonts for this device */

    VOID
pfont_search()
{
    BYTE *txtptr, *tmpptr;

    cls();
    pfnt_cnt = 0;

    /* find the leading string */

    txtptr = mat_str( ">PRINTER FONTS", &PROGEND );
    while ( *txtptr != '>' )
    {
        if ( *txtptr == '|' )
	{
	    tmpptr = txtptr;
	    while ( *tmpptr != '[' )
	        tmpptr++;
	    if ( cfnt_num( tmpptr,prtrnumb ) )
	    {
	        txtptr++;
		mov_str ( txtptr,  &fontdat[fnt_cnt+pfnt_cnt].comment );
		txtptr = mat_str( crlf, txtptr );
		mov_wstr( txtptr, &fontdat[fnt_cnt+pfnt_cnt].fname );
		txtptr = mat_str( crlf, txtptr );
		mov_str( txtptr, &fontdat[fnt_cnt+pfnt_cnt].disklab );
		pfnt_cnt++;
	    }
	    txtptr = tmpptr;
	}
	else
	    txtptr++;
    }
}

/* font_search					    */
/* searches the text file for any fonts for this device */

    VOID
font_search()
{
    BYTE *txtptr, *tmpptr;

    cls();
    fnt_cnt = 0;

    /* find the leading string */
    
    txtptr = mat_str( ">SCREEN FONTS", &PROGEND );
    while ( *txtptr != '>' )
    {
        if ( *txtptr == '|' )
	{
	    tmpptr = txtptr;
	    while ( *tmpptr != '[' )
		tmpptr++;
	    if ( cfnt_num( tmpptr,drvrnumb ) )
	    {
	        txtptr++;
		mov_str ( txtptr,  &fontdat[fnt_cnt].comment );
		txtptr = mat_str( crlf, txtptr );
		mov_wstr( txtptr, &fontdat[fnt_cnt].fname );
		txtptr = mat_str( crlf, txtptr );
		mov_str( txtptr, &fontdat[fnt_cnt].disklab ); 
		fnt_cnt++;
	    }
	    txtptr = tmpptr;
	}
	else
	    txtptr++;
    }
}

/* search for a font number match */

    WORD
cfnt_num( fntptr, matptr )
    BYTE    *fntptr,*matptr;
{
    BYTE    *tmpptr;
    WORD    retval, testit;

    tmpptr = matptr;
    retval = FALSE;
    testit = TRUE;
    while ( testit )
    {
	if ( (*matptr == '\0') || (*matptr < '0') || (*matptr > '9') )
 	{
	    testit = FALSE;
	    if ( is_floppy )
	        retval = ( *fntptr == 'f' || *fntptr == 'F' );
	    else
	        retval = ( *fntptr < '0' || *fntptr > '9' );
	}
	else
	{
	    if ( *fntptr == ']' )
	        testit = FALSE;
	    else
	    {
		if ( *matptr != *fntptr )
		    matptr = tmpptr;
		else
		    matptr++;
                fntptr++;
	    }
	}
    }
    return( retval );
}

/* scr_init					    */
/* inquires the currently logged drive and path     */
/* gets the dest drive letter from command line	    */
/* reads the gemsetup.txt file into memory	    */

    VOID
scr_init()
{
    WORD    cur_driv, handle;
    BYTE    tempstr[83];
    handle = 0x2000;
    pnewbuf = &PROGEND;
    pnewbuf +=handle;
    mous_typ = 0x00;
    crlf[0] = 0x0d;
    crlf[1] = 0x0a;
    crlf[2] = '\0';
    cur_driv = dos_gdrv() + 0x0041;
    def_path[0] = cur_driv;
    def_path[1] = ':';
    def_path[2] = '\\';
    dos_gdir( 0x0000, ADDR(&def_path[3]) );
    if ( def_path[3] == '\0' )
	def_path[2] = '\0';
    tempstr[0] = '\0';
    concat ( def_path, tempstr );
    concat ( "\\GEMSETUP.TXT", tempstr );
    handle = dos_open( ADDR( tempstr ), 0 );
    if ( DOS_ERR != FALSE )
    {
        printf ("\nCan't open GEMSETUP.TXT.\n");
	TERMINATE();
    }
    read_fil( handle, 0x000FFFFFL, ADDR(&PROGEND) );
    dos_close( handle );
    if ( cmd_line[0] == '\0' )
    {
	cmd_line[0] = def_path[0];
    	cmd_line[1] = '\0';
	printf( "\nNo drive was entered on the command line\n" );
    }
    comspec[12] = gemsys[0] = cmd_line[0];
}


    VOID
creat_gbat()
{
    LONG count;
    WORD handle, i;

    gembat[0] = cmd_line[0];   /* get specified drive        */
    for ( i=0; i < 1000; i++) {
	if(gembat_info[i] == 0)
	    break;
    }
    handle = dos_create(ADDR(gembat),0);
    count = i;
    dos_write(handle,count,ADDR(gembat_info));
    dos_close(handle);
}

