/*******************************************************************************/
/* GEMP3 2.1: An MP3 player for GEM                                            */
/* Copyright (c) Owen Rudge 2000-2001. Uses LibAmp, Allegro and DJGPP          */
/*                                                                             */
/* The code in MP3PLAY.CC is from SETEdit. Window/button code by Heinz Rath    */
/* Please see http://www.owenrudge.co.uk/GEM/ for more information.            */
/*                                                                             */
/* This application is licensed under the terms of the General Public License, */
/* version 2.0 or higher. See the included LICENSE.TXT for details.            */
/*******************************************************************************/

/* Revision History:

  3/9/2000:   GEMP3 started

  ../9/2000:  Improved: menus, file selectors etc. A heap of stuff, really.

  27/9/2000:  Added call to fs_ex_input for FreeGEM

  28/9/2000:  Changed code so after MP3 plays, Open dialog doesn't appear, and
              Cancel in File Selector leaves filename, etc, blank

  2/10/2000:  First prototype of Heinz Rath's new window and button code

  11/11/2000: Changed main() to GEMAIN() so errors don't occur if user renames
              GEMP3.APP to .EXE and tries to run it from DOS

  12/11/2000: Made background cyan and added logo

  21/11/2000: Changed logo (and quickly changed it back) and renamed to .DAT

  26/11/2000: Add MP3 -> WAV conversion function and updated file selector function
              to allow more customisation

  17/12/2000: Added GEM/XM trap - GEMP3 does not run under XM

  17/12/2000: Added multi-language support (not super at the moment)

  27/12/2000: Fixed multi-language support, and added SELLANG

  27/12/2000: Changes GEMAIN() to main() again and added own AES check because of
              SELLANG

  31/12/2000: Implemented graphical representation of music. Code taken from LIBDEMO,
              and modified to suit GEM. Only problem: too slow.

  1/1/2001:   Discovered the graphics are fine when the mouse is off-screen

  1/1/2001:   Fixed a small bug where MP3s without a genre inherited the last played
              genre

  2/1/2001:   Added small update to Info() because of German translation (button needed
              to be bigger)

  3/1/2001:   Added code to check GEMP3.CFG on whether to do graphics or not

  6/1/2001:   Added #ifdef CHANGE_PALETTE, and by default didn't change it

  ?/1/2001:   Changed window handler so user could click on window to activate it
              (WM_TOPPED)

  13/1/2001:  Fixed a bug that crashes GEMP3 when run from another directory from RSC, DAT's etc

  14/1/2001:  Merged in some code Heinz had sent me ages ago but I didn't merge in
              because I didn't realise it had new features in!

  22/1/2001:  Changed time in title bar to show current and total time

  22/1/2001:  Made Cancel button in Convert to WAV function actually cancel

  22/1/2001:  Reformatted a fair bit of this file to fit my style (a lot of the code came from
              different places - Heinz, LibAmp Demo, DJGPP bindings, sample apps....) and changed
              all hard tabs to three spaces - please try to stick to this layout :-)

  23/1/2001:  Started work on encoding feature

  24/1/2001:  Added DLX support for encoder

  3/2/2001:   Made encoder work (actually a problem in BLADEENC.DLL - exit() was being
              called when finished). Also added dummy DLL and renamed to ENCODE.DLL.

  16/2/2001:  Added Options menu with Visualisation option - I plan to add languages too

  16/2/2001:  Attempted to localise /SETLANG program, but failed. Will try again sometime.

  16/2/2001:  Made path display with '\' as the path seperator instead of '/'

  17/2/2001:  Adding skin support including support for changing the title bar colour under
              FreeGEM (but not title bar text, as I can't seem to find what to change)

  18/2/2001:  Added pattern support to skins and put skin details in dialog instead of menu

  18/2/2001:  Tried to get Encoder details working but it wouldn't

  18/2/2001:  Added Free Memory count to About box

  18/2/2001:  Added ReadLangStr cache.

  19/2/2001:  Added code to get name of encoder DLL from GEMP3.CFG

  19/2/2001:  Disabled cache as some problems surfaced

  19/2/2001:  Got keyboard shortcuts working again (it's a good job I noticed the GEMKEYBD.H
              file!)

  10/3/2001:  Placed a couple of skin-related strings into LANG.DAT

  23/3/2001:  Added custom compressed bitmap format

  24/3/2001:  Did more work on GEMP3 bitmap format

  31/3/2001:  Modified form_do so that music plays in background
                                                                                             VER
  20/5/2001:  Tried to added default skin generator (BTW, I've lost pretty much everything   2.2
              I've done on GEMP3 during April due to a hard disk crash, so no
              easter egg for now!). Started adding version numbers.

  21/6/2001:  Added build date to about box (was added back in April but I lost that)        2.2

  30/6/2001:  Started adding full-screen visualisation to GEMP3. Spent ages trying to write  2.2
              code to make Allegro not switch back to text mode when GEMP3 exits.

  14/7/2001:  Recompiled with Allegro WIP 3.9.37. Something broke - I get bitmap loading     2.2
              errors. Could be the new get_config_string routine. It turns out that the new
              Allegro doesn't like spaces in section names, so [GEMP3 Skin] broke it. Changed
              it to [GEMP3_Skin]

  22/8/2001:  Attempted to add ID3v1.1 support (see MP3PLAY.CC). It doesn't seem to be       2.2
              working... :-(

  22/9/2001:  Released GEMP3 2.2 beta. This uses Allegro WIP 3.9.38. Added F.S. Vis. to      2.2
              Options menu.

  15/12/2001: Added Allegro Setup program in GP3SETUP.EXE. Built GEMP3 with Allegro 4.0.     2.2
              Oh, and GEMP3 2.2 beta still hasn't been released. Oh dear...
*/

//#define LOAD_GEMP3_BMP
#define GEMP3_CC

#include <sys/version.h>  // DJGPP version
#include <sys/stat.h>
#include <allegro.h>
#include <allegro/aintern.h>
#include <string.h>
#include <limits.h>
#include <unistd.h>
#include <stdarg.h>
#include <fcntl.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>  // for delay

#include <process.h>
#include "dlx.h"
#include "djc.h"

extern "C" {
#include "djgppgem.h"
#include "gemkeybd.h"
#include "mp3play.h"
#include "libamp.h"
#include "gemp3.h"
#include "gemp3rsc.h"
#include "button.h"

void ExportDLXTable();

extern BOOLEAN GEMP3_ShowDialog;
}

extern "C" void shutdown_gfx(void); // allegro function

#define M_GRAPHICS

#ifdef M_GRAPHICS
   void DrawMusicGraphics();
   void my_vline(WORD hndl, int x1, int y1, int y2, int col);
   void my_hline(WORD hndl, int x1, int y1, int x2, int col);
   void putgrafpixel(WORD x,WORD y,WORD c1);

   #define CLEAR_PIXELS

   #ifdef CLEAR_PIXELS
      typedef struct {
         int x;
         int y;
      } PIXEL_INFO;
    
      PIXEL_INFO PixelClear[1000];
      int NumPixels;
   #endif
#endif

#include "lang.h"
#include "skin.h"

extern MP3Player mp3;

#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)((unsigned long)(l) >> 16))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((WORD)(w) >> 8) & 0xFF))

WORD ev_which;
WORD gl_apid;
X_BUF_V2 gl_xbuf;

#ifdef CHANGE_PALETTE
   WORD normal_cols[3];
   WORD normal_cols13[3];

   #define PAL_BTN_COL   15
   #define PAL_TXT_COL   13
#else
   #define PAL_BTN_COL   6
   #define PAL_TXT_COL   12
#endif

LONG gl_menu;
WORD gl_rmsg[8];

int action;
BYTE file_name[PATH_MAX];
BYTE cnv_fn[PATH_MAX];

int NOTHING = 0;
int LOAD = 1;

int convert2wav = FALSE;

extern "C" int get_file(char *fn_out, char *title, char *type);
VOID get_path(BYTE *tmp_path, BYTE *spec);
VOID add_file_name(BYTE *dname, BYTE *fname);
WORD hndl_menu(WORD title, WORD item);
BOOLEAN hndl_msg();
BOOLEAN hndl_kbd(UWORD kbs, UWORD kc);
BOOLEAN do_about(WORD item);
LONG do_convert(char *fn);
LONG do_encode();

#ifdef LOAD_GEMP3_BMP
   void LoadBitmap(char *fn, int x, int y);
   void Load_GEMP3_BMP(char *fn, int x, int y);
#else
   #define LoadBitmap(fn, x, y) LoadBmp(fn, x, y)
#endif

void LoadBmp(char fn[80], int x, int y);
void Putpixel(WORD x,WORD y,WORD c1);
void filename_upper();

void show_hide(WORD, LONG);

int oc,mode;

LONG P_PAUSE;
LONG P_UNPAUSE;

GRECT work_area; /* Must be GLOBAL !!!! */
unsigned char FH;  /* Must be GLOBAL !!!! */
WORD WIN,vdi_handle; /* Must be GLOBAL !!!! */
WORD xb[20],yb[20],yl[20]; /* Must be GLOBAL !!!! */
char btxt[20][50];  /* Must be GLOBAL !!!! */
void Info(void);
void cls(void);
void TextColor(int color);
void print(int x,int y,char *txt);
void cprint(int x,int y,char *txt);
void PressButton(int nr);
void Title(char *stx);
void Init(int br,int zh,int x,int y);
void close(void);
void Button(int nr,int x,int y,char *b);
void Box(int x,int y,int w,int h);
void sel_file_xtnd(void);

void fs_sset(LONG, WORD, LONG, LONG, WORD);

extern LPWORD pGlobal;

extern "C" char * ReadLangStr(int id);
char * GetLangSection(int language);

#ifdef USE_THE_CACHE
char *LangStrCache[75];
#endif

void DoSelLang();

int current_lang = 1;
char *RSCName;

static char *fail = "GEMAES not present in memory.\r\n";
static char *exte = "Execution terminated.\r\n";

int DoAESCheck();

int DrawGraphics = 0;

extern "C" void GEMP3_SetLabel(int lbl, const char *txt);
extern "C" void GEM_ShowProgressDialog();

extern int    (*DLXUnload)(hdlx_t handle);
extern int    (*DLXImport)(char** symbols);

//extern "C" {
void* __builtin_new(size_t mysize);
void __builtin_delete(void* myptr);

typedef int (*FUNC)(int argc, char *argv[]);

LONG encode_tree;

char *skinname;
char skinfn[200];

int GetSkinColour(int id);
int GetSkinColourFile(char *id);
char * GetSkinData(char *id);

int SkinColours[30];
void LoadSkin();
void ChooseSkin();
void GenerateSkin();

BOOLEAN ColoursChanged = FALSE;

VOID hex(char **s, int *val, WORD ndig);
WORD hexdgt(char **s);

BOOLEAN ignorebmpcalls = FALSE;

BOOLEAN do_skininfo();

#define TE_TXTLEN(x)    (x + 24)   	/* TEDINFO text length	 */

extern WORD form_do_bm(LPTREE tree, WORD start_fld);

////////////////////////VIS////
extern void DoVis();

extern "C" void set_gem_screen_mode();

void DoVerInfo();

int main(int argc, char *argv[])
{
   BOOLEAN hideprogressdlg;
   BOOLEAN hideencodedlg;
   BOOLEAN playanother;
   BOOLEAN StopClicked;
   LONG progtree;
   int last_time;
   int current_time;
   char *fnp;
   int gf;

   char buffer[200];
   char msg[PATH_MAX + 75];

   int finished;
   UWORD wx,wy,mb,mx,my,kbs,kc;
   unsigned char button,i;
   char ch[128];
   char message[200];

   char cwd[100];
   char pathstr[100];
   char *pathloc;

   if (argc == 2)
   {
      if (strstr(argv[1], "/SELLANG") != NULL)
      {
         DoSelLang();
         return(0);
      }
      else if (strstr(argv[1], "/VERINFO") != NULL)
      {
         DoVerInfo();
         return(0);
      }
   }

   getcwd(cwd, 100);
// printf("%s\n", cwd);

   pathloc = strrchr(argv[0], '/');
   memset(pathstr, 0, sizeof(pathstr));
   memcpy(pathstr, argv[0], pathloc-argv[0]);
// printf("%s", pathstr);

   if (DoAESCheck() == 1) return(1);

   memset(&gl_xbuf, 0, sizeof(gl_xbuf));
   gl_xbuf.buf_len = sizeof(gl_xbuf);

   chdir(pathstr);

#ifdef USE_THE_CACHE
   for (i = 0; i < 75; i++)
      LangStrCache[i] = NULL; // make sure cache points to nothing
#endif

   set_config_file("GEMP3.CFG");
   current_lang = get_config_int("Language", "Current", 1);
   DrawGraphics = get_config_int("Visualisation", "Active", 0);
   skinname = (char *)get_config_string("Skin", "Current", "STANDARD.SKN");

#ifdef SKIN_GENERATOR
   if (strstr(skinname, "ERROR!") != NULL)
   {
       strcpy(skinname, "_TMPSKIN.SKN");
       GenerateSkin();
   }
#endif

   strcpy(skinfn, skinname);

   gl_apid = appl_init(&gl_xbuf);

   if (LSGET(pGlobal + 2) > 1) /* check for XM */
   {
      dj_form_alert(1, ReadLangStr(LANG_NOXM));
      appl_exit();
      return(0);
   }

   set_config_file("LANG.DAT");
   RSCName = ReadLangStr(LANG_RSCNAME);

   if (strstr(RSCName, "ERROR!") != NULL)
       strcpy(RSCName, "GEMP3RSC.RSC");

   if (!rsrc_load(RSCName))
   {
      sprintf(message, ReadLangStr(LANG_CANTFINDRSC), RSCName);
      dj_form_alert(1, message);
      return(1);
   }

   rsrc_gaddr(R_TREE, MENUBAR, &gl_menu);
   menu_bar(gl_menu, TRUE);

   LoadSkin();

   rsrc_gaddr(R_STRING, STRPAUSE, &P_PAUSE);
   rsrc_gaddr(R_STRING, STRUNPAU, &P_UNPAUSE);

   if (argc != 2)
      gf = get_file(file_name, NULL, NULL);
   else
   {
      strcpy(file_name, cwd);
      strcat(file_name, "/");
      strcat(file_name, argv[1]);
   }

   menu_ienable(gl_menu, STOP, 1);
   menu_ienable(gl_menu, PLAY, 0);
   menu_ienable(gl_menu, PAUSE, 1);
   menu_ienable(gl_menu, FASTFORW, 1);
   menu_ienable(gl_menu, REWIND, 1);
   menu_text(gl_menu, PAUSE, P_PAUSE);

   menu_icheck(gl_menu, OPTNVISL, DrawGraphics);

   filename_upper();

   fnp = file_name;

   while (*fnp)  /* change '/' to '\' for display */
   {
      if (*fnp == '/') *fnp = '\\';
      ++fnp;
   }

   Init(75, 12, 20, 40);
   cls();

   ExportDLXTable();

   set_config_file("GEMP3.CFG");
   if (mp3.Init() == 1) /* if failed to init */
   {
      if (ColoursChanged == TRUE)
          xgrf_colour(CC_NAME, SkinColours[10], SkinColours[11], SkinColours[12], SkinColours[13]);

      appl_exit();
      return(1);
   }

   mp3.SelectNewFile(file_name);
   mp3.PlaySelectedFile();

   Info();

playit: ;
   finished = FALSE;
   playanother = FALSE;
   StopClicked = FALSE;

   while(finished == FALSE)
   {
      if (hideprogressdlg == TRUE)
      {
         show_hide(FMD_FINISH, progtree);
         graf_mouse(0, NULL);
         hideprogressdlg = FALSE;
      }

/*      if (hideencodedlg == TRUE)
      {
         show_hide(FMD_FINISH, progtree);
         graf_mouse(0, NULL);
         hideencodedlg = FALSE;
      }*/

      current_time = mp3.GetTime();
      if (current_time != last_time)
      {
         sprintf(msg,ReadLangStr(LANG_TITLETIME), file_name, current_time/60,current_time%60, mp3.TotalLen/60,mp3.TotalLen%60);
         Title(msg);
         last_time = mp3.GetTime();
      }

      ev_which = evnt_multi(MU_M1 | MU_MESAG | MU_TIMER | MU_KEYBD,
                            1, 3, 1, 0, 0,0,800, 600,
                            NULL,NULL, NULL, NULL, NULL,
                            gl_rmsg, 0, 0,
                            &mx, &my, &mb, &kbs, &kc, NULL);

      if (ev_which & MU_M1)
      {
         if (mb!=0)
         {
            button=255;
            wx=work_area.g_x;
            wy=work_area.g_y;
            mx=mx-wx;
            my=my-wy;
/*          sprintf(ch,"%d %d %d",mx,my,mb);
            cprint(20,10,ch);*/
            delay(100);
            for (i=0;i<19;i++)
            {
               if (mx>=xb[i] && mx<=yl[i] && my>=yb[i] && my<=yb[i]+FH)
               {
                  button=i;
                  delay(100);
                  PressButton(button);
                  mb=0;
                  }
               }
               action=NOTHING;
               if (button==PlayBtn) action=PLAY;
               if (button==StopBtn) action=STOP;
               if (button==OpenBtn) action=FILEOPEN;
//             if (button==OpenBtn) sel_file_xtnd();
               if (button==ForwardBtn) action=FASTFORW;
               if (button==RewindBtn) action=REWIND;
               if (button==PauseBtn) action=PAUSE;
            }
         }
      if (ev_which & MU_MESAG)
      {
         wind_update(BEG_UPDATE);
         if (hndl_msg())
            finished = TRUE;
         wind_update(END_UPDATE);

      }

      if (ev_which & MU_KEYBD)
      {
         wind_update(BEG_UPDATE);
         if (hndl_kbd(kbs, kc))
            finished = TRUE;
         wind_update(END_UPDATE);
      }

      if (action != NOTHING)
      {
         switch(action)
         {
            case FILEOPEN: // Load
                 mp3.Stop();
                 finished = TRUE;
                 playanother = TRUE;
                 action = NOTHING;
                 break;

            case CONV2WAV: // Convert to WAV
                 mp3.Stop();
                 action = NOTHING;
                 if (get_file(cnv_fn, ReadLangStr(LANG_SELECTWAV), "*.WAV") != 25)
                 {
                     progtree = do_convert(cnv_fn);
                     hideprogressdlg = TRUE; /* needed because of MP3 conversion routine prob */
                 }

                 break;

            case ENCODE: // Encode MP3
                 mp3.Stop();
                 action = NOTHING;
                 progtree = do_encode();
                 if (progtree != NULL)
                    hideencodedlg = TRUE; /* needed because of MP3 conversion routine prob */

                 break;

            case FASTFORW: // Fast forward
                 mp3.FFwd();
                 action = NOTHING;
                 break;

            case REWIND: // Rewind
                 mp3.Rew();
                 action = NOTHING;
                 break;

            case PLAY:
                 mp3.PlaySelectedFile();
                 StopClicked = FALSE;
                 action = NOTHING;
                 break;

            case STOP:
                 mp3.Stop();
                 StopClicked = TRUE;
                 action = NOTHING;
                 break;

            case PAUSE:
                 if (mp3.Paused == 1)
                 {
//                    if (!mp3.Converting && !mp3.Stoped)
//                       seek_amp_rel(-1*amp_samprat/amp_pollsize); /* seek back 1 second */

                    menu_text(gl_menu, PAUSE, P_UNPAUSE);
                 }
                 else
                    menu_text(gl_menu, PAUSE, P_PAUSE);

                 mp3.TogglePause();
                 action = NOTHING;
                 break;
         }
      }

      if (ev_which & MU_TIMER)
      {
         mp3.Poll();

         if (mp3.Stoped == TRUE && mp3.Paused == FALSE && StopClicked == FALSE)
         {
            playanother = TRUE;
            finished = TRUE;
         }
         else
         {
#ifdef M_GRAPHICS
            if (DrawGraphics == 1)
               DrawMusicGraphics();
#endif
         }
      }

   }

   if (playanother == TRUE)
   {
      mp3.Genre = NULL;
      get_file(file_name, NULL, NULL);

      mp3.SelectNewFile(file_name);
      mp3.PlaySelectedFile();

      close();

      Init(75, 12, 20, 40);
      cls();
      Info();
/*    sprintf(buffer, "Title:   %s\nAuthor:  %s\nAlbum:   %s\nComment: %s\nGenre:   %s\n\nBitrate: %dHz/%dkbps  %s", mp3.Title, mp3.Author, mp3.Album, mp3.Comment, mp3.Genre, mp3.SampleRate, mp3.BitRate, mp3.Mode);
      gemprintf(buffer);*/

      menu_ienable(gl_menu, STOP, 1);
      menu_ienable(gl_menu, PLAY, 0);
      menu_ienable(gl_menu, PAUSE, 1);
      menu_ienable(gl_menu, FASTFORW, 1);
      menu_ienable(gl_menu, REWIND, 1);
      menu_text(gl_menu, PAUSE, P_PAUSE);

      goto playit;
   }

   mp3.deInit();
   close();
      
#ifdef CHANGE_PALETTE
   vs_color(vdi_handle, 13, normal_cols13);
   vs_color(vdi_handle, 15, normal_cols);
#endif

   if (ColoursChanged == TRUE)
      xgrf_colour(CC_NAME, SkinColours[10], SkinColours[11], SkinColours[12], SkinColours[13]);

   allegro_exit();

   set_gem_screen_mode();
   appl_exit();

   return(0);
}

/////////////////////////////////////////////GEM STUFF ///////////////////////////////////

DLX_FN int get_file(char *fn_out, char *title, char *type) /* use file selector to get input file	*/
{
   WORD  fs_iexbutton;
   BYTE  fs_iinsel[13];

   if (type == NULL)
      get_path(fn_out, "*.MP3,*.MP2");
   else
       get_path(fn_out, type);

   fs_iinsel[0] = '\0';

   filename_upper();  // GEM/5 behaves oddly if using a lowercase or mixed path (Win only)

   if (gl_xbuf.arch)
   {
      if (title == NULL)
         fsel_exinput(fn_out, fs_iinsel, &fs_iexbutton, ReadLangStr(LANG_SELECTMP3));
      else
         fsel_exinput(fn_out, fs_iinsel, &fs_iexbutton, title);
   }
   else
       fsel_input(fn_out, fs_iinsel, &fs_iexbutton);

   if (GEMP3_ShowDialog == TRUE)
   {
      show_hide(encode_tree, FMD_START); /* make sure Encoding dialog is displayed */
      appl_yield();
   }

   if (fs_iexbutton)
      add_file_name(fn_out, fs_iinsel);
   else if (fs_iexbutton == 0)
      return(25);
} DLX_EF; /* get_file */

VOID
get_path(BYTE *tmp_path, BYTE *spec)   /* get directory path name  */
{
   char *s;

   getcwd(tmp_path, PATH_MAX);   /* [JCE] Using DJGPP's library in
                                  * preference to the DOS bindings */
   s = tmp_path;

   while (*s)  /* GEM behaves oddly if / is used */
   {           /* as the path separator */
      if (*s == '/') *s = '\\';
      ++s;
   }

   if (strlen(tmp_path) > 3)
      strcat(tmp_path, "\\");
   else
      tmp_path[2] = '\0';
   strcat(tmp_path, spec);
}

VOID
add_file_name(BYTE *dname, BYTE *fname)   /* replace name at end of input file spec*/
{
   BYTE  c;
   WORD  ii;

   ii = strlen(dname);
   while (ii &&(((c = dname[ii-1])  != '\\') && (c != ':')))
      ii--;
   dname[ii] = '\0';
   strcat(dname, fname);
}

/*------------------------------*/
WORD
hndl_menu(WORD title, WORD item)
{
   WORD done;

   action = NOTHING;
   done = FALSE;

   switch (item)
   {
      case DESKINFO:
         /*if (mp3.Paused == 0)
         {
            mp3.TogglePause();
            do_about(item);
            Info();
            mp3.TogglePause();
         }
         else
         {*/
         do_about(item);

         //}

         break;
      case FILEOPEN:
         action = FILEOPEN;
         break;
      case FILEQUIT: /* Quit - Exit back to Desktop */
         done = TRUE;
         break;
      case PAUSE:
         action = PAUSE;
         break;
      case FASTFORW:
         action = FASTFORW;
         break;
      case REWIND:
         action = REWIND;
         break;
      case PLAY:
         action = PLAY;
         menu_ienable(gl_menu, STOP, 1);
         menu_ienable(gl_menu, PLAY, 0);
         menu_ienable(gl_menu, PAUSE, 1);
         menu_ienable(gl_menu, FASTFORW, 1);
         menu_ienable(gl_menu, REWIND, 1);
         break;
      case STOP:
         action = STOP;
         menu_ienable(gl_menu, STOP, 0);
         menu_ienable(gl_menu, PLAY, 1);
         menu_ienable(gl_menu, PAUSE, 0);
         menu_ienable(gl_menu, FASTFORW, 0);
         menu_ienable(gl_menu, REWIND, 0);
         menu_text(gl_menu, PAUSE, P_PAUSE);
         break;
      case CONV2WAV:
         action = CONV2WAV;
         menu_ienable(gl_menu, STOP, 0);
         menu_ienable(gl_menu, PLAY, 1);
         menu_ienable(gl_menu, PAUSE, 0);
         menu_ienable(gl_menu, FASTFORW, 0);
         menu_ienable(gl_menu, REWIND, 0);
         menu_text(gl_menu, PAUSE, P_PAUSE);
         break;
      case ENCODE:
         action = ENCODE;
         menu_ienable(gl_menu, STOP, 0);
         menu_ienable(gl_menu, PLAY, 1);
         menu_ienable(gl_menu, PAUSE, 0);
         menu_ienable(gl_menu, FASTFORW, 0);
         menu_ienable(gl_menu, REWIND, 0);
         menu_text(gl_menu, PAUSE, P_PAUSE);
         break;
      case OPTNVISL:
         if (DrawGraphics == 1)
            DrawGraphics = 0;
         else
            DrawGraphics = 1;

         set_config_file("GEMP3.CFG");
         set_config_int("Visualisation", "Active", DrawGraphics);

         menu_icheck(gl_menu, OPTNVISL, DrawGraphics);
         break;
      case FSVISUAL:
         DoVis();
         break;
      case CHOSSKIN:
         ChooseSkin();
         break;
      case SKININFO:
         do_skininfo();
         break;
      }
   menu_tnormal(gl_menu,title,TRUE);
   return (done);
}

BOOLEAN hndl_msg()
{
   BOOLEAN  done;
   WORD     wdw_hndl;
   GRECT    work;

   done = FALSE;
   wdw_hndl = gl_rmsg[3];
   if ( gl_rmsg[0] == MN_SELECTED )
      done = hndl_menu(wdw_hndl, gl_rmsg[4]);/* Title, Item */

   if ( gl_rmsg[0] == WM_CLOSED ) done=FILEQUIT;
   if ( gl_rmsg[0] == WM_REDRAW ) Info();
   if ( gl_rmsg[0] == WM_MOVED )
   {
      wind_set(WIN, WF_CXYWH, gl_rmsg[4], gl_rmsg[5], gl_rmsg[6], gl_rmsg[7] );
      wind_get(WIN, WF_WXYWH, &work_area.g_x,&work_area.g_y, &work_area.g_w,&work_area.g_h);
      Info();
   }

   if (gl_rmsg[0] == WM_TOPPED)
      wind_set(WIN, WF_TOP, NULL, NULL, NULL, NULL);

   return(done);
}

BOOLEAN hndl_kbd(UWORD ks, UWORD kc)
{
   BOOLEAN done = FALSE;

   switch(kc)
   {
      case SPACE:
        if (mp3.Paused == 1)
           action = PAUSE;
        else if (mp3.Stoped == 0)
           action = PAUSE;
        else
        {
           action = PLAY;

           menu_ienable(gl_menu, STOP, 1);
           menu_ienable(gl_menu, PLAY, 0);
           menu_ienable(gl_menu, PAUSE, 1);
           menu_ienable(gl_menu, FASTFORW, 1);
           menu_ienable(gl_menu, REWIND, 1);
        }
        break;
      case ALT_O:
        action = FILEOPEN;
        break;
      case ALT_Q:
        done = TRUE;
        break;
      case ALT_V:
        DoVis();
        break;
   }

   return(done);
}

BOOLEAN do_about(WORD item)
{
   LONG tree, ted_addr;
   BOOLEAN done;
   char buf[50];
   WORD touchob;

   rsrc_gaddr(0, ABOUT, &tree);
   sprintf(buf, ReadLangStr(LANG_FREEMEM), _go32_dpmi_remaining_physical_memory()/1024768);

   ted_addr = LSGET(OB_SPEC(FREEMEM)); /* get obspec pointer */
   LSSET( ted_addr,  dj_string_addr(buf)); /* set obspec pointer */
   LWSET( TE_TXTLEN(ted_addr),9); /* 1 more than */

   sprintf(buf, ReadLangStr(LANG_BUILTON), __DATE__, __TIME__);

   ted_addr = LSGET(OB_SPEC(BUILTON)); /* get obspec pointer */
   LSSET( ted_addr,  dj_string_addr(buf)); /* set obspec pointer */
   LWSET( TE_TXTLEN(ted_addr),9); /* 1 more than */

   show_hide(FMD_START, tree);

   done = FALSE;

   while( !done )
   {
       touchob = form_do_bm(tree, 0);
       touchob &= 0x7fff;

       if (touchob == ABOUTOK)
       {
          done = TRUE;
          LWSET(OB_STATE(ABOUTOK), NORMAL);

          show_hide(FMD_FINISH, tree);
       }
   }

   // dialog does exist in resources, but not implemented
// dj_form_alert(1, "[1][GEMP3 1.1|Copyright (c) Owen Rudge 2000|Uses DJGPP, Allegro and LibAmp|Some code taken from SETEdit][ OK ]");
   return(TRUE);
}

LONG do_convert(char *fn)
{
   LONG tree;
   WORD touchob;

   rsrc_gaddr(0, CONVERTN, &tree);
   show_hide(FMD_START, tree);

   graf_mouse(2, NULL);
   mp3.ConvertSelectedFile(fn);

   return(tree);
}

LONG do_encode()
{
   char *encodedll;
   WORD touchob;
   hdlx_t hndl;

//   rsrc_gaddr(0, ENCODING, &encode_tree);
//   show_hide(FMD_START, encode_tree);

   graf_mouse(2, NULL);

//   argv[0] = "BLADEENC";
//   argv[1] = src;
//   argv[2] = dst;

//   sprintf(args, "%s %s", src, dst);

   set_config_file("GEMP3.CFG");
   encodedll = (char *) get_config_string("Encoder", "Filename", "ENCODE.DLL");

   hndl = DLXLoad(encodedll, "");

   if (hndl == NULL)
   {
      dj_form_alert(1, ReadLangStr(LANG_UNABLEDLL), encodedll);
      return(encode_tree);
   }

//   show_hide(FMD_START, encode_tree);
   evnt_timer(0,0);

//   dj_form_alert(1, "[1][Got to before strcpy()][ OK ]");

//   dj_form_alert(1, "[1][Got to before DLXGetEntry()][ OK ]");
//   ((FUNC)DLXGetEntry(hndl,"_encode_main"))(3, argv);
//   dj_form_alert(1, "[1][Survived encode_main][ OK ]");

   DLXUnload(hndl);
   show_hide(FMD_FINISH, encode_tree);
   return(encode_tree);
}

void Putpixel(WORD x,WORD y,WORD c1)
{
   WORD pxy[4];
   pxy[0] = work_area.g_x+x;
   pxy[1] = work_area.g_y+y;
   pxy[2] = work_area.g_x+x+1;
   pxy[3] = work_area.g_y+y;
   if (oc==-1 || oc!=c1) vsl_color(vdi_handle,c1);
   oc=c1;
   v_pline(vdi_handle, 2, pxy);
}

void LoadBmp(char fn[80], int pp, int po)
{
   FILE *BMP;
   unsigned char z[1024],a,b;
   char v;
   int br,foo, x, y; //pp,po;
   char data[128];
   WORD start;
   WORD pxy[4];
   WORD w,h,h2,ww;
   int oka,i,m,j,t,y1,x1;
   int Color[17];

   if (fn[0] == '<' &&
       fn[1] == 'N' &&
       fn[2] == 'O' &&
       fn[3] == 'N' &&
       fn[4] == 'E' &&
       fn[5] == '>')
   {
       return;
   }
   else if (fn[0] == 'E' &&
       fn[1] == 'R' &&
       fn[2] == 'R' &&
       fn[3] == 'O' &&
       fn[4] == 'R' &&
       fn[5] == '!')
   {
       return;
   }

   /* Color exchange table BMP <-> GEM  (16 Colors) */
   /*    BMP GEM */
   Color[ 0]=1; /* Schwarz */
   Color[ 1]=10;
   Color[ 2]=11;
   Color[ 3]=13;
   Color[ 4]=12;
   Color[ 5]=15;
   Color[ 6]=14;
   Color[ 7]=9; /* Hell Grau */
   Color[ 8]=8; /* Dunkel Grau */
   Color[ 9]=2; /* Rot */
   Color[10]=3; /* Hell Gruen */
   Color[11]=6; /* Gelb */
   Color[12]=4; /* BLAU */
   Color[13]=7; /* Magenta */
   Color[14]=5; /* Cyan */
   Color[15]=0; /* Weiss */
   oc=-1;
   x = y = 0;

   if (ignorebmpcalls == TRUE) goto leavethisplace;

   BMP=fopen(fn,"rb");
   if (BMP==NULL)
   {
      sprintf(data,ReadLangStr(LANG_UNABLEFIND),fn);
      foo=dj_form_alert(1,data);
      ignorebmpcalls = TRUE;
   }
   else
   {
      graf_mouse(M_OFF, 0);
      fseek(BMP,0x12,0);
      fread(z,1,2,BMP);
      w=z[0]+z[1]*256;  /* Wide of BMP */
      fseek(BMP,18,0);
      fread(z,1,2,BMP);
      h2=z[0]+z[1]*256;
      fseek(BMP,0x16,0);
      fread(z,1,2,BMP);
      h=z[0]+z[1]*256;  /* Height */
      fseek(BMP,0x0A,0);
      fread(z,1,2,BMP);
      start=z[0]+z[1]*256;
      v=1;z[0]=0;
      fseek(BMP,0x1C,0);
      fread(z,1,1,BMP); /* 1,4,8,24 Bit Image */
      v=z[0];
      ww=0;
//    pp=work_area.g_x;
//    po=work_area.g_x;
      while (v*h2>ww*8) ww++;

      if (v!=4)
      {
         graf_mouse(M_ON, 0);
         sprintf(data,ReadLangStr(LANG_BMPUNKNOWN),v);
         foo=dj_form_alert(1,data);
      }
      if (v == 4) /* 16 colors */
      {
         fseek(BMP,start,0);
         for (y1=h;y1>1;y1--)
         {
            br=0;
            fread(z,1,ww,BMP);
            for (x1=1;x1<w;x1++)
            {
               a=b=0;
               v=z[br];
               a=z[br] % 16;
               b=(z[br]-a) / 16;
               a=Color[a];
               b=Color[b];
               if (a != 0) Putpixel(x1+pp,y1+po,a);
               x1++;
               if (b != 0) Putpixel(x1+pp,y1+po,b);
               br++;
            }
            foo=4-(ww % 4) %4 ;
            if (foo>0 && foo<4) fread(z,1,foo,BMP);
         }
      }
      fclose(BMP);
      graf_mouse(M_ON, 0);
   }
// vst_color(vdi_handle, WHITE);
   vsl_color(vdi_handle, BLACK);

leavethisplace: ;
}

void filename_upper()
{
   int length, i;

   length = strlen(file_name);
   for (i=0; i<length; i++)
   {
      file_name[i] = toupper(file_name[i]);
   }
}

//////////////////////////

VOID show_hide(WORD fmd, LONG tree)
{
   WORD  xd, yd, wd, hd;
  
   form_center(tree, &xd, &yd, &wd, &hd);
   form_dial(fmd, 0, 0, 0, 0, xd, yd, wd, hd);
   if (fmd == FMD_START)
     objc_draw(tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);
}

void Info(void)
{
   char ch[255];
   char buf[30];
   cls();

   vst_color(vdi_handle, GetSkinColour(SKIN_TEXTCOL));
   vsf_interior(vdi_handle, 0);

   sprintf(ch,ReadLangStr(LANG_TITLE),mp3.Title);
   print(2,1,ch);
   sprintf(ch,ReadLangStr(LANG_AUTHOR),mp3.Author);
   print(2,2,ch);
   sprintf(ch,ReadLangStr(LANG_ALBUM),mp3.Album);
   print(2,3,ch);
   sprintf(ch,ReadLangStr(LANG_COMMENT),mp3.Comment);
   print(2,4,ch);

   if (mp3.Genre!=NULL)
      sprintf(ch,ReadLangStr(LANG_GENRE),mp3.Genre);
   else
     strcpy(ch,ReadLangStr(LANG_GENREUNSPEC));

   print(2,5,ch);
   sprintf(ch,ReadLangStr(LANG_BITRATE),mp3.SampleRate,mp3.BitRate,mp3.Mode);
   print(2,6,ch);

   strcpy(buf, ReadLangStr(LANG_OPEN));
   Button(OpenBtn,2,9,buf);

   ch[1]='\0';
   ch[0]=174;
   Button(RewindBtn,14,9,ch);
   ch[0]=175;
   Button(ForwardBtn,18,9,ch);
   ch[0]=14;
   Button(PlayBtn,22,9,ch);
   Button(PauseBtn,26,9,"::");
   ch[0]=5;
   Button(StopBtn,30,9,ch);

   // Print GEMP3 logo
   LoadBitmap(GetSkinData(SKIN_BITMAP), GetSkinColour(SKIN_BITMAPX), GetSkinColour(SKIN_BITMAPY)); //420, 125);
}

void PressButton(int nr)
{
   WORD pxy[15],l,wx,wy,x,y;
   l=strlen(btxt[nr]);
   l=l*8+4;
   x=xb[nr];
   y=yb[nr];
   x++;
   y++;
   wx=work_area.g_x;
   wy=work_area.g_y;
   graf_mouse(M_OFF,0);
   pxy[0]=wx+x;
   pxy[1]=wy+y;
   pxy[2]=wx+x+l;
   pxy[3]=wy+y+FH+2;
   vsf_interior(vdi_handle, 1);
   vsf_color(vdi_handle, GetSkinColour(SKIN_BTNPRESSFILL));
   v_bar(vdi_handle,pxy);
   vst_color(vdi_handle, GetSkinColour(SKIN_BTNPRESSTEXT));
   v_gtext(vdi_handle, wx+x+2, work_area.g_y+y+FH-1, btxt[nr]);
   vst_color(vdi_handle, GetSkinColour(SKIN_BTNTXTCOL)); /* WAS DBLUE */
   delay(20); /* To show that the button is pressed */

   vsf_color(vdi_handle, GetSkinColour(SKIN_BTNFILL)); /* WAS YELLOW */
   v_bar(vdi_handle,pxy);

   pxy[0]=wx+x;
   pxy[1]=wy+y;
   pxy[2]=wx+x+l;
   pxy[3]=wy+y;

   pxy[4]=wx+x+l;
   pxy[5]=wy+y;
   pxy[6]=wx+x+l;
   pxy[7]=wy+y+FH+2;

   pxy[8]=wx+x+l;
   pxy[9]=wy+y+FH+2;
   pxy[10]=wx+x;
   pxy[11]=wy+y+FH+2;

   pxy[12]=wx+x;
   pxy[13]=wy+y+FH+2;
   pxy[14]=wx+x;
   pxy[15]=wy+y;
   v_pline(vdi_handle, 8,pxy);
   y=y+FH;
   v_gtext(vdi_handle, wx+x+2, work_area.g_y+y-1, btxt[nr]);
   graf_mouse(M_ON,0);
}
void Button(int nr,int x,int y,char *b)
{
   WORD pxy[15],l,wx,wy;
   l=strlen(b);
   strcpy(btxt[nr],b);
   l=l*8+4;
   x=x*8;
   y=(y*FH)-FH+2;
   wx=work_area.g_x;
   wy=work_area.g_y;
   graf_mouse(M_OFF,0);
   /* The border is drawn 2 times to look like a real GEM button */
   xb[nr]=x;
   yb[nr]=y;
   yl[nr]=x+l;

   pxy[0]=wx+x;
   pxy[1]=wy+y;
   pxy[2]=wx+x+l;
   pxy[3]=wy+y+FH+2;
   vsf_interior(vdi_handle, 1);
   vsf_color(vdi_handle, GetSkinColour(SKIN_BTNFILL));
   v_bar(vdi_handle,pxy);

   pxy[0]=wx+x;
   pxy[1]=wy+y;
   pxy[2]=wx+x+l;
   pxy[3]=wy+y;

   pxy[4]=wx+x+l;
   pxy[5]=wy+y;
   pxy[6]=wx+x+l;
   pxy[7]=wy+y+FH+2;

   pxy[8]=wx+x+l;
   pxy[9]=wy+y+FH+2;
   pxy[10]=wx+x;
   pxy[11]=wy+y+FH+2;

   pxy[12]=wx+x;
   pxy[13]=wy+y+FH+2;
   pxy[14]=wx+x;
   pxy[15]=wy+y;
   
   vsl_color(vdi_handle, GetSkinColour(SKIN_BTNBORDER));
   v_pline(vdi_handle, 8,pxy);

   x--;
   y--;
   l=l+2;
   FH=FH+2;
   xb[nr]=x;
   yb[nr]=y;
   yl[nr]=x+l;

   pxy[0]=wx+x;
   pxy[1]=wy+y;
   pxy[2]=wx+x+l;
   pxy[3]=wy+y;

   pxy[4]=wx+x+l;
   pxy[5]=wy+y;
   pxy[6]=wx+x+l;
   pxy[7]=wy+y+FH+2;

   pxy[8]=wx+x+l;
   pxy[9]=wy+y+FH+2;
   pxy[10]=wx+x;
   pxy[11]=wy+y+FH+2;

   pxy[12]=wx+x;
   pxy[13]=wy+y+FH+2;
   pxy[14]=wx+x;
   pxy[15]=wy+y;
 
   v_pline(vdi_handle, 8,pxy);
   x++;
   y++;
   l=l-2;
   FH=FH-2;
   y=y+FH;

   vst_color(vdi_handle, GetSkinColour(SKIN_BTNTXTCOL)); /* WAS DBLUE */
   v_gtext(vdi_handle, wx+x+2, work_area.g_y+y-1, b);
   vst_color(vdi_handle, BLACK);
   graf_mouse(M_ON,0);
}

void TextColor(int color)
{
   vst_color(vdi_handle,color);
}

void cls(void)
{
   WORD pxy[4];
   graf_mouse(M_OFF,0);
   pxy[0]=work_area.g_x;
   pxy[1]=work_area.g_y;
   pxy[2]=pxy[0]+work_area.g_w-1;
   pxy[3]=pxy[1]+work_area.g_h-1;
   vsf_interior(vdi_handle, 1); // 1
   vsf_color(vdi_handle, GetSkinColour(SKIN_BACKGROUND));
   v_bar(vdi_handle,pxy);

   if (GetSkinColour(SKIN_BGSTYLE) > 1)
   {
      vsf_interior(vdi_handle, GetSkinColour(SKIN_BGSTYLE)); // 1
      vsf_style(vdi_handle, GetSkinColour(SKIN_BGINDEX));
      vsf_color(vdi_handle, GetSkinColour(SKIN_BGCOLOUR2));
      v_bar(vdi_handle,pxy);
   }

   vsf_color(vdi_handle, WHITE);
   vst_color(vdi_handle,BLACK);
   vsf_interior(vdi_handle, 1);

   graf_mouse(M_ON,0);
}

void cprint(int x,int y,char *txt)
{
   /* In the normal Fonts (CGA,Hercules,EGA,VGA,SVGA the font is always 8 pixel wide)*/
   WORD pxy[4];
   graf_mouse(M_OFF,0);
   pxy[0]=work_area.g_x+(x*8);
   pxy[1]=work_area.g_y+(y*FH)-FH;
   pxy[2]=pxy[0]+(strlen(txt)*8);
   pxy[3]=pxy[1]+FH;
   vsf_interior(vdi_handle, 1);
   vsf_color(vdi_handle, GetSkinColour(SKIN_BACKGROUND));
   v_bar(vdi_handle,pxy);
   v_gtext(vdi_handle, work_area.g_x+(x*8), work_area.g_y+(y*FH), txt);
   graf_mouse(M_ON,0);
}

void print(int x,int y,char *txt)
{
   graf_mouse(M_OFF,0);
   v_gtext(vdi_handle, work_area.g_x+(x*8), work_area.g_y+(y*FH), txt);
   graf_mouse(M_ON,0);
}

void Title(char *stx)
{
#ifdef __BORLANDC__
   wind_set(WIN, WF_NAME, FPOFF(stx), FPSEG(stx), 0, 0);
#endif
#ifdef __DJGPP__
   dj_wind_setl(WIN, WF_NAME, dj_string_addr(stx), 0);
#endif
}

void Init(int br,int zh,int x,int y)
{
   WORD gl_wchar,gl_hchar,gl_wbox,gl_hbox;
   char *titel="GEMP3";
   int i;
   WORD cols[3];

   /* x....X position of window
      y....Y position of window
      br...Columns to be displayed
      zh...Lines to be displayed
    */

   for (i=0;i<9;i++) xb[i]=yb[i]=yl[i]=0;
   graf_mouse(M_OFF,0);
   vdi_handle = graf_handle(&gl_wchar, &gl_hchar,&gl_wbox, &gl_hbox);
   FH=gl_hchar;
   /*
     FH= 8 ...CGA,Hercules
     FH= 14...EGA
     FH= 16...VGA,SVGA
   */
   WIN=wind_create(MOVER+NAME+CLOSER,0,0,120, 100);
#ifdef __BORLANDC__
   wind_set(WIN, WF_NAME, FPOFF(titel), FPSEG(titel), 0, 0);
#endif
#ifdef __DJGPP__
   dj_wind_setl(WIN, WF_NAME, dj_string_addr(titel), 0);
#endif
   wind_open(WIN, x,y, br*8, zh*FH);
   wind_get(WIN, WF_WXYWH, &work_area.g_x,&work_area.g_y, &work_area.g_w,&work_area.g_h);
   graf_mouse(M_ON,0);

#ifdef CHANGE_PALETTE
   vq_color(vdi_handle, 13, 0, normal_cols13);
   vq_color(vdi_handle, 15, 0, normal_cols);

   cols[0] = 255 * 4; /* GEMVDI wants it from 0-1000 instead of 0-255 */
   cols[1] = 255 * 4;
   cols[2] = 150 * 4;
   vs_color(vdi_handle, 15, cols);

   cols[0] = 5   * 4; /* Yes, I can multiply 5 by 4 :-) */
   cols[1] = 22  * 4;
   cols[2] = 233 * 4;
   vs_color(vdi_handle, 13, cols);
#endif
}
void close(void)
{
   wind_close(WIN);
   wind_delete(WIN);
}
void Box(int x,int y,int w,int h)
{
   WORD pxy[15],l,wx,wy;
   wx=work_area.g_x;
   wy=work_area.g_y;
   graf_mouse(M_OFF,0);
   pxy[0]=wx+x;
   pxy[1]=wy+y;
   pxy[2]=wx+x+w;
   pxy[3]=wy+y;

   pxy[4]=wx+x+w;
   pxy[5]=wy+y;
   pxy[6]=wx+x+w;
   pxy[7]=wy+y+h;

   pxy[8]=wx+x+w;
   pxy[9]=wy+y+h;
   pxy[10]=wx+x;
   pxy[11]=wy+y+h;

   pxy[12]=wx+x;
   pxy[13]=wy+y+h;
   pxy[14]=wx+x;
   pxy[15]=wy+y;
   v_pline(vdi_handle, 8,pxy);
   graf_mouse(M_ON,0);
}
void sel_file_xtnd(void)
{
#ifdef HEINZ_EXTENDED_BOX
   // File select box which will look like the box from GEM/5
   GRECT wks;
   WORD SEL;
   int i;
   char ch[128];
   wind_get(WIN, WF_WXYWH, &wks.g_x,&wks.g_y, &wks.g_w,&wks.g_h);
   SEL=WIN;
   Init(70,15,20,20);
   Title("Select a file");
   cls();
   ch[0]=15;
   ch[1]='\0';
   Button(1,2,1,ch);
   ch[0]=12;
   Button(2,22,4,ch);
   ch[0]=13;
   Button(3,22,13,ch);
   Button(4,2,4,"?:");
   print(5,3,"Available Files");
   print(25,3,"Selection");
   Button(4,50,4,"   OK   ");
   Button(5,50,6," Cancel ");
   Box(68,49,13*8,10*FH+4);
   Box(38,30,152,11*FH+7);
//   print(9,4,"DONTCRY .MP3");
//   print(9,5,"RUNAWAY .MP3");
   for (i=4;i<14;i++) print(9,i,"________.___");
   print(27,4,"________.___");
   print(4,1,"_____________________________________________________________");
   scanf("%s",&ch);
   close();
   WIN=SEL;
   /* Don't change this lines they are needed to correct redraw the window !!! */
   wind_set(WIN, WF_CXYWH, wks.g_x,wks.g_y,wks.g_w,wks.g_h );
   wind_get(WIN, WF_WXYWH, &work_area.g_x,&work_area.g_y, &work_area.g_w,&work_area.g_h);
   wind_set(WIN, WF_TOP, 0,0,0,0);
   Info();
#endif
}

/* Read out of language data file - uses Allegro config (INI) routines */
DLX_FN char * ReadLangStr(int id)
{
   char *buf;
   char num[5];

#ifdef USE_THE_CACHE
   if (LangStrCache[id] != NULL)
      return(LangStrCache[id]);
   else
   {
#endif
      sprintf(num, "@%d", id);
      set_config_file("LANG.DAT");
      buf = (char *) get_config_string(GetLangSection(current_lang), num, "ERROR!");
#ifdef USE_THE_CACHE
      LangStrCache[id] = buf;
      return(buf);
   }
#else
      return(buf);
#endif
} DLX_EF;

char * GetLangSection(int language)
{
   char num[3];
   sprintf(num, "%d", language);

   set_config_file("LANG.DAT");
   return((char *)get_config_string("Languages", num, "English"));
}

int GetSkinColour(int id)
{
   return(SkinColours[id]);
}

int GetSkinColourFile(char *id)
{
   set_config_file(skinfn);
   return(get_config_int("Colours", id, 1));
}

char * GetSkinData(char *id)
{
   set_config_file(skinfn);
   return((char *)get_config_string("GEMP3_Skin", id, "ERROR!"));
}

/* DOS routine that selects a language */
void DoSelLang()
{
   allegro_init();

   set_config_file("GEMP3.CFG");
   int curlang = get_config_int("Language", "Current", 1);

   set_config_file("LANG.DAT");
   int numlangs = get_config_int("Languages", "Count", 1);
   char *langs[numlangs], num[2];
   int i, gc;

   for (i = 0; i < numlangs; i++)
   {
      sprintf(num, "%d", i+1);
      langs[i] = (char *) get_config_string("Languages", num, "Unknown");
   }

   clrscr();
   textcolor(14);
   cprintf("Welcome to the GEMP3 Language Selection utility\r\n");
//   cprintf(ReadLangStr(LANG_WELCOME_LANG));

   printf("\n");
   printf("Current Language: %s\n", langs[curlang-1]);
//   printf(ReadLangStr(LANG_CURRENT_LANG));
   printf("\n");
   printf("Languages:\n");
//   printf(ReadLangStr(LANG_LANGUAGES));
   printf("\n");
   
   for (i = 0; i < numlangs; i++)
      printf("  %d  -  %s\n", i + 1, langs[i]);

   printf("\n");
   printf("New Language: ");
//   printf("%s ", ReadLangStr(LANG_NEWLANG));
   
getitagain: ;

   gc = getch();
   if (gc < '1' || gc > ('0' + numlangs))
      goto getitagain;
   
   gc = gc - '1';
   printf("%d\n", gc+1);
   printf("\n");
   printf("The new language has been set to %s.\n", langs[gc]);
//   printf(ReadLangStr(LANG_LANGSET), langs[gc]);

   set_config_file("GEMP3.CFG");
   set_config_int("Language", "Current", gc+1);
}

int DoAESCheck()
{
   LPLONG pGEM = 4 * 0xEF;
   LPBYTE pSIG = LSGET(pGEM) + 2;
   int n;

   for (n = 0; n < 6; n++)
   {
      if (LBGET(pSIG + n) != fail[n])
      {
         cputs(fail);
         cputs(exte);
         return 1;
      }
   }

   return 0;
}

#ifdef M_GRAPHICS

void DrawMusicGraphics()
{
   static unsigned short*last_left;
   unsigned short*this_left=amp_play_left,*this_right=amp_play_right;
   int ret=D_O_K,cnt;
   int d_left,d_right;
   int XSH=2,XSS=XSH; /* 1024 samples => 256 pixels */
 
   if ((this_left!=last_left)&&(this_left))
   {
      /* with the new Allegro 3.0+WIP stereo system, both channels */
      /* are interleaved in the same stream/buffer, so we just offset */
      /* the pointer to the right channel by one sample to get at it... */
      if (amp_stereo)
      {
         /* a bit ugly, but as long as it works... */
         this_right++; XSS++;
      }

#ifdef CLEAR_PIXELS
      for (cnt = 0; cnt < NumPixels; cnt++)
         putgrafpixel(PixelClear[cnt].x, PixelClear[cnt].y, GetSkinColour(SKIN_BACKGROUND));

      NumPixels=0; /* ideally this bit should check for the previous colour*/
#endif

#ifdef BARS
      for (cnt=0; cnt<amp_play_len>>XSH; cnt++)
      {
         d_left=this_left[cnt<<XSS]/512;
         d_right=this_right[cnt<<XSS]/512;

         my_vline(vdi_handle,cnt,64,d_left,BLACK);
         my_vline(vdi_handle,cnt,64,d_right,BLUE);
      }

      my_hline(vdi_handle,0,64,cnt,2);
#else /* DOTS */

      for (cnt=0; cnt<amp_play_len>>XSH; cnt++)
      {
          d_left=this_left[cnt<<XSS]/512;
          d_right=this_right[cnt<<XSS]/512;
          if (d_left==d_right)
          {
             putgrafpixel(cnt,d_left,GetSkinColour(SKIN_VIS_EQUAL)); //MAGENTA);
#ifdef CLEAR_PIXELS
             NumPixels++;
             PixelClear[NumPixels].x = cnt;
             PixelClear[NumPixels].y = d_left;
#endif
          }
          else
          {
             putgrafpixel(cnt,d_left,GetSkinColour(SKIN_VIS_LEFT)); //BLACK);
             putgrafpixel(cnt,d_right,GetSkinColour(SKIN_VIS_RIGHT));//BLUE);

#ifdef CLEAR_PIXELS
             NumPixels++;
             PixelClear[NumPixels].x = cnt;
             PixelClear[NumPixels].y = d_left;

             NumPixels++;
             PixelClear[NumPixels].x = cnt;
             PixelClear[NumPixels].y = d_right;
#endif
          }
          putgrafpixel(cnt,64,GetSkinColour(SKIN_VIS_LINE)); // 7);

/*#ifdef CLEAR_PIXELS
      NumPixels++;
      PixelClear[NumPixels].x = cnt;
      PixelClear[NumPixels].y = 64;
#endif*/
      }
#endif
   }

   vsl_color(vdi_handle, BLACK);
   last_left=this_left;
}

void my_vline(WORD hndl, int x1, int y1, int y2, int col)
{
#ifdef SDFGSAERTGS /* ie, this is never included          */
   WORD points[3]; /* I couldn't seem to get this working */
   int oldcol;     /* There's probably something obvious wrong :) */
   int wx, wy;

   wx=work_area.g_x;
   wy=work_area.g_y;

   oldcol = vsl_color(hndl, col);

   points[0] = wx+x1;
   points[1] = wy+y1;
   points[2] = wx+x1;
   points[3] = wy+y2;

   v_pline(hndl, 4, points);
   vsl_color(hndl, oldcol);
#endif
   WORD pxy[4];
   int i;

   for (i = y1; i < y2; i++)
   {
      pxy[0] = work_area.g_x+x1;
      pxy[1] = work_area.g_y+y1;
      pxy[2] = work_area.g_x+x1+1;
      pxy[3] = work_area.g_y+y2;

      vsl_color(vdi_handle,col);
      v_pline(vdi_handle, 2, pxy);
   }
}

void my_hline(WORD hndl, int x1, int y1, int x2, int col)
{
#ifdef SDFSDF /* not included either */
   WORD points[3];
   int oldcol;
   int wx, wy;

   wx=work_area.g_x;
   wy=work_area.g_y;

   oldcol = vsl_color(hndl, col);

   points[0] = wx+x1;
   points[1] = wy+y1;
   points[2] = wx+x2;
   points[3] = wy+y1;

   v_pline(hndl, 4, points);
   vsl_color(hndl, oldcol);
#endif

   WORD pxy[4];
   int i;

   for (i = x1; i < x2; i++)
   {
      pxy[0] = work_area.g_x+i;
      pxy[1] = work_area.g_y+y1;
      pxy[2] = work_area.g_x+i+1;
      pxy[3] = work_area.g_y+y1;

      vsl_color(vdi_handle,col);
      v_pline(vdi_handle, 2, pxy);
   }
}

void putgrafpixel(WORD x,WORD y,WORD c1)
{
   WORD pxy[4];
   pxy[0] = (work_area.g_x+work_area.g_w - 300) + x;
   pxy[1] = work_area.g_y+15+y;
   pxy[2] = (work_area.g_x+work_area.g_w - 300)+x+1;
   pxy[3] = work_area.g_y+15+y;
   if (oc==-1 || oc!=c1) vsl_color(vdi_handle,c1);
   oc=c1;
   v_pline(vdi_handle, 2, pxy);
}
#endif

#define MY_OB_SPEC(x,thetree) (thetree + (x) * sizeof(OBJECT) + 12)

DLX_FN void GEMP3_SetLabel(int lbl, const char *txt)
{
/*   LONG ted_addr; ************ THIS DOESN'T WORK ***************
   int id;

   switch(lbl)
   {
      case 1:
         id = ENCODE1;
         break;
      case 2:
         id = ENCODE2;
         break;
      case 3:
         id = ENCODE3;
         break;
      case 4:
         id = ENCODE4;
         break;
   }

   ted_addr = LSGET(MY_OB_SPEC(id,encode_tree)); // get obspec pointer
   LSSET( ted_addr,  dj_string_addr((char *) txt) ) ; // set obspec pointer
   LWSET( TE_TXTLEN(ted_addr),9); // 1 more than

   show_hide(encode_tree, FMD_START);
   evnt_timer(0,0);

//   objc_draw(encode_tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);*/
} DLX_EF;

void LoadSkin()
{
//   char buffer[100];
   char buf[100];
   char *psrc;

   if (ColoursChanged == TRUE)
      xgrf_colour(CC_NAME, SkinColours[10], SkinColours[11], SkinColours[12], SkinColours[13]);

   SkinColours[0]  = GetSkinColourFile(TXT_SKIN_TEXTCOL);
   SkinColours[1]  = GetSkinColourFile(TXT_SKIN_BGSTYLE);
   SkinColours[2]  = GetSkinColourFile(TXT_SKIN_BTNPRESSFILL);
   SkinColours[3]  = GetSkinColourFile(TXT_SKIN_BTNPRESSTEXT);
   SkinColours[4]  = GetSkinColourFile(TXT_SKIN_BTNTXTCOL);
   SkinColours[5]  = GetSkinColourFile(TXT_SKIN_BTNFILL);
   SkinColours[6]  = GetSkinColourFile(TXT_SKIN_BTNBORDER);
   SkinColours[7]  = GetSkinColourFile(TXT_SKIN_BACKGROUND);
   SkinColours[8]  = GetSkinColourFile(TXT_SKIN_TITLEBAR);
   SkinColours[9]  = GetSkinColourFile(TXT_SKIN_TITLEBARTEXT);
   SkinColours[14] = GetSkinColourFile(TXT_SKIN_BGINDEX);
   SkinColours[15] = GetSkinColourFile(TXT_SKIN_BGCOLOUR2);
   SkinColours[16] = GetSkinColourFile(TXT_SKIN_VIS_EQUAL);
   SkinColours[17] = GetSkinColourFile(TXT_SKIN_VIS_LEFT);
   SkinColours[18] = GetSkinColourFile(TXT_SKIN_VIS_RIGHT);
   SkinColours[19] = GetSkinColourFile(TXT_SKIN_VIS_LINE);
   SkinColours[20] = GetSkinColourFile(TXT_SKIN_BITMAPX);
   SkinColours[21] = GetSkinColourFile(TXT_SKIN_BITMAPY);

//   sprintf(buffer, "By %s", GetSkinData(SKIN_AUTHOR)); // for some reason ReadLangStr(LANG_BYSKIN
//   menu_text(gl_menu, SKINAUTR, dj_string_addr(buffer)); // doesn't work and causes GEM to freeze
//   menu_text(gl_menu, SKINNAME, dj_string_addr(GetSkinData(SKIN_TITLE)));

   // If SkinColours[8 and 9] are not -1, change title bar colour under FreeGEM
   if (SkinColours[8] != -1 && SkinColours[9] != -1)
   {
      if ((gl_xbuf.arch != 0) & (gl_xbuf.abilities & 1))
      {       
         // While I don't want to rely on the GEM.CFG being the same, this seems the only way
         // to do it, as there is no API to get the current colour scheme

         prop_get("GEM.AES", "Colour.8", buf, 100, 0);

         psrc = buf;

         hex(&psrc, &SkinColours[10], 4);
         hex(&psrc, &SkinColours[11], 4);
         hex(&psrc, &SkinColours[12], 4);
         hex(&psrc, &SkinColours[13], 4);

         xgrf_colour(CC_NAME, SkinColours[8], SkinColours[9], 0, 0);
         ColoursChanged = TRUE;
      }
   }

   ignorebmpcalls = FALSE;
}

void ChooseSkin()
{
   char fn[200];
   char buf[13];
   FILE *fp;
   WORD gf;

   gf = get_file(fn, ReadLangStr(LANG_LOADSKIN), "*.SKN");

   if (gf != 25)
   {
      fp = fopen(fn, "rt");

      if (fp == NULL)
      {
         dj_form_alert(1, ReadLangStr(LANG_UNABLEOPENSKIN), fn);
         return;
      }

      //fread(buf, 12, 1, fp);
	fgets(buf, 13, fp);
      fclose(fp);

      if (strstr(buf, "[GEMP3_Skin]") == NULL)
      {
         dj_form_alert(1, ReadLangStr(LANG_NOTGEMP3SKIN), fn);
         return;
      }

      strcpy(skinfn, fn);

      set_config_file("GEMP3.CFG");
      set_config_string("Skin", "Current", skinfn);

      LoadSkin();
      Info();
   }
}

WORD hexdgt(char **s)
{
   char c;
	
   while (**s == ' ') (*s)++;

   c = toupper(**s);
	
   if      (c >= 'A' && c <= 'F') { (*s)++; return c - 'A' + 10; }
   else if (c >= '0' && c <= '9') { (*s)++; return c - '0';      }
   else return -1;
}

VOID hex(char **s, int *val, WORD ndig)
{
   WORD v, w;
   WORD n;

   for (v = n = 0; n < ndig; n++)
   {
      v = v << 4;
      w = hexdgt(s); 

      if (w == -1) return; /* Invalid hex digit */

      v |= w;
   }
   *val = v;
}

BOOLEAN do_skininfo()
{
   BOOLEAN done;
   LONG tree;
   WORD touchob;
   LONG ted_addr;

   rsrc_gaddr(0, SKININFD, &tree);

   ted_addr = LSGET(OB_SPEC(SKINNAME)); /* get obspec pointer */
   LSSET( ted_addr,  dj_string_addr(GetSkinData(SKIN_TITLE)) ) ; /* set obspec pointer */
   LWSET( TE_TXTLEN(ted_addr),9); /* 1 more than */

   ted_addr = LSGET(OB_SPEC(SKINAUTR)); /* get obspec pointer */
   LSSET( ted_addr,  dj_string_addr(GetSkinData(SKIN_AUTHOR)) ) ; /* set obspec pointer */
   LWSET( TE_TXTLEN(ted_addr),9); /* 1 more than */

   ted_addr = LSGET(OB_SPEC(SKINDESC)); /* get obspec pointer */
   LSSET( ted_addr,  dj_string_addr(GetSkinData(SKIN_DESCRIPTION)) ) ; /* set obspec pointer */
   LWSET( TE_TXTLEN(ted_addr),9); /* 1 more than */

   ted_addr = LSGET(OB_SPEC(SKINEMAI)); /* get obspec pointer */
   LSSET( ted_addr,  dj_string_addr(GetSkinData(SKIN_EMAIL)) ) ; /* set obspec pointer */
   LWSET( TE_TXTLEN(ted_addr),9); /* 1 more than */

   show_hide(FMD_START, tree);

   done = FALSE;

   while( !done )
   {
       touchob = form_do_bm(tree, 0);
       touchob &= 0x7fff;

	 mp3.Poll();

       if (touchob == SKINOK)
       {
          done = TRUE;
          LWSET(OB_STATE(SKINOK), NORMAL);

          show_hide(FMD_FINISH, tree);
       }
   }

   return(TRUE);
}

DLX_FN void GEM_ShowProgressDialog()
{
   rsrc_gaddr(0, ENCODING, &encode_tree);
   show_hide(FMD_START, encode_tree);
   evnt_timer(0, 0);
} DLX_EF;

#ifdef LOAD_GEMP3_BMP  // custom bitmap format - doesn't currently work
void Load_GEMP3_BMP(char *fn, int x, int y)
{
   unsigned char a, b;
   int x1, y1, hdr;
   PACKFILE *BMP;
   WORD w, h;
   char *data;
   char buf[5];

   if (fn[0] == '<' &&
       fn[1] == 'N' &&
       fn[2] == 'O' &&
       fn[3] == 'N' &&
       fn[4] == 'E' &&
       fn[5] == '>')
   {
       return;
   }

   if (ignorebmpcalls == TRUE) goto leavethisplace;

   BMP = pack_fopen(fn, F_READ_PACKED);

   if (BMP == NULL)
   {
      sprintf(data,ReadLangStr(LANG_UNABLEFIND),fn);
      dj_form_alert(1,data);
      ignorebmpcalls = TRUE;
   }
   else
   {
      pack_fread(buf, 2, BMP);
      hdr=buf[0]+buf[1]*256;

      if (hdr != 385)
      {
          ignorebmpcalls = TRUE;
          pack_fclose(BMP);
          dj_form_alert(1, "[1][Header incorrect][ No! ]");

          sprintf(data, "[1][Hdr: %d|%d - %d|W: %d  H: %d][ OK ]", hdr, buf[0], buf[1], w, h);
          dj_form_alert(1, data);

          return;
      }

      graf_mouse(M_OFF, 0);

      pack_fread(buf, 2, BMP);
      w=buf[0]+buf[1]*256;

      pack_fread(buf, 2, BMP);
      h=buf[0]+buf[1]*256;

      sprintf(data, "[1][Hdr: %d|W: %d  H: %d][ OK ]", hdr, w, h);
      dj_form_alert(1, data);

      for (y1=h;y1>1;y1--)
      {
         for (x1=1;x1<w;x1++)
         {
            a = b = 0;

            pack_fread(buf, 1, BMP);
            a=buf[0];

            pack_fread(buf, 1, BMP);
            b=buf[0];

//            pack_fread((unsigned char *) a, sizeof(a), BMP);
//            pack_fread((unsigned char *) b, sizeof(b), BMP);

            if (a != 0) Putpixel(x1+x,y1+y,a);
            x1++;
            if (b != 0) Putpixel(x1+x,y1+y,b);
         }
      }
      pack_fclose(BMP);
      graf_mouse(M_ON, 0);
   }
   vsl_color(vdi_handle, BLACK);

leavethisplace: ;
}

void LoadBitmap(char *fn, int x, int y)
{
   char file[200];
   char ext;
   int sl;

   strcpy(file, fn);
   strupr(file);

   sl = strlen(file);
   if (file[sl-4] != '.' ||
       file[sl-3] != 'G' ||
       file[sl-2] != '3' ||
       file[sl-1] != 'B')
   {
       LoadBmp(fn, x, y);
   }
   else
       Load_GEMP3_BMP(fn, x, y);
}
#endif

#ifdef SKIN_GENERATOR
void GenerateSkin()
{
   PACKFILE *src, *dest;
   char buf[1];

   src = pack_fopen("#STANDARD", "rb");

   if (src == NULL)
   {
      dj_form_alert(1, ReadLangStr(LANG_CANTOPENINTSKIN));
      return;
   }

   dest = pack_fopen("_TMPSKIN.SKN", "wb");

   if (dest == NULL)
   {
      pack_fclose(src);
      dj_form_alert(1, ReadLangStr(LANG_CANTWRITESKIN));
      return;
   }

   do {
      pack_fread(buf, 1, src);
      pack_fwrite(buf, 1, dest);
   } while (!pack_feof(src));

   pack_fclose(src);
   pack_fclose(dest);
}
#endif

extern "C" void set_gem_screen_mode()
{
   SetScreenMode_GEM();
}

#ifndef ALLEGRO_VERSION_STR
   #define ALLEGRO_VERSION_STR  "Unknown (possibly Allegro 3.12 or earlier)"
#endif

void DoVerInfo()
{
   char djver[25];

   sprintf(djver, "DJGPP version:   %d.%d\n", __DJGPP__, __DJGPP_MINOR__);

   printf("GEMP3 " GEMP3_VERSION "\n");
   printf("Copyright (c) Owen Rudge 2000-2001\n");
   printf("\n");
   printf("Thanks to Heinz Rath for various contributions. Please visit\n");
   printf("his web site at www.geocities.com/heinz_rath/.\n");
   printf("\n");
   printf("Build Date:      " __DATE__ "\n");
   printf("Build Time:      " __TIME__ "\n");
   printf("\n");
   printf("Allegro version: " ALLEGRO_VERSION_STR "\n");
   printf(djver);
}