/*******************************************************************************/
/* GEMP3 2.2: An MP3 player for GEM                                            */
/* Copyright (c) Owen Rudge 2000-2001. Uses LibAmp, Allegro and DJGPP          */
/*                                                                             */
/* The code in MP3PLAY.CC is from SETEdit. Window/button code by Heinz Rath    */
/* Please see http://www.owenrudge.co.uk/GEM/ for more information.            */
/*                                                                             */
/* This application is licensed under the terms of the General Public License, */
/* version 2.0 or higher. See the included LICENSE.TXT for details.            */
/*******************************************************************************/
/* Full screen visualisation for GEMP3                                         */
/*******************************************************************************/

#include <allegro.h>
#include <limits.h>
#include <stdio.h>

extern "C" {
   #include "djgppgem.h"
   #include "libamp.h"

   extern char *ReadLangStr(int);
}

#include "mp3play.h"

#include "gemp3.h"
#include "lang.h"

#include "fsvis.h"
#include "skin.h"

extern char *GetSkinData(char *);

void DoVis();
void DrawVis();

#undef FHT

#define BARS
#undef DOTS

#define FHT_SCALE 5

DATAFILE *dat;
FONT *old_font;

BITMAP *bgimg;

void DoVis()
{
//   PALETTE palette;
   int x, y, w, h;
   int i, j;
   BITMAP *buf;

   SetScreenMode_Text();

   install_keyboard(); 
      if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0) {
       SetScreenMode_GEM();
	 dj_form_alert(1, ReadLangStr(LANG_ERRGFX), allegro_error);
	 return;
      }

   dat = load_datafile(GetSkinData(SKIN_FSVIS)); //"fsvis.dat");
   old_font = font;
   font = (FONT *) dat[FSVIS].dat;

   bgimg = create_bitmap(SCREEN_W, SCREEN_H);

   if (!bgimg) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      SetScreenMode_GEM();
      dj_form_alert(1, ReadLangStr(LANG_ERRGFX), allegro_error);
      return;
   }

   buf = create_bitmap(SCREEN_W, 100);

   clear(buf);
   clear(bgimg);
   
   w = ((BITMAP *) dat[BGIMAGE].dat)->w;
   h = ((BITMAP *) dat[BGIMAGE].dat)->h;

   for (i = 0; i < ((SCREEN_W/w)+1); i++)
   {
      for (j = 0; j < ((SCREEN_H/h)+1); j++)
         blit((BITMAP *) dat[BGIMAGE].dat, bgimg, 0, 0, i*w, j*h, w, h);
   }

   set_palette((RGB *) dat[BGPAL].dat);

//   blit((BITMAP *) dat[BGIMAGE].dat, screen, 0, 0, 0, 0, 640, 480);
   blit(bgimg, screen, 0, 0, 0, 0, 640, 480);

   while (!keypressed()) {
      DrawVis();

//      text_mode(makecol(0,0,0));
      text_mode(-1);
      blit(bgimg, buf, 0, 0, 0, 0, SCREEN_W, 100);

      // Draw shadow
      textout(buf, font, mp3.Title, 7, 7, makecol(0,0,0));
      textout(buf, font, mp3.Author, 7, 7+text_height(font), makecol(0,0,0));

      textout(buf, font, mp3.Title, 5, 5, makecol(255,255,0));
      textout(buf, font, mp3.Author, 5, 5+text_height(font), makecol(0,255,255));

      textprintf_right(buf, old_font, SCREEN_W-3, 7, makecol(0,0,0), "%d:%02d/%d:%02d", mp3.GetTime()/60, mp3.GetTime()%60, mp3.TotalLen/60, mp3.TotalLen%60);
      textprintf_right(buf, old_font, SCREEN_W-5, 5, makecol(255,255,255), "%d:%02d/%d:%02d", mp3.GetTime()/60, mp3.GetTime()%60, mp3.TotalLen/60, mp3.TotalLen%60);

      blit(buf, screen, 0, 0, 0, 0, SCREEN_W, 100);

//      acquire_screen();
//      blit(buf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
//      release_screen();

      mp3.Poll();
   }

   font = old_font;
   unload_datafile(dat);

   destroy_bitmap(buf);
   destroy_bitmap(bgimg);

   remove_keyboard();
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   SetScreenMode_GEM();
}

void DrawVis()
{
 static BITMAP*scope_view=NULL;
 static unsigned short*last_left;
 unsigned short*this_left=amp_play_left,*this_right=amp_play_right;
 int ret=D_O_K,cnt;
 int d_left,d_right;
 int XSH=2,XSS=XSH; /* 1024 samples => 256 pixels */

 if (!scope_view)
    scope_view=create_bitmap(amp_play_len>>XSH,128);   

  if ((this_left!=last_left)&&(this_left)) {
#ifdef FHT
   perform_fht_s16(this_left,fht_data);
#endif
#ifdef AMP_MIXSTEREO
   /* with the new Allegro 3.0+WIP stereo system, both channels */
   /* are interleaved in the same stream/buffer, so we just offset */
   /* the pointer to the right channel by one sample to get at it... */
   if (amp_stereo) {
    /* a bit ugly, but as long as it works... */
    this_right++; XSS++;
   }
#endif
   clear(scope_view);
#ifdef BARS
/////   xor_mode(TRUE);
   for (cnt=0; cnt<amp_play_len>>XSH; cnt++) {
#ifdef FHT
    d_left=log2(power_index(fht_data,amp_play_len,cnt*XF))*FHT_SCALE;
    vline(scope_view,cnt,127,127-d_left,makecol(0,0,170));
#else
    d_left=this_left[cnt<<XSS]/512;
    d_right=this_right[cnt<<XSS]/512;
    vline(scope_view,cnt,64,d_left,makecol(0,0,170));
    vline(scope_view,cnt,64,d_right,makecol(170,0,0));
#endif
   }
   hline(scope_view,0,64,cnt,makecol(0,170,0));
/////   xor_mode(FALSE);
#else
#ifdef DOTS
   for (cnt=0; cnt<amp_play_len>>XSH; cnt++) {
#ifdef FHT
    d_left=log2(power_index(fht_data,amp_play_len,cnt*XF))*FHT_SCALE;
    putpixel(scope_view,cnt,127-d_left,makecol(0,0,170));
#else
    d_left=this_left[cnt<<XSS]/512;
    d_right=this_right[cnt<<XSS]/512;
    if (d_left==d_right)
     putpixel(scope_view,cnt,d_left,makecol(170,0,170));
    else {
     putpixel(scope_view,cnt,d_left,makecol(0,0,170));
     putpixel(scope_view,cnt,d_right,makecol(170,0,0));
    }
    putpixel(scope_view,cnt,64,makecol(170,170,170));
#endif
   }
#endif
#endif
//   blit(scope_view,buf,0,0,(SCREEN_W-(amp_play_len>>XSH))/2,(SCREEN_H-128)/2,amp_play_len>>XSH,128);
   blit(bgimg, screen, (SCREEN_W-((amp_play_len>>XSH)*2))/2, (SCREEN_H-256)/2, (SCREEN_W-((amp_play_len>>XSH)*2))/2, (SCREEN_H-256)/2, (amp_play_len>>XSH)*2, 256);
   masked_stretch_blit(scope_view, screen, 0, 0, amp_play_len>>XSH, 128, (SCREEN_W-((amp_play_len>>XSH)*2))/2, (SCREEN_H-256)/2, (amp_play_len>>XSH)*2, 256);
   last_left=this_left;
  }

  destroy_bitmap(scope_view);
  scope_view=NULL;
}