/* Sound volume controller for Bad Seal 0.5 or SEAL 1.0c or better */

#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "button.h"
#include "dialogs.h"
#include "badctrls.h"

#define MSG_WAVE 100001
#define MSG_MIDI 100002

static DATAFILE *dat = NULL;

p_appwin mainwin = NULL;
p_bad_vtrackbar wave = NULL;
p_bad_vtrackbar midi = NULL;

static void trans_ev(p_object o, t_event *e)
{
  RETVIEW(o, e);

  if ((o->phase == PH_POSTPROCESS) && (e->type == EV_MESSAGE))
  {
    switch (e->message)
    {
      case MSG_WAVE: {
        set_volume(255-wave->pos, -1);
      } break;
      case MSG_MIDI: {
        set_volume(-1, 255-midi->pos);
      } break;
    };
  };
}

void init_app()
{
  t_rect r = rect_assign(0, 0, 420, 160);
  p_stattext st1 = NULL;
  p_stattext st2 = NULL;

  mainwin = appwin_init(_malloc(sizeof(t_appwin)), r, "Volume Controller for Bad Seal", WF_MINIMIZE, ap_id, &trans_ev);
#ifdef WANT_OLD_STUFF
  mainwin->icon16 = (BITMAP*)GET_DATA(dat, 0);
#else
{
              p_appwin_extension ext;
              if( OBJECT(mainwin)->find_extension && 
                  (ext=(p_appwin_extension)OBJECT(mainwin)->find_extension(OBJECT(mainwin), BS_APPWIN_NAME, BS_APPWIN_VERSION)))
                 ext->icon16= (BITMAP*)GET_DATA(dat, 0);
}
#endif
  VIEW(mainwin)->align |= TX_ALIGN_CENTER;

  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(mainwin));

  r = rect_assign(10, 40, 200, 60);
  st1 = stattext_init(_malloc(sizeof(t_stattext)), r, TX_ALIGN_TOP, "Digital sound volume:");
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(st1));

  r = rect_assign(10, 70, 200, 150);
  wave = bad_vtrackbar_init(_malloc(sizeof(t_bad_vtrackbar)), r, MSG_WAVE);
  wave->max = 255;
  wave->pos = 63;
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(wave));

  r = rect_assign(210, 40, 400, 60);
  st2 = stattext_init(_malloc(sizeof(t_stattext)), r, TX_ALIGN_TOP, "MIDI synthesis volume:");
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(st2));

  r = rect_assign(210, 70, 400, 150);
  midi = bad_vtrackbar_init(_malloc(sizeof(t_bad_vtrackbar)), r, MSG_MIDI);
  midi->max = 255;
  midi->pos = 63;
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(midi));

  set_volume(192, 192);
};

app_begin(void)
{
  if (ap_process == AP_INIT) {
    dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    init_app();
  };
} app_end;

