#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "dialogs.h"
#include "button.h"

static void trans_ev(p_object o, p_event event)
{
  if (event->type == EV_MESSAGE) {
    /* Message handling goes here */
  };
}

void app_init()
{
  p_menuview menu;

  t_rect r = rect_assign(0, 0, 300, 200);
  mainwin = appwin_init(malloc(sizeof(t_appwin)), r, "BEdit 1.1", WF_MINIMIZE|WF_MAXIMIZE, ap_id, &trans_ev);
  VIEW(mainwin)->align |= TX_ALIGN_CENTER;
  #ifdef Bad_Seal
  mainwin->icon16 = (BITMAP*)GET_DATA(dat, 0);
  mainwin->menu = standard_system_menu_items(mainwin,
               new_menu_line(
               new_menu_item("About BEdit...", 0, 0, MSG_ABOUT, NULL,
  NULL)));
  #endif
  VIEW(mainwin)->size_minimum = &app_min_size;
  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(mainwin));

  r = rect_assign(2, 20, 448, 40);
  menu = hormenu_init(malloc(sizeof(t_menuview)), r, bedit_menu());
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(menu));

  r = rect_assign(2, 45, 448, 383);
  edit = beditor_init(malloc(sizeof(t_beditor)), r, 0);
  VIEW(edit)->align |= TX_ALIGN_BOTTOM+TX_ALIGN_RIGHT;
  OBJECT(mainwwin)->insert(OBJECT(mainwin), OBJECT(edit));

  r = rect_assign(2, 385, 448, 398);
  status = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_LEFT, "Welcome to BEdit 1.1 by Bad Sector (K. Michalopoulos)");
  VIEW(status)->align |= TX_ALIGN_BOTTOM+TX_ALIGN_RIGHT;
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(status));
}


app_begin(void)
{
  if (ap_process == AP_INIT) {
    testapp_init();
  };
} app_end;