/* SPLORER 1.1 for Bad Seal */
/* Parts from code are taken from Disk Commander */

#include"allegro.h"
#include"seal.h"
#include"menus.h"
#include"app.h"
#include"button.h"
#include"dialogs.h"
#include"iodlg.h"
#define SP_SIZEX   300
#define SP_SIZEY   180
#ifndef TXT_CANTRUNFILE
#define TXT_CANTRUNFILE        INI_TEXT("Can't run file")
#endif

static DATAFILE *dat = NULL;
l_text path;

p_filelistbox box1;
extern void  filelistbox_translate_event ( p_object o, p_event event );

void  dcfilelistbox_translate_event ( p_object o, p_event event )
{
   RETVIEW(o, event);
   /* call old function from iodlg.h */
   filelistbox_translate_event(o, event);
   if ( event->type & EV_MESSAGE ) { /* */
       switch ( event->message ) {
           case MSG_OK : { /* enter on file */
                 l_text file = FILELISTBOX_ITEM_FILENAME(LISTBOX(o)->list, LISTBOX(o)->current);
                 l_text path = FILELISTBOX_ITEM_PATH(LISTBOX(o)->list, LISTBOX(o)->current);
                 l_text runfile = io_realpath(path, file);
                 l_text lf = io_sealfile(runfile);
                 clear_event(event);
                 if ( !run_file (lf) )
                     seal_error(ERR_INFO, "%s\n\n%s", TXT_CANTRUNFILE, lf);
                 _free(runfile);
                 _free(lf);
           }; break;
       };
   };
};


void  event_handler ( p_object o, p_event event )
{
   t_rect r;
   if ( event->type & EV_MESSAGE ) {
       switch ( event->message ) {
           case MSG_RESIZE : {
             r = VIEW(o)->size_limits(VIEW(o));
             r = rect_assign(r.a.x+10, r.a.y+10, r.b.x-10, r.b.y-20);
             VIEW(box1)->change_bounds(VIEW(box1), r);
           }; break;
       };
   };
};


static t_point  dc_size_minimum ( p_view o )
{
   return point_assign(100, 100);
};

void  init_dc ( void )
{
   t_rect r = rect_assign(0, 0, SP_SIZEX, SP_SIZEY);
   p_appwin o = appwin_init(_malloc(sizeof(t_appwin)), /* make window */
                            r,
                            "SPLORER 0.53",
                            WF_MAXIMIZE|WF_MINIMIZE,
                            ap_id, /* application id */
                            &event_handler);
#ifdef WANT_OLD_STUFF
   o->icon16 = (BITMAP*)GET_DATA(dat, 0);
#else
{
              p_appwin_extension ext;
              if( OBJECT(o)->find_extension && 
                  (ext=(p_appwin_extension)OBJECT(o)->find_extension(OBJECT(o), BS_APPWIN_NAME, BS_APPWIN_VERSION)))
                 ext->icon16= (BITMAP*)GET_DATA(dat, 0);
}
#endif
   VIEW(o)->drag_mode |= DM_DRAGGROW; /* able to grow view */
   VIEW(o)->align |= TX_ALIGN_CENTER; /* set alignment */
   VIEW(o)->size_minimum = &dc_size_minimum;
   OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(o)); /* insert it on the desktop */
   r = VIEW(o)->size_limits(VIEW(o));
   r = rect_assign(r.a.x+10, r.a.y+10, r.b.x-10, r.b.y-20);
//   r.a.y += 30;
   box1 = filelistbox_init(_malloc(sizeof(t_filelistbox)), r, 2, LF_SELECTABLE|FL_OPEN, path, "*.*", FA_ALL, NULL);
   if ( box1 ) {
        /* redeclare translate event function */
        OBJECT(box1)->translate_event = &dcfilelistbox_translate_event;
        /* redeclare alignment of filelistbox 1 */
        VIEW(box1)->align |= TX_ALIGN_RIGHT|TX_ALIGN_BOTTOM;
   };
   OBJECT(o)->insert(OBJECT(o), OBJECT(box1)); /* insert it on the desktop */
};

app_begin ( void ) {
  if ( ap_process == AP_INIT ) {
      dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
      if (ap_args) path = _strdup(ap_args);
      else {
        if (exists("./desktop")) path = strdup("./desktop");
        else path=strdup(".");
      };
      init_dc();
  };
  if ( ap_process == AP_FREE ) {
   _free(path);
  };
} app_end;

