/* SPACE 1.0 - Displays disk free space in drive C: */
/* Works only under Bad Seal 0.53 or newer or any compatible desktop
that contains a userbox and registry support */

#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "desktop.h"
#include "dos.h"

static DATAFILE *dat = NULL;

#define Get_Bitmap(n) (BITMAP*)GET_DATA(dat, n)

l_color face3d;

typedef struct t_spaceicon *p_spaceicon;

typedef struct t_spaceicon {

  struct t_view obclass;

} t_spaceicon;

void spaceicon_draw(p_view o)
{
  t_rect r = o->get_local_extent(o);
  t_point p;
  BITMAP *out = o->begin_paint(o, &p, r);

  if (out) {
    rectfill(out, r.a.x+p.x, r.a.y+p.y, r.b.x+p.x, r.b.y+p.y, face3d);
    draw_sprite(out, Get_Bitmap(0), r.a.x+p.x, r.a.y+p.y);
  };

  o->end_of_paint(o, r);

}

void spaceicon_translate_event(p_object o, t_event *event)
{
  RETVIEW(o, event);

  view_translate_event(o, event);

  if (event->type & EV_MOUSE && OBJECT(mouse)->state & MO_SF_MOUSELDOUBLE)
  {

    if (VIEW(o)->is_mouse_in_view(VIEW(o)))
    {
//      char ds[10];
      struct dfree d;
      getdfree(3, &d);
//      itoa(, ds, 10);
      msgbox(MW_INFO, MB_OK, "Free space in C: %i bytes\n\nDisk analysis:\n     %i total clusters\n     %i available clusters\n     %i sectors per cluster\n     %i bytes per sector\n\n\nTotal disk space: %i bytes", d.df_sclus*d.df_bsec*d.df_avail, d.df_total, d.df_avail, d.df_sclus, d.df_bsec, d.df_sclus*d.df_bsec*d.df_total);
    };

  };

};

p_spaceicon spaceicon_init(p_spaceicon o, t_rect r)
{
  if (!o) return NULL;
  clear_type(o, sizeof(t_spaceicon));

  view_init(&o->obclass, r);

  VIEW(o)->draw = &spaceicon_draw;
  OBJECT(o)->translate_event = &spaceicon_translate_event;

  return o;
};

p_spaceicon spaceicon;

app_begin(void)
{
  if (ap_process == AP_INIT) {
    t_rect r = rect_assign(0, 0, 15, 15);
    AP_SETNUMOFCALLS(1);
    face3d = registry_color("3d_face");
    dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    spaceicon = spaceicon_init(_malloc(sizeof(t_spaceicon)), r);
    add_to_userbox(OBJECT(spaceicon));

  };
} app_end;

