/****************************************************************/
/*                                                              */
/*                           imager.c                           */
/*                                                              */
/*                Seal - free desktop environment               */
/*                                                              */
/*                    Copyright (c) 1999,2000                   */
/*                         Michal Stencl                        */
/*                     All Rights Reserved                      */
/*                                                              */
/* mail : stenclpmd@ba.telecom.sk                               */
/* web  : http://www.home.sk/public/seal/                       */
/*                                                              */
/* This file is part of Seal.                                   */
/*                                                              */
/* Seal is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation; either version */
/* 2, or (at your option) any later version.                    */
/*                                                              */
/* Seal is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See    */
/* the GNU General Public License for more details.             */
/*                                                              */
/* You should have received a copy of the GNU General Public    */
/* License along with Seal; see the file COPYING.  If not,      */
/* write to the Free Software Foundation, 675 Mass Ave,         */
/* Cambridge, MA 02139, USA.                                    */
/*                                                              */
/****************************************************************/

#include"allegro.h"
#include"seal.h"
#include"app.h"
#include"button.h"
#include"dialogs.h"
#include"iodlg.h"

#ifndef TXT_CONVERTTOIMAGE
#define TXT_CONVERTTOIMAGE  INI_TEXT("Convert to image...")
#endif
#ifndef TXT_CONVERTNOW
#define TXT_CONVERTNOW      INI_TEXT("Convert now !")
#endif
#ifndef TXT_CLOSEBYALTF4
#define TXT_CLOSEBYALTF4    INI_TEXT("Close By Alt+F4")
#endif
#ifndef TXT_EXPORT
#endif
#ifndef TXT_IMAGEISCONVRTINGINTOFILE
#define TXT_IMAGEISCONVRTINGINTOFILE   INI_TEXT("Image is converting into file")
#endif
#ifndef TXT_PLEASEWAIT
#define TXT_PLEASEWAIT   INI_TEXT("Please wait...")
#endif
static BITMAP *image = NULL;
l_text dc_standard_path1 = "c:/";

#define MSG_VIEWF   10001
#define MSG_EDITF   10002
#define MSG_COPYF   10003
#define MSG_RENAMEF 10004
#define MSG_MKDIRF  10005
#define MSG_DELETEF 10006

#define DC_SIZEX   640
#define DC_SIZEY   480

#ifndef TXT_CANTRUNFILE
#define TXT_CANTRUNFILE        INI_TEXT("Can't run file")
#endif

p_filelistbox box1 = NULL;
p_view        imager = NULL;

void  imager_translate_event ( p_object o, p_event e )
{
   RETVIEW(o, e);
   win_translate_event(o, e);
#ifdef NOTDEF
   if ( e->type & EV_MOUSE && OBJECT(mouse)->state & MO_SF_MOUSELDOUBLE ) { /* right mouse button pressed */
         l_text file = NULL;
         clear_event(e);
         file = file_dialog(TXT_CONVERTTOIMAGE, TXT_CONVERTNOW, "c:/", "*.gif", get_imager_filelist(), FA_ALL, FL_SAVE, NULL);
         if ( file ) { /* no canceled dialog */
             l_text path = io_path(file);
             void *p = show_info(0, MW_INFO, "%s...\n\n%s %s...", TXT_PLEASEWAIT, TXT_IMAGEISCONVRTINGINTOFILE, file );
             save_bitmap(file, image, NULL);
             hide_info(p);
             RETYPE_FILES_IN_PATH(path); /* retype files is directory path,
                                            it's for redrawing listbox with
                                            files from dir path */
             _free(path);
         };
   };
#endif
};


l_bool  make_image ( l_text filename )
{
    if ( image ) destroy_bitmap(image);
    image = NULL;
    image = load_image(filename);
    if ( image ) {
      VIEW(imager)->brush.background = image;
      VIEW(imager)->brush.state = BRUSH_CENTER;
      VIEW(imager)->draw_view(VIEW(imager));
    } else return false;
    return true;
};

void   filelistbox_translate_event(p_object o, p_event event);

void  dcfilelistbox_translate_event ( p_object o, p_event event )
{
   RETVIEW(o, event);
   /* call old function from iodlg.h */
   filelistbox_translate_event(o, event);
   if ( event->type & EV_MESSAGE ) { /* */
       switch ( event->message ) {
           case MSG_OK : { /* enter on file */
                 l_text file = FILELISTBOX_ITEM_FILENAME(LISTBOX(o)->list, LISTBOX(o)->current);
                 l_text path = FILELISTBOX_ITEM_PATH(LISTBOX(o)->list, LISTBOX(o)->current);
                 l_text runfile = io_realpath(path, file);
                 l_text lf = io_sealfile(runfile);
                 clear_event(event);
                 if ( !make_image (lf) )
                     seal_error(ERR_INFO, "%s\n\n%s", INI_TEXT("Can't show image !"), lf);
                 _free(runfile);
                 _free(lf);
           }; break;
       };
   };
};


static t_point  dc_size_minimum ( p_view o )
{
   return point_assign(DC_SIZEX/2+100, 300);
};


void  init_imager ( char *args )
{
   t_rect r = rect_assign(0, 0, DC_SIZEX, DC_SIZEY);
   t_rect t = r;
   t_rect s = r;
   p_dirhistory  dir1;
   p_appwin o = appwin_init(_malloc(sizeof(t_appwin)), /* make window */
                            r,
                            "Imager 1.0",
                            WF_MINIMIZE,
                            ap_id, /* application id */
                            NULL);
   VIEW(o)->drag_mode |= DM_DRAGGROW; /* able to grow view */
   VIEW(o)->align |= TX_ALIGN_CENTER; /* set alignment */
   VIEW(o)->size_minimum = &dc_size_minimum;
   OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(o)); /* insert it on the desktop */
   r = VIEW(o)->size_limits(VIEW(o));
   s = r = rect_assign(r.a.x+10, r.a.y+10, t.b.x-10, r.b.y-40);
   r = rect_assign(r.a.x, r.a.y, r.a.x+(DC_SIZEX/2)-20, r.b.y);
   t = r;
   r.a.y += 30;

if(!args)
   box1 = filelistbox_init(_malloc(sizeof(t_filelistbox)), r, 2, LF_SELECTABLE|FL_OPEN, dc_standard_path1, "*.*", FA_ALL, NULL);
else {
   l_text x = io_path(args);
   box1 = filelistbox_init(_malloc(sizeof(t_filelistbox)), r, 2, LF_SELECTABLE|FL_OPEN, x, "*.*", FA_ALL, NULL);
   _free(x);
}
   if ( box1 ) {
        /* redeclare translate event function */
        OBJECT(box1)->translate_event = &dcfilelistbox_translate_event;
        /* redeclare alignment of filelistbox 1 */
        VIEW(box1)->align |= TX_ALIGN_BOTTOM;
   };
   r = rect_move(r, (DC_SIZEX/2)-10, 0);
   imager = view_init(_malloc(sizeof(t_view)), r);
   if ( imager ) {
        /* redeclare translate event function */
        OBJECT(imager)->translate_event = &imager_translate_event;
        /* redeclare alignment of filelistbox 1 */
        VIEW(imager)->align |= TX_ALIGN_RIGHT+TX_ALIGN_BOTTOM;
   };
   r = rect_assign(t.a.x, t.a.y, t.a.x+200, t.a.y+20);
   /* make link for box1 */
   dir1 = dirhistory_init(_malloc(sizeof(t_dirhistory)), r, IO_TEXT_LIMIT, HF_REWRITEUNABLE, box1);
   r = rect_assign(t.a.x+(DC_SIZEX/2)-10, r.a.y, DC_SIZEX-30, r.b.y);
   OBJECT(o)->insert(OBJECT(o), OBJECT(box1)); /* insert it on the desktop */
   OBJECT(o)->insert(OBJECT(o), OBJECT(dir1)); /* insert it on the desktop */
   OBJECT(o)->insert(OBJECT(o), OBJECT(imager)); /* insert it on the desktop */
   if(args && !make_image (args) )
                     seal_error(ERR_INFO, "%s\n\n%s", INI_TEXT("Can't show image"), args);
};


p_list get_imager_filelist ( void ) {
                                                /* function for free-ing items */
  p_list p = list_init(malloc(sizeof(t_list)), &free_filehistory_item, 0);
  if ( p ) {
     p->insert(p, new_filehistory_item("Gif files (*.gif)", "*.gif"));
     p->insert(p, new_filehistory_item("Jpeg files (*.jpg)", "*.jpg"));
     p->insert(p, new_filehistory_item("Jpeg files (*.jpg)", "*.jpeg"));
     p->insert(p, new_filehistory_item("Bmp files (*.bmp)", "*.bmp"));
     p->insert(p, new_filehistory_item("Pcx files (*.pcx)", "*.pcx"));
     p->insert(p, new_filehistory_item("Tiff files (*.tif)", "*.tif"));
     p->insert(p, new_filehistory_item("Targa files (*.tga)", "*.tga"));
     p->insert(p, new_filehistory_item("Lbm files (*.lbm)", "*.lbm"));
     p->insert(p, new_filehistory_item("X Window Bitmap files (*.xbm)", "*.xbm"));
     p->insert(p, new_filehistory_item("Iax files (*.iax)", "*.iax"));
     p->insert(p, new_filehistory_item("Pse files (*.pse)", "*.pse"));
     p->insert(p, new_filehistory_item("Pixmap files (*.ppm)", "*.ppm"));
     p->insert(p, new_filehistory_item("Portable Greyscale-map files (*.pgm)", "*.pgm"));
     p->insert(p, new_filehistory_item("Vid files (*.vid)", "*.vid"));
     p->insert(p, new_filehistory_item("All files (*.*)", "*.*"));
  };
  return p;
};


app_begin ( void ) {
  if ( ap_process == AP_INIT ) {
    init_imager(ap_args);
  } else
  if ( ap_process == AP_FREE ) {
    if ( image ) destroy_bitmap(image);
    image = NULL;
  };
} app_end;

