/****************************************************************/
/*                                                              */
/*                            help.c                            */
/*                     Bad Seal help system                     */
/*                             v0.1                             */
/*                                                              */
/*        (c) 2001 Kostas Michalopoulos aka Bad Sector          */
/*                                                              */
/****************************************************************/

#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "dialogs.h"
#include "iodlg.h"
#include "helpsys.h"

#define MSG_CONTENTS    10001
#define MSG_GOBACK      10002

p_appwin mainwin = NULL;
p_helpbox help = NULL;
l_text filename = NULL;
l_text topic = NULL;

static DATAFILE *dat = NULL;

static void trans_ev(p_object o, p_event event)
{
  if (event->type == EV_MESSAGE) {
    switch (event->message) {
      case MSG_CONTENTS: {
        help->navigate(help, "main");
        clear_event(event);
      }; break;
      case MSG_GOBACK: {
        help->go_back(help);
        clear_event(event);
      }; break;
    };
  };
}

l_bool on_request(p_helpbox o, l_int request, void *data1, void *data2, void **rdata1)
{
  switch (request) {
    case HBREQ_BUTTON: {
//      DEBUG_printf("\nAdd button %s", (l_text) data1);
      return TRUE;
    }; break;
  };

  return FALSE;
}

void app_init()
{
  p_button b = NULL;
  t_rect r = rect_assign(0, 0, 550, 430);
  BITMAP *ico16 = create_bitmap(16, 16);
  mainwin = appwin_init(malloc(sizeof(t_appwin)), r, "Bad Seal Help System", WF_MINIMIZE|WF_MAXIMIZE, ap_id, &trans_ev);
  blit((BITMAP*)GET_DATA(dat, 0), ico16, 0, 0, 0, 0, 16, 16);
  #ifdef Bad_Seal
#ifdef WANT_OLD_STUFF
  mainwin->icon16 = ico16;
#else
{
              p_appwin_extension ext;
              if( OBJECT(mainwin)->find_extension && 
                  (ext=(p_appwin_extension)OBJECT(mainwin)->find_extension(OBJECT(mainwin), BS_APPWIN_NAME, BS_APPWIN_VERSION)))
                 ext->icon16= (BITMAP*)GET_DATA(dat, 0);
}
#endif
  #endif
  VIEW(mainwin)->align |= TX_ALIGN_CENTER;
  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(mainwin));

  r = rect_assign(3, 48, 547, 427);
  help = helpbox_init(malloc(sizeof(t_helpbox)), r);
  help->request = &on_request;
  VIEW(help)->align |= TX_ALIGN_BOTTOM+TX_ALIGN_RIGHT;
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(help));

  if (filename) {
    help->filename = filename;
    helpbox_navigate(help, topic);
  };

  r = rect_assign(3, 20, 103, 45);
  b = button_init(malloc(sizeof(t_button)), r, "Contents", MSG_CONTENTS, 0);
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(b));

  r = rect_assign(106, 20, 206, 45);
  b = button_init(malloc(sizeof(t_button)), r, "Go Back", MSG_GOBACK, 0);
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(b));
}

app_begin(void)
{
  if (ap_process == AP_INIT) {
    dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    if (ap_args) {
      filename = strdup(ap_args);
      if (!strchr(filename, ' ')) topic = strdup("main"); else {
        topic = strchr(filename, ' ')+1;
        filename[strlen(filename)-strlen(topic)-1]=0;
      };
    };
    app_init();
  };
} app_end;

