/* Control Panel for Bad Seal 0.53 */

#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "dialogs.h"
#include "badctrls.h"
#include "registry.h"
#include "iodlg.h"

#define MSG_MIN_IMAGE 10001
#define MSG_MAX_IMAGE 10002
#define MSG_CLOSE_IMAGE 10003
#define MSG_WALL_PAPER 10004

p_appwin        mainwin;

p_bad_tabbook   tb;
p_history       resolution;
p_history       depth;
p_bad_checkbox  scroll_nice;
p_bad_checkbox  move_contents;
p_bad_checkbox  move_accel;
p_bad_checkbox  use_hourglass;
p_textline      min_image;
p_textline      max_image;
p_textline      close_image;
p_button        bt_min_image;
p_button        bt_max_image;
p_button        bt_close_image;
p_bad_checkbox  taskbar_alone;
p_textline      wall_paper;
p_button        bt_wall_paper;
p_history       wp_style;
p_bad_checkbox  use_hourglass;
p_textline      main_path;

//static DATAFILE *dat = NULL;

p_list resolution_items()
{
  p_list p = list_init(malloc(sizeof(t_list)), &free_history_item, 0);

  if (p) {
    p->insert(p, new_history_item("640x480", NULL, 0, NULL));
    p->insert(p, new_history_item("800x600", NULL, 0, NULL));
    p->insert(p, new_history_item("1024x748", NULL, 0, NULL));
  };

  return p;
}

p_list depth_items()
{
  p_list p = list_init(malloc(sizeof(t_list)), &free_history_item, 0);

  if (p) {
    p->insert(p, new_history_item("8bpp, 256 colors", NULL, 0, NULL));
    p->insert(p, new_history_item("15bpp Hi color", NULL, 0, NULL));
    p->insert(p, new_history_item("16bpp Hi color", NULL, 0, NULL));
    p->insert(p, new_history_item("24bpp True color", NULL, 0, NULL));
    p->insert(p, new_history_item("32bpp True color", NULL, 0, NULL));
  };

  return p;
}

static p_list wp_style_items()
{
  p_list p = list_init(malloc(sizeof(t_list)), &free_history_item, 0);

  if (p) {
    p->insert(p, new_history_item("upper left corner", NULL, 0, NULL));
    p->insert(p, new_history_item("stretched to screen", NULL, 0, NULL));
    p->insert(p, new_history_item("centered on screen", NULL, 0, NULL));
  };

  return p;
}

/* UNUSED
static p_list get_file_types_list()
{
  p_list p = list_init(malloc(sizeof(t_list)), &free_listbox_item, DAT_LIST);

  if (p) {
    p_registry_search inf = (p_registry_search) malloc(sizeof(t_registry_search));

    if (reg_find_first("system/filetypes", inf)) do {
      l_text title = get_key(inf->name);
      p->insert(p, new_listbox_item(title, NULL, TRUE, LIF_NONE));
      free(title);
      free(inf->name);
    } while (reg_find_next(inf));

    free(inf);
  };

  return p;
}
*/

p_list get_openimage_items()
{
  p_list p = list_init(malloc(sizeof(t_list)), &free_filehistory_item, 0);

  if (p) {
    p->insert(p, new_filehistory_item("Bitmap image", "*.bmp"));
    p->insert(p, new_filehistory_item("PCX Image", "*.pcx"));
    p->insert(p, new_filehistory_item("TGA image", "*.tga"));
    p->insert(p, new_filehistory_item("GIF image", "*.gif"));
    p->insert(p, new_filehistory_item("Jpeg image", "*.jpg"));
  };

  return p;
}

void handle_event(p_object o, p_event event)
{
  if (event->type == EV_MESSAGE) {
    l_text file;
//fprintf(stderr,"hande_event\n");
    switch (event->message) {
      case MSG_OK: {

        switch (resolution->current) {
          case 0: {
            set_key_integer("system/graphics/width", 640);
            set_key_integer("system/graphics/height", 480);
          } break;
          case 1: {
            set_key_integer("system/graphics/width", 800);
            set_key_integer("system/graphics/height", 600);
          } break;
          case 2: {
            set_key_integer("system/graphics/width", 1024);
            set_key_integer("system/graphics/height", 768);
          } break;
        };

//       switch (resolution->current) { // surely not! jdh
       switch (depth->current) {

          case 0: set_key_integer("system/graphics/depth", 8); break;
          case 1: set_key_integer("system/graphics/depth", 15); break;
          case 2: set_key_integer("system/graphics/depth", 16); break;
          case 3: set_key_integer("system/graphics/depth", 24); break;
          case 4: set_key_integer("system/graphics/depth", 32); break;
          default: set_key_integer("system/graphics/depth", 15); break;
        };

        set_key_integer("current/seal/optical/move_window_context", move_contents->state);
        set_key_integer("current/seal/optical/enable_move_acceleration", move_accel->state);
        set_key_integer("current/seal/optical/scroll_nice", scroll_nice->state);
        set_key("current/seal/images/min_image", min_image->text);
        set_key("current/seal/images/max_image", max_image->text);
        set_key("current/seal/images/close_image", close_image->text);

        set_key_integer("current/seal/optical/taskbar_alone", taskbar_alone->state);
        set_key("global/seal/desktop/wallpaper", wall_paper->text);
        set_key_integer("global/seal/desktop/placement", wp_style->current);

        set_key_integer("current/seal/optical/clock_including", use_hourglass->state);
        set_key("system/paths/main", main_path->text);

        if (desktop->brush.state & BRUSH_SELFIMG) destroy_bitmap(desktop->brush.background);
        desktop->brush.background = NULL;
        switch (wp_style->current) {
          case 0: desktop->brush.state &=~(BRUSH_STRETCH|BRUSH_CENTER); break;
          case 1: desktop->brush.state |= BRUSH_STRETCH;
          case 2: desktop->brush.state |= BRUSH_CENTER;
        };
        if (wall_paper->text) desktop->brush.background = load_image(wall_paper->text);
        desktop->brush.state |= BRUSH_SELFIMG;
        desktop->draw_me(desktop);
// jdh most changes (because of caching).
        msgbox(MW_INFO, MB_OK, "For many changes to take effect you have\nto restart Bad Seal. If some error occurs try to start\nin safe mode using the -safe parameter.");

        clear_event(event);
        set_event(event, EV_MESSAGE, MSG_CLOSE, o);
        o->put_event(o, event);
        clear_event(event);
      } break;
      case MSG_MIN_IMAGE: {
        file = open_dialog("./system/bmp", "*.bmp", get_openimage_items());
        if (file) {
          min_image->set_text(min_image, file);
          free(file);
        };
        clear_event(event);
      } break;
      case MSG_MAX_IMAGE: {
        file = open_dialog("./system/bmp", "*.bmp", get_openimage_items());
        if (file) {
          max_image->set_text(max_image, file);
          free(file);
        };
        clear_event(event);
      } break;
      case MSG_CLOSE_IMAGE: {
        file = open_dialog("./system/bmp", "*.bmp", get_openimage_items());
        if (file) {
          close_image->set_text(close_image, file);
          free(file);
        };
        clear_event(event);
      } break;
      case MSG_WALL_PAPER: {
        file = open_dialog("./system/wallpapr", "*.bmp", get_openimage_items());
        if (file) {
          wall_paper->set_text(wall_paper, file);
          free(file);
        };
        clear_event(event);
      } break;
    };
//fprintf(stderr,"handle_event done\n");
  };
}

void app_init()
{
  t_rect r = rect_assign(0, 0, 400, 300);
  p_stattext s;
  p_button b;

  /* initialize edited window */
  mainwin = appwin_init(malloc(sizeof(t_appwin)), r, "Bad Seal Control Panel", WF_MINIMIZE, ap_id, &handle_event);
  VIEW(mainwin)->align |= TX_ALIGN_CENTER;
  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(mainwin));

  r = rect_assign(80, 270, 180, 296);
  b = button_init(malloc(sizeof(t_button)), r, "OK", MSG_OK, BF_NORMAL);
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(b));

  r = rect_assign(220, 270, 320, 296);
  b = button_init(malloc(sizeof(t_button)), r, "Cancel", MSG_CLOSE, BF_NORMAL);
  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(b));

  r = rect_assign(2, 21, 398, 268);
  tb = bad_tabbook_init(malloc(sizeof(t_bad_tabbook)), r, "Graphics");

  OBJECT(mainwin)->insert(OBJECT(mainwin), OBJECT(tb));

  tb->add_tab(tb, "Windows");
  tb->add_tab(tb, "Desktop");
  tb->add_tab(tb, "Misc");
  /* Graphics tab */
  r = rect_assign(10, 10, 366, 30);
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Resolution:");
  OBJECT(tb->tab[0])->insert(OBJECT(tb->tab[0]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  resolution = history_init(malloc(sizeof(t_history)), r, resolution_items(), 150, HF_REWRITEUNABLE|LF_SELFLIST);
  OBJECT(tb->tab[0])->insert(OBJECT(tb->tab[0]), OBJECT(resolution));
  switch (get_key_integer("system/graphics/width")) {
    case 640: {
      resolution->rewrite_item(resolution, 0);
    } break;
    case 800: {
      resolution->rewrite_item(resolution, 1);
    } break;
    case 1024: {
      resolution->rewrite_item(resolution, 2);
    } break;
    default: {
      resolution->rewrite_item(resolution, 0);
    } break;
  };

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Color depth:");
  OBJECT(tb->tab[0])->insert(OBJECT(tb->tab[0]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  depth = history_init(malloc(sizeof(t_history)), r, depth_items(), 150, HF_REWRITEUNABLE|LF_SELFLIST);
  OBJECT(tb->tab[0])->insert(OBJECT(tb->tab[0]), OBJECT(depth));
  switch (get_key_integer("system/graphics/depth")) {
    case 8: {
      depth->rewrite_item(depth, 0);
    } break;
    case 15: {
      depth->rewrite_item(depth, 1);
    } break;
    case 16: {
      depth->rewrite_item(depth, 2);
    } break;
    case 24: {
      depth->rewrite_item(depth, 3);
    } break;
    case 32: {
      depth->rewrite_item(depth, 4);
    } break;
    default: {
      depth->rewrite_item(depth, 1);
    } break;
  };

  /* Windows tab */
  r = rect_assign(10, 10, 366, 30);
// No longer needed/available.
  move_contents = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "Move window contents while dragging", MSG_NOTHING, get_key_integer("current/seal/optical/move_window_context"));
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(move_contents));

  r.a.y += 21; r.b.y += 21;
  move_accel = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "Accelerated moving", MSG_NOTHING, get_key_integer("current/seal/optical/enable_move_acceleration"));
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(move_accel));

  r.a.y += 21; r.b.y += 21;
  scroll_nice = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "Smooth scrolling", MSG_NOTHING, get_key_integer("current/seal/optical/scroll_nice"));
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(scroll_nice));

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Minimize button image:");
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  min_image = textline_init(malloc(sizeof(t_textline)), r, 0, 0);
  min_image->set_text(min_image, get_key("current/seal/images/min_image"));
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(min_image));

  bt_min_image = button_init(malloc(sizeof(t_button)), rect_assign(367, r.a.y, 386, r.b.y), ">", MSG_MIN_IMAGE, BF_NORMAL);
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(bt_min_image));

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Maximize button image:");
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  max_image = textline_init(malloc(sizeof(t_textline)), r, 0, 0);
  max_image->set_text(max_image, get_key("current/seal/images/max_image"));
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(max_image));

  bt_max_image = button_init(malloc(sizeof(t_button)), rect_assign(367, r.a.y, 386, r.b.y), ">", MSG_MAX_IMAGE, BF_NORMAL);
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(bt_max_image));

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Close button image:");
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  close_image = textline_init(malloc(sizeof(t_textline)), r, 0, 0);
  close_image->set_text(close_image, get_key("current/seal/images/close_image"));
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(close_image));

  bt_close_image = button_init(malloc(sizeof(t_button)), rect_assign(367, r.a.y, 386, r.b.y), ">", MSG_CLOSE_IMAGE, BF_NORMAL);
  OBJECT(tb->tab[1])->insert(OBJECT(tb->tab[1]), OBJECT(bt_close_image));

  /* Desktop tab */
  r = rect_assign(10, 10, 366, 30);
  taskbar_alone = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "Place taskbar alone at the top", MSG_NOTHING, get_key_integer("current/seal/optical/taskbar_alone"));
  OBJECT(tb->tab[2])->insert(OBJECT(tb->tab[2]), OBJECT(taskbar_alone));

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Wallpaper image:");
  OBJECT(tb->tab[2])->insert(OBJECT(tb->tab[2]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  wall_paper = textline_init(malloc(sizeof(t_textline)), r, 0, 0);
  wall_paper->set_text(wall_paper, get_key("global/seal/desktop/wallpaper"));
  OBJECT(tb->tab[2])->insert(OBJECT(tb->tab[2]), OBJECT(wall_paper));

  bt_wall_paper = button_init(malloc(sizeof(t_button)), rect_assign(367, r.a.y, 386, r.b.y), ">", MSG_WALL_PAPER, BF_NORMAL);
  OBJECT(tb->tab[2])->insert(OBJECT(tb->tab[2]), OBJECT(bt_wall_paper));

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Wallpaper placement:");
  OBJECT(tb->tab[2])->insert(OBJECT(tb->tab[2]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  wp_style = history_init(malloc(sizeof(t_history)), r, wp_style_items(), 150, HF_REWRITEUNABLE|LF_SELFLIST);
  OBJECT(tb->tab[2])->insert(OBJECT(tb->tab[2]), OBJECT(wp_style));

  wp_style->rewrite_item(wp_style, get_key_integer("global/seal/desktop/placement"));

  /* Misc tab */
  r = rect_assign(10, 10, 366, 30);
  use_hourglass = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "Use hourglass/clock mouse cursor", MSG_NOTHING, get_key_integer("current/seal/optical/clock_including"));
  OBJECT(tb->tab[3])->insert(OBJECT(tb->tab[3]), OBJECT(use_hourglass));

  r.a.y += 21; r.b.y += 21;
  s = stattext_init(malloc(sizeof(t_stattext)), r, TX_ALIGN_BOTTOM, "Main Bad Seal path (where Bad Seal is placed?):");
  OBJECT(tb->tab[3])->insert(OBJECT(tb->tab[3]), OBJECT(s));

  r.a.y += 21; r.b.y += 21;
  main_path = textline_init(malloc(sizeof(t_textline)), r, 255, 0);
  main_path->set_text(main_path, get_key("system/paths/main"));

  OBJECT(tb->tab[3])->insert(OBJECT(tb->tab[3]), OBJECT(main_path));
}

app_begin(void)
{
  if (ap_process == AP_INIT) {
    // seems to be unused
    //dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    app_init();
  };
} app_end;

