/* BadCLOCK */
/* version 1.0 (c) 2000 Kostas Michalopoulos /aka Bad Sector */

#include "libm/math.h"
#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "dos.h"

static DATAFILE *dat = NULL;

p_appwin mainwin;
l_int background;

static t_point minimum_size(p_view o)
{
  return point_assign(160, 160);
}

void refresh(p_object o)
{
  p_view vo = VIEW(mainwin);
  t_rect r = vo->size_limits(vo);
  t_point p;

  BITMAP *out = vo->begin_paint(vo, &p, r);

  int cr, xx, yy, d;
  struct time t;

  gettime(&t);

  cr = 60;

  if (out) {
    BITMAP *bgnd = (BITMAP*)GET_DATA(dat, background);
    xx = p.x+(r.b.x-r.a.x)/2;
    yy = p.y+(r.b.y-r.a.y)/2+20;

    //rectfill(out, p.x+r.a.x, p.y+r.a.y, p.x+r.b.x, p.y+r.b.y, COLOR(7));
    blit(bgnd, out, 0, 0, r.a.x+p.x, r.a.y+p.y, 160, 160);

    if (t.ti_hour > 12) t.ti_hour = t.ti_hour-12;
    d = (360*t.ti_hour/12)-90;
    line(out, xx, yy, xx+cos(3.14*d/180)*(3*cr/6), yy+sin(3.14*d/180)*(3*cr/6), COLOR(0));
    line(out, xx+1, yy, xx+1+cos(3.14*d/180)*(3*cr/6), yy+sin(3.14*d/180)*(3*cr/6), COLOR(0));
    line(out, xx, yy+1, xx+cos(3.14*d/180)*(3*cr/6), yy+1+sin(3.14*d/180)*(3*cr/6), COLOR(0));
    line(out, xx+1, yy+1, xx+1+cos(3.14*d/180)*(3*cr/6), yy+1+sin(3.14*d/180)*(3*cr/6), COLOR(0));

    d = (360*t.ti_min/60)-90;
    line(out, xx, yy, xx+cos(3.14*d/180)*(4*cr/6), yy+sin(3.14*d/180)*(4*cr/6), COLOR(0));
    line(out, xx+1, yy, xx+1+cos(3.14*d/180)*(4*cr/6), yy+sin(3.14*d/180)*(4*cr/6), COLOR(0));
    line(out, xx, yy+1, xx+cos(3.14*d/180)*(4*cr/6), yy+1+sin(3.14*d/180)*(4*cr/6), COLOR(0));
    line(out, xx+1, yy+1, xx+1+cos(3.14*d/180)*(4*cr/6), yy+1+sin(3.14*d/180)*(4*cr/6), COLOR(0));

    d = (360*(t.ti_sec*10+t.ti_hund/10)/600)-90;
    line(out, xx, yy, xx+cos(3.14*d/180)*(5*cr/6), yy+sin(3.14*d/180)*(5*cr/6), COLOR(4));
  }

  vo->end_of_paint(vo, r);
}

static void handle_event(p_object o, p_event event)
{
  if (event->type & EV_MOUSE && OBJECT(mouse)->state & MO_SF_MOUSELDOUBLE) {
    if (VIEW(o)->is_mouse_in_view(VIEW(o))) {
      if (background < 3) background++; else background = 1;
      refresh(o);
    };
  };
}

void draw_win(p_view o)
{
  win_draw(o);
  refresh(OBJECT(o));
};

void bclock_init()
{
  t_rect r = rect_assign(0, 0, 163, 180);
  /* initialize edited window */
  mainwin = appwin_init(malloc(sizeof(t_appwin)), r, "BadCLOCK 2", WF_MINIMIZE, ap_id, &handle_event);
#ifdef WANT_OLD_STUFF
  mainwin->icon16 = (BITMAP*)GET_DATA(dat, 0);
#else
{
              p_appwin_extension ext;
              if( OBJECT(mainwin)->find_extension && 
                  (ext=(p_appwin_extension)OBJECT(mainwin)->find_extension(OBJECT(mainwin), BS_APPWIN_NAME, BS_APPWIN_VERSION)))
                 ext->icon16= (BITMAP*)GET_DATA(dat, 0);
}
#endif
  VIEW(mainwin)->align |= TX_ALIGN_CENTER;
  VIEW(mainwin)->size_minimum = &minimum_size;
  VIEW(mainwin)->draw = &draw_win;
  OBJECT(mainwin)->process_tick = 1000;
  OBJECT(mainwin)->func_callback = &refresh;
  background = 1;
  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(mainwin));
  init_stillprocess(OBJECT(mainwin), 1000);
}

app_begin(void)
{
  if (ap_process == AP_INIT) {
    AP_SETNUMOFCALLS(1);
    dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    bclock_init();
  };
} app_end;

