/*         ______   ___    ___
 *        /\  _  \ /\_ \  /\_ \
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *
 *      Mac-specific header defines.
 *
 *      By Ronaldo Hideki Yamada.
 *
 *      See readme.txt for copyright information.
 */

#ifdef __cplusplus
   extern "C" {
#endif

/*******************************************/
/************* system drivers **************/
/*******************************************/
#define SYSTEM_MACOS           AL_ID('M','C','O','S')
AL_VAR(SYSTEM_DRIVER, system_macos);

/*******************************************/
/************** timer drivers **************/
/*******************************************/
#define TIMER_MACOS           AL_ID('M','C','O','S')
AL_VAR(TIMER_DRIVER, timer_macos);

/*******************************************/
/************ keyboard drivers *************/
/*******************************************/
#define KEYBOARD_MACOS       AL_ID('M','C','O','S')
AL_VAR(KEYBOARD_DRIVER, keyboard_macos);

/*******************************************/
/************* mouse drivers ***************/
/*******************************************/
#define MOUSE_MACOS          AL_ID('M','C','O','S')
AL_VAR(MOUSE_DRIVER, mouse_macos);

/*******************************************/
/*************** gfx drivers ***************/
/*******************************************/
#define GFX_DRAWSPROCKET     AL_ID('D','S','P',' ')
AL_VAR(GFX_DRIVER,gfx_drawsprocket);

#define GFX_SAFE_ID              GFX_DRAWSPROCKET
#define GFX_SAFE_DEPTH           8
#define GFX_SAFE_W               640
#define GFX_SAFE_H               480

/********************************************/
/*************** sound drivers **************/
/********************************************/
#define DIGI_MACOS            AL_ID('M','C','O','S')
AL_VAR(DIGI_DRIVER, digi_macos);

#define MIDI_QUICKTIME        AL_ID('Q','T',' ',' ')

/*******************************************/
/************ joystick drivers *************/
/*******************************************/
/*no yet */

#ifdef __cplusplus
   }
#endif
