/* TXT2REG - Textfile to registry converter */
#include <stdio.h>
#include "registry.c"

int main()
{
  FILE *f;
  char fname[256];
  char path[1024];
  char key[128];
  char value[256];
  int n, nb;

  init_registry();

  printf("Enter filename: ");gets(fname);
  f = fopen(fname, "rt");
  if (!f) return 0;
  while (fgets(path, 1024, f)) {
    path[strlen(path)-1] = 0;
    if (strcmp(path, "") != 0) {
      fgets(key, 127, f);
      key[strlen(key)-1] = 0;
      if (strcmp(key, "&&number&&") == 0) {
        nb = 1;
        fgets(key, 127, f);
        key[strlen(key)-1] = 0;
      } else nb = 0;
      printf("`%s' = ", key_in_path(path, key));
      fgets(value, 255, f);
      value[strlen(value)-1] = 0;
      printf("%s ...", value);
      if (!key_exists(key_in_path(path, key))) create_key(path, key);
      if (nb) {
        printf("(integer) ");
        n = atoi(value);
        set_key_integer(key_in_path(path, key), n);
        printf("%i  ", n);
      } else set_key(key_in_path(path, key), value);
      printf("ok\n");
    };
  };
  fclose(f);

  return 0;
}

