/* string list functions (strings) */
/* (c) 2000 Kostas Michalopoulos */

typedef struct t_strings *p_strings;

typedef struct t_strings {
  p_strings first, last, next;
  char *string;
  int count;
} t_strings;

/* returns an initialized string list */
p_strings init_strings();

/* returns the "r" with "text" added */
p_strings add_to_strings(p_strings r, char *text);

/* returns first item in string list r */
p_strings get_first(p_strings r);

/* returns last item in string list r */
p_strings get_last(p_strings r);

/* returns the count of items in string list r (last item = get_count(r)-1) */
int get_count(p_strings r);

/* returns string at position "index" in string list "s" */
char *get_string(p_strings s, int index);

/* frees and destroys string list "s" */
void free_strings(p_strings s);


