#include "strings.h"

p_strings init_strings()
{
  p_strings r = (t_strings *) malloc(sizeof(t_strings));

  r->first = r;
  r->last = r;
  r->next = 0;
  r->string = 0;
  r->count = 0;

  return r;
};

p_strings add_to_strings(p_strings r, char *text)
{
  p_strings nr = (t_strings *) malloc(sizeof(t_strings));
  nr->first = r->first;
  nr->first->last = nr;
  nr->first->count++;
  nr->next = 0;
  nr->string = 0;

  r->string = (char *) malloc(strlen(text)+1);
  strcpy(r->string, text);
  r->next = nr;

  return nr;
};

p_strings get_first(p_strings r)
{
  return r->first;
};

p_strings get_last(p_strings r)
{
  return r->first->last;
};

int get_count(p_strings r)
{
  return r->first->count;
};

char *get_string(p_strings s, int index)
{
  p_strings r = s->first;
  p_strings last = r->last;
  int i = 0;
  while (r != last) {
    if (i == index) return r->string;
    i++;
    r = r->next;
  };
  if (i == index) return r->string;

  return 0;
};

void free_strings(p_strings s)
{
  p_strings r = s->first;
  p_strings last = r->last;
  p_strings n;
  while (r != last) {
    n = r->next;
    free(r);
    r = n;
  };
  free(r);
};

