/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* SIP (Seal Installable Packages) generator 1.0 */
/* (C) 2001 Kostas Michalopoulos aka Bad Sector  */
/* e-mail: michalopoylos@hotmail.com             */
/* www: http://www.badseal.org                   */
/*      http://me.badseal.org/                   */
/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */

#include <stdio.h>

int ask_for_path = 0;
int script = 0;

char *get_str(FILE *f)
{
  char *s = (char *) malloc(256);
  int sl;
  fgets(s, 256, f);
  sl = strlen(s);
  s[sl-1] = 0;
  s = (char *) realloc(s, sl);
  return s;
}

void put_str(FILE *f, char *s)
{
  fwrite(s, strlen(s)+1, 1, f);
}

FILE *open_for(char *t)
{
  FILE *f = fopen("sipgen.inf", "rt");
  char *s;
  while (!feof(f)) {
    s = get_str(f);
    if (!stricmp(s, t)) {
      free(s);
      return f;
    };
    free(s);
  };
  fclose(f);
  return 0;
}

int check_section(char *sec)
{
  FILE *f = open_for(sec);
  if (!f) {
    printf("%s section not found.\n", sec);
    return 0;
  } else fclose(f);
  return 1;
}

main()
{
  FILE *f = fopen("sipgen.inf", "rt");
  FILE *o;
  char *s;
  int i;
  char *scr;
  char id[4] = {'S', 'I', 'P', '0'};

  printf("SIPGenerator 1.0 (C) 2001 Kostas Michalopoulos aka Bad Sector\n");
  if (!f) {
    printf("sipgen.inf file not found.\n");
    return 0;
  };
  fclose(f);
  if (!check_section(".info")) return 0;
  if (!check_section(".files")) return 0;
  if (!check_section(".destination")) return 0;
  if (check_section(".ask_for_path")) ask_for_path = 1;
  if (check_section(".script")) script = 1;
  printf("Generating outfile.sip...");
  o = fopen("outfile.sip", "wb+");
  if (!o) {
    printf(" cannot create file!\n");
    return 0;
  };

  fwrite(&id, 4, 1, o);
  i = 0;
  fwrite(&i, 4, 1, o);

  f = open_for(".info");
  for (i=0;i<3;i++) {
    s = get_str(f);
    put_str(o, s);
    free(s);
  };
  printf(".");
  fclose(f);

  f = open_for(".destination");
  s = get_str(f);
  put_str(o, s);
  free(s);
  printf(".");
  fclose(f);

  fwrite(&ask_for_path, 4, 1, o);
  printf(".");

  f = open_for(".files");
  while (!feof(f)) {
    s = get_str(f);
    if (!strcmp(s, ".")) {
      put_str(o, "\001\001\001\001");
      free(s);
      break;
    };
    put_str(o, s);
    free(s);
  };
  fclose(f);
  printf(".");

  fwrite(&script, 4, 1, o);
  if (script) {
    f = open_for(".script");
    while (!feof(f)) {
      int i;
      s = get_str(f);
      if (!strcmp(s, ".")) {
        put_str(o, "\001\001\001\001");
        free(s);
        break;
      };
      put_str(o, s);
      free(s);
    };
    fclose(f);
  };
  printf(".");

  f = open_for(".files");
  while (!feof(f)) {
    FILE *i;
    s = get_str(f);
    if (!strcmp(s, ".")) {
      free(s);
      break;
    };
    i = fopen(s, "rb");
    if (!i) {
      printf(" -> error: %s not included.\n", s);
    } else {
      int fsize = filelength(fileno(i));
      int fw = 0;
      fwrite(&fsize, 4, 1, o);
      free(s);
      s = get_str(f);
      while (fw != fsize) {
        char buff[4096];
        int block = sizeof(buff);
        int ii;
        if (block > fsize-fw) block = fsize-fw;
        fread(&buff, block, 1, i);
        fwrite(&buff, block, 1, o);
        fw += block;
      };
      fclose(i);
    };
    free(s);
  };
  fclose(f);
  printf(".");

  fclose(o);
  printf(" done!\n");

  return 0;
}

