/****************************************************************/
/*                                                              */
/*                           helpc.c                            */
/*                    Bad Seal help compiler                    */
/*                             v0.1                             */
/*                                                              */
/*        (c) 2001 Kostas Michalopoulos aka Bad Sector          */
/*                                                              */
/****************************************************************/

#include <string.h>
#include <stdio.h>
#include <mem.h>

#define TRUE 1
#define FALSE 0

typedef struct t_topic
{
  char name[51];
  int pos, size;
} t_topic;

typedef struct t_head
{
  char ID[5];
  int version;
  int topics;
} t_head;

FILE *f, *o;
t_head head;
fpos_t datapos;

void go_label(char *lab, FILE *f)
{
  char *s = (char *) malloc(32767);
  char z[256];
  strcpy(z, ".topic ");
  strcat(z, lab);
  rewind(f);
  while (!feof(f)) {
    fgets(s, 32767, f);
    if (s && strlen(s) > 0) s[strlen(s)-1]=0;
    if (!stricmp(s, z)) {
      free(s);
      return;
    };
  };
  free(s);
}

void write_topic(int n, FILE *f, FILE *o)
{
  fpos_t pos = sizeof(head)+n*sizeof(t_topic);
  t_topic rec;
  int size, i;
  char *s = (char *) malloc(32767);

  fsetpos(o, &pos);
  fread(&rec, sizeof(rec), 1, o);
  fsetpos(o, &datapos);
  rec.pos = datapos;
  go_label(rec.name, f);
  size = 0;
  do {
    fgets(s, 32767, f);
    if (s && strlen(s) > 0) s[strlen(s)-1]=0;
    if (!stricmp(s, ".END")) break;
    for (i=0;i<strlen(s);i++) {
      size++;
      fwrite(s+i, 1, 1, o);
    };
  } while (!feof(f));
  rec.size = size;
  fgetpos(o, &datapos);
  fsetpos(o, &pos);
  fwrite(&rec, sizeof(rec), 1, o);

  free(s);
}

int main(int argc, char **argv[])
{
  int i;
  char *s = (char *) malloc(32767);
  t_topic rec;
  int quiet = FALSE;
  if (argc == 1 || !strcmp(argv[1], "/?") || !strcmp(argv[1], "-h")) {
    printf("Bad Seal Help System (HELP) Source Code Compiler 0.1 by Bad Sector\n");
    printf("(C) 2001 Kostas Michalopoulos aka Bad Sector\n");
    printf("Use:\n");
    printf("  HELPC filename.hls\n");
    return 0;
  };
  if (argc > 2 && !stricmp(argv[2], "-Q")) quiet = TRUE;
  if (!quiet) {
    printf("Bad Seal Help System (HELP) Source Code Compiler 0.1 by Bad Sector\n");
    printf("(C) 2001 Kostas Michalopoulos aka Bad Sector\n");
  };
  f = fopen(argv[1], "rt");
  if (!f) {
    if (!quiet) printf("fatal error.\n");
    return 1;
  };
  s[0]=0;
  for (i=0;i<strlen(argv[1]);i++) {
    s[i] = ((char *) argv[1])[i];
    if (s[i] == '.') {
      s[i+1] = 0;
      break;
    };
  };
  if (s[strlen(s)-1] != '.') strcat(s, ".");
  strcat(s, "hlp");
  o = fopen(s, "wb+");
  if (!o) {
    if (!quiet) printf("fatal error.\n");
    fclose(f);
    return 2;
  };
  head.ID[0] = 'B';
  head.ID[1] = 'S';
  head.ID[2] = 'H';
  head.ID[3] = 'L';
  head.ID[4] = 'P';
  head.version = 0;
  head.topics = 0;
  fwrite(&head, sizeof(t_head), 1, o);

  while (fgets(s, 32767, f)) {
    s[strlen(s)-1]=0;
    if (strlen(s) > 7) s[6] = 0;
    if (!stricmp(s, ".TOPIC")) {
      memset(&rec, 0, sizeof(rec));
      strcpy(rec.name, s+7);
      head.topics++;
      fwrite(&rec, sizeof(rec), 1, o);
    };
  };
  fgetpos(o, &datapos);

  for (i=0;i<head.topics;i++) write_topic(i, f, o);

  free(s);

  datapos = 0;
  fsetpos(o, &datapos);
  fwrite(&head, sizeof(t_head), 1, o);

  fclose(o);
  fclose(f);
  if (!quiet) printf("Compiled.\n\n");
  return 0;
}

