/* Extension Installer for Bad Seal 0.53 and other registry-based SEAL distros */
/* Version 1.0 (C) 2001 Kostas Michalopoulos aka Bad Sector              */
/* e-mail: michalopoylos@hotmail.com         www: http://www.badseal.org */

#include <string.h>
#include <stdio.h>
#include "registry.h"

#define FTYPES "SYSTEM/FILETYPES"

main(int argc, char **argv[])
{
  char *desc = (char *) malloc(256);
  char keyname[255];
  char *s = argv[1];
  int i, j;
  FILE *f;

  printf("Extension Installer 1.0 (C) 2001 Kostas Michalopoulos aka Bad Sector\n");
  init_registry();
  if (argc < 3 || !strcmp(argv[1], "/?") || !strcmp(argv[1], "-h")) {
    printf("Usage:\n\n  C:\\BADSEAL>EXTINST <ext> <runner> [description]\n\n");
    printf("Where <ext> is the extension that will be installed, <runner> is the\n");
    printf("program that will be used to open this kind of files and <description>\n");
    printf("is the description of files with this extension (maximum 255 chars).\n\n");
    printf("Example:\n\n  C:\\BADSEAL>EXTINST zip ./programs/apps/sealzip.exe SealZIP archives\n\n");
    printf("Note: to remove an extension delete it from key SYSTEM/FILETYPES\n");
    printf("using Registry Editor available from http://www.badseal.org/\n");
    free(desc);
    return 0;
  };
  strcpy(desc, "");
  for (i=3;i<argc;i++) {
    strcat(desc, argv[i]);
    if (i<argc-1) strcat(desc, " ");
  };
  j = 0;
  for (i=0;i<strlen(s);i++) {
    if (s[i] == '.') break;
    keyname[j] = s[i];
    j++;
  };
  keyname[j] = 0;
  printf("Trying to add %s (key: %s)...", s, keyname);
  if (create_key(FTYPES, keyname) != RE_SUCCESS) {
    printf(" ER1: Cannot create registry key\n");
    free(desc);
    return 1;
  } else printf(".");
  if (create_key(key_in_path(FTYPES, keyname), "loader") != RE_SUCCESS) {
    printf(" ER2: Cannot create registry key (loader)\n");
    free(desc);
    return 2;
  } else printf(".");
  if (create_key(key_in_path(FTYPES, keyname), "mime") != RE_SUCCESS) {
    printf(" ER2: Cannot create registry key (mime)\n");
    free(desc);
    return 2;
  } else printf(".");
  set_key(key_in_path(FTYPES, keyname), desc);
  printf(".");
  set_key(key_in_path(key_in_path(FTYPES, keyname), "mime"), "");
  printf(".\n");
  set_key(key_in_path(key_in_path(FTYPES, keyname), "loader"), argv[2]);
  printf(". added\n");

  free(desc);
  return 0;
}

