/* DLX Installer for Bad Seal 0.53 and other registry-based SEAL distros */
/* Version 1.0 (C) 2001 Kostas Michalopoulos aka Bad Sector              */
/* e-mail: michalopoylos@hotmail.com         www: http://www.badseal.org */

#include <string.h>
#include <stdio.h>
#include "registry.h"

#define STARTUP "SYSTEM/STARTUP/LOAD"

main(int argc, char **argv[])
{
  char *desc = (char *) malloc(256);
  char keyname[255];
  char *s = argv[1];
  int i, j;
  FILE *f;

  printf("DLX Installer 1.0 (C) 2001 Kostas Michalopoulos aka Bad Sector\n");
  printf("BUGFIXED VERSION! Sorry for the bug in very first version\n");
  init_registry();
  if (argc == 1 || !strcmp(argv[1], "/?") || !strcmp(argv[1], "-h")) {
    printf("Usage:\n\n  C:\\BADSEAL>DLXINST <filename.dlx> [description]\n\n");
    printf("Where <filename.dlx> is the full filename of DLX that will be installed and\n");
    printf("<description> is the description of the DLX file (maximum 255 chars).\n\n");
    printf("Example:\n\n  C:\\BADSEAL>DLXINST sscript.dlx SealScript library version 0.1\n\n");
    printf("Note: to remove a DLX from load process delete it from key SYSTEM/STARTUP/LOAD\n");
    printf("using Registry Editor available from http://www.badseal.org/\n");
    printf("\nType DLXINST -e to view information about DLXINST error codes.\n");
    free(desc);
    return 0;
  };
  if (!strcmp(argv[1], "-e")) {
    printf("DLXINST's error codes:\n\n");
    printf("Error code 1 (ER1): Cannot create registry key\n");
    printf("  that happens if DLXINST is unable to create registry key for DLX\n");
    printf("Error code 2 (ER2): Cannot create registry key (title)\n");
    printf("  that happens if DLXINST is able to create registry key for DLX but not\n for DLX's title. However key for DLX will be created but will be blank.\n");
    printf("Error code 3 (ER3): Cannot find file - filename.dlx\n");
    printf("  that happens if DLXINST is unable to find the given file.\n\n");
    printf("Using DOS's batch files you can handle DLXINST's error codes using\n");
    printf("the IF ERRORLEVEL command like this:\n\n");
    printf("  IF ERRORLEVEL <code> GOTO <label>\n\n");
    printf("where <code> is a number from 1 to 3 and <label> a normal label in\n");
    printf("the batch file (see a DOS guide about batch files).\n");
    free(desc);
    return 0;
  };
  strcpy(desc, "");
  for (i=2;i<argc;i++) {
    strcat(desc, argv[i]);
    if (i<argc-1) strcat(desc, " ");
  };
  j = 0;
  for (i=0;i<strlen(s);i++) {
    if (s[i] == '.') break;
    keyname[j] = s[i];
    j++;
  };
  keyname[j] = 0;
  printf("Trying to add %s (key: %s)...", s, keyname);
  if (create_key(STARTUP, keyname) != RE_SUCCESS) {
    printf(" ER1: Cannot create registry key\n");
    free(desc);
    return 1;
  } else printf(".");
  if (create_key(key_in_path(STARTUP, keyname), "title") != RE_SUCCESS) {
    printf(" ER2: Cannot create registry key (title)\n");
    free(desc);
    return 2;
  } else printf(".");
  set_key(key_in_path(STARTUP, keyname), argv[1]);
  printf(".");
  set_key(key_in_path(key_in_path(STARTUP, keyname), "title"), desc);
  printf(". added\n");

  free(desc);
  return 0;
}

