#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "dialogs.h"
#include "button.h"

#ifdef Bad_Seal
static DATAFILE *dat = NULL;
#endif

p_appwin main = NULL;

static p_menu app_menu()
{
  p_menu menu = new_menu(
    new_sub_menu("File", new_menu(
      new_menu_item("Quit...", "ALT+F4", TO_ALT(KB_F4), MSG_CLOSE, NULL,
    NULL)),
  NULL));

  return menu;
};

static void trans_ev(p_object o, p_event event)
{
  if (event->type == EV_MESSAGE) {
    /* Message handling goes here */
  };
}

void app_init()
{
  p_menuview menu;

  t_rect r = rect_assign(0, 0, 300, 200);
  main = appwin_init(malloc(sizeof(t_appwin)), r, "application", WF_MINIMIZE|WF_MAXIMIZE, ap_id, &trans_ev);
  VIEW(main)->align |= TX_ALIGN_CENTER;
  #ifdef Bad_Seal
  main->icon16 = (BITMAP*)GET_DATA(dat, 0); /* read from resource */
  main->menu = standard_system_menu_items(main,
               new_menu_line(
               new_menu_item("Quit Bad Seal...", 0, 0, MSG_QUIT, NULL,
  NULL)));
  #endif
  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(main));

  r = rect_assign(2, 20, 298, 40);
  menu = hormenu_init(malloc(sizeof(t_menuview)), r, app_menu());
  VIEW(menu)->align |= TX_ALIGN_RIGHT;
  OBJECT(main)->insert(OBJECT(main), OBJECT(menu));
}

app_begin(void)
{
  if (ap_process == AP_INIT) {
    #ifdef Bad_Seal
    dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    #endif

    app_init();
  };
  if (ap_process == AP_DONE) {
  };
} app_end;
