/* BADCTRLS.DLX example */
#include "allegro.h"
#include "seal.h"
#include "app.h"
#include "badctrls.h"

#define MSG_CBOX 1000001
#define MSG_BB1 1000010
#define MSG_BB2 1000011
#define MSG_VTB1 1000100

static DATAFILE *dat = NULL;
#define ICO_GET(n) (BITMAP*)GET_DATA(dat, n)

p_appwin main;

p_bad_checkbox cbox;
p_bad_checkbox cbox2;

p_bad_button bb1;
p_bad_button bb2;

p_bad_vtrackbar vtb1;

p_bad_tabbook tb1;

p_bad_iconbox ib1;

/*
p_bad_filebox fb1;

p_bad_scrollbar sb1;
*/

l_int ns = 1;

static char *int_to_str(long i)
{
  char *s = (char *) malloc(11); 
  itoa(i, s, 10);
  return s;
}

static void handle_event(p_object o, p_event event)
{
  if (event->type == EV_MESSAGE) {
    switch (event->message) {
      case MSG_CBOX: {
        if (cbox->state == 0) msgbox(MW_INFO, MB_OK, "1st CheckBox is unchecked");
        if (cbox->state == 1) msgbox(MW_INFO, MB_OK, "1st CheckBox is checked");
        clear_event(event);
      } break;
      case MSG_CBOX+1: {
        if (cbox2->state == 1) cbox->change_state(cbox, 2); else cbox->change_state(cbox, 0);
        clear_event(event);
      } break;
      case MSG_BB1: {
        bb1->change_style(bb1, ns);
        vtb1->change_pos(vtb1, ns);
        switch (ns) {
          case 0: {
            bb1->change_caption(bb1, "SEAL Style");
          } break;
          case 1: {
            bb1->change_caption(bb1, "Bad Seal Style");
          } break;
          case 2: {
            bb1->change_caption(bb1, "KDE Style");
          } break;
          case 3: {
            bb1->change_caption(bb1, "Win95 Style");
          } break;
          case 4: {
            bb1->change_caption(bb1, "Win 3.1 Style");
          } break;
          case 5: {
            bb1->change_caption(bb1, "Modern Style");
          } break;
          case 6: {
            bb1->change_caption(bb1, "Liquid Style");
          } break;
        };
        ns++;
        if (ns > 6) ns = 0;
        clear_event(event);
      } break;
      case MSG_VTB1: {
        bb1->change_style(bb1, vtb1->pos);
        bb1->change_caption(bb1, "hey!");
      } break;
      case MSG_BB2: {
        msgbox(MW_INFO, MB_OK, "Hello, world!");
        msgbox(MW_INFO, MB_OK, "Selecting third tab...");
        tb1->select_tab(tb1, 2);
        msgbox(MW_INFO, MB_OK, "...done");
      } break;
    };
  }
}

/*
void sb1_on_change(p_bad_scrollbar o, l_long pos)
{
  char ii[20];
  itoa(pos, ii, 10);
  bb1->change_caption(bb1, ii);
};
*/

void app_init()
{
  t_rect r = rect_assign(0, 0, 300, 420);

  /* initialize edited window */
  main = appwin_init(malloc(sizeof(t_appwin)), r, "Bad Controls example", WF_MINIMIZE, ap_id, &handle_event);
  VIEW(main)->align |= TX_ALIGN_CENTER;
  OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(main));

  r = rect_assign(10, 40, 140, 56);
  cbox = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "Check me", MSG_CBOX, false);
  OBJECT(main)->insert(OBJECT(main), OBJECT(cbox));

  r = rect_assign(10, 60, 140, 76);
  cbox2 = bad_checkbox_init(malloc(sizeof(t_bad_checkbox)), r, "1st chkbox grayed", MSG_CBOX+1, false);
  OBJECT(main)->insert(OBJECT(main), OBJECT(cbox2));

  r = rect_assign(10, 80, 120, 140);
  bb1 = bad_button_init(malloc(sizeof(t_bad_button)), r, "SEAL Style", BBS_SEAL, MSG_BB1);
  OBJECT(main)->insert(OBJECT(main), OBJECT(bb1));

  r = rect_assign(150, 40, 200, 140);
  vtb1 = bad_vtrackbar_init(malloc(sizeof(t_bad_vtrackbar)), r, MSG_VTB1);
  vtb1->max = 6;
  OBJECT(main)->insert(OBJECT(main), OBJECT(vtb1));

  r = rect_assign(10, 150, 290, 410);
  tb1 = bad_tabbook_init(malloc(sizeof(t_bad_tabbook)), r, "Files");
  OBJECT(main)->insert(OBJECT(main), OBJECT(tb1));
  tb1->add_tab(tb1, "Tab 2");
  tb1->add_tab(tb1, "Tab 3");

  r = rect_assign(10, 10, 270, 240);
  ib1 = bad_iconbox_init(malloc(sizeof(t_bad_iconbox)), r, 0);
  ib1->add(ib1, ICO_GET(2), "My Computer");
  ib1->add(ib1, ICO_GET(0), "Documents");
  ib1->add(ib1, ICO_GET(0), "Personal");
  ib1->add(ib1, ICO_GET(1), "Help");
  OBJECT(tb1->tab[0])->insert(OBJECT(tb1->tab[0]), OBJECT(ib1));

  r = rect_assign(30, 100, 120, 170);
  bb2 = bad_button_init(malloc(sizeof(t_bad_button)), r, "Button in tab 2", BBS_SEAL, MSG_BB2);
  OBJECT(tb1->tab[1])->insert(OBJECT(tb1->tab[1]), OBJECT(bb2));

  r = rect_assign(50, 120, 140, 190);
  bb2 = bad_button_init(malloc(sizeof(t_bad_button)), r, "Button in tab 3", BBS_SEAL, MSG_BB2);
  OBJECT(tb1->tab[2])->insert(OBJECT(tb1->tab[2]), OBJECT(bb2));

}

app_begin(void)
{
  if (ap_process == AP_INIT) {
    dat = conv_to_skipcolor_data(DLXGetFileData(ap_id), CO_SKIP_RED, CO_SKIP_GREEN, CO_SKIP_BLUE);
    app_init();
  };
} app_end;

